/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.freeradius;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.jradius.packet.RadiusFormat;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public class FreeRadiusFormat
extends RadiusFormat {
    private static final FreeRadiusFormat staticFormat = new FreeRadiusFormat();

    public static void setAttributeBytes(RadiusPacket p, byte[] bAttributes) {
        int attributesLength = bAttributes.length;
        if (attributesLength > 0) {
            staticFormat.unpackAttributes(p.getAttributes(), bAttributes, attributesLength);
        }
    }

    public void packHeader(DataOutputStream pOut, RadiusPacket p, byte[] attributeBytes) throws IOException {
        pOut.writeByte(p.getCode());
        pOut.writeByte(p.getIdentifier());
        pOut.writeInt(attributeBytes.length);
    }

    public void packHeader(DataOutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        out.writeInt(a.getFormattedType());
        out.writeInt(attributeValue.getLength());
        out.writeInt(a.getAttributeOp());
    }

    protected int unpackAttributeHeader(DataInputStream in, RadiusFormat.AttributeParseContext ctx) throws IOException {
        ctx.attributeType = in.readInt();
        ctx.attributeLength = in.readInt();
        ctx.attributeOp = in.readInt();
        if (ctx.attributeType > 65536) {
            ctx.vendorNumber = ctx.attributeType >> 16 & 0xFFFF;
            ctx.attributeType &= 0xFFFF;
        }
        return 12;
    }
}

