/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler;

import net.sf.jradius.exception.StandardViolatedException;
import net.sf.jradius.handler.PacketHandlerBase;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.RadiusRequest;
import net.sf.jradius.packet.RadiusResponse;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.standard.RadiusStandard;

public class StandardCheckingHandler
extends PacketHandlerBase {
    private RadiusStandard standard;

    public boolean handle(JRadiusRequest request) throws Exception {
        if (this.standard == null) {
            return false;
        }
        RadiusPacket req = request.getRequestPacket();
        RadiusPacket rep = request.getReplyPacket();
        String errMessage = "";
        StandardViolatedException ex = null;
        if (req instanceof RadiusRequest) {
            try {
                this.standard.checkPacket(req);
            }
            catch (StandardViolatedException e) {
                errMessage = errMessage + ": Request Missing: " + e.listAttributes();
                ex = e;
            }
        }
        if (rep instanceof RadiusResponse) {
            try {
                this.standard.checkPacket(rep);
            }
            catch (StandardViolatedException e) {
                errMessage = errMessage + ": Response Missing: " + e.listAttributes();
                ex = e;
            }
        }
        if (ex != null) {
            RadiusLog.problem(request, request.getSession(), ex, errMessage.substring(2));
        }
        return false;
    }

    public void setStandardName(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            this.setStandard((RadiusStandard)clazz.newInstance());
        }
        catch (Exception e) {
            RadiusLog.error("Could not initialize RadiusStandard " + name + ": " + e.getMessage());
        }
    }

    public RadiusStandard getStandard() {
        return this.standard;
    }

    public void setStandard(RadiusStandard standard) {
        this.standard = standard;
    }
}

