/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler.accounting;

import net.sf.jradius.dictionary.Attr_Class;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.handler.RadiusSessionHandler;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;

public class AccountingClassHandler
extends RadiusSessionHandler {
    public boolean handle(JRadiusRequest request) throws RadiusException {
        String sClass;
        JRadiusSession session = request.getSession();
        if (session == null) {
            session = this.buildSession(request);
        }
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket req = request.getRequestPacket();
        byte[] bClass = (byte[])req.getAttributeValue(25);
        if (bClass != null && (sClass = new String(bClass)).startsWith("JRADIUS-CLASS:")) {
            if (session.getRadiusClass() != null) {
                req.overwriteAttribute((RadiusAttribute)new Attr_Class(session.getRadiusClass()));
            } else {
                req.removeAttribute(25);
            }
            return false;
        }
        session.addLogMessage(request, "Accounting without Class Attribute");
        return false;
    }
}

