/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler.accounting;

import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.handler.RadiusSessionHandler;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.log.RadiusLogEntry;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;

public class UpdateSessionHandler
extends RadiusSessionHandler {
    public boolean handle(JRadiusRequest request) throws RadiusException {
        JRadiusSession session = request.getSession();
        if (session == null) {
            session = this.buildSession(request);
        }
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket req = request.getRequestPacket();
        if (!(req instanceof AccountingRequest)) {
            return false;
        }
        AccountingRequest accountingRequest = (AccountingRequest)req;
        switch (accountingRequest.getAccountingStatusType()) {
            case -1: {
                return this.onNoAccountingStatusType(request);
            }
            case 1: {
                this.ensureSessionState(request, session, 1);
                session.setSessionState(3);
                break;
            }
            case 2: {
                this.ensureSessionState(request, session, 3);
                session.setSessionState(4);
                break;
            }
            case 3: {
                this.ensureSessionState(request, session, 3);
            }
        }
        session.updateSession(request);
        return false;
    }

    protected boolean onNoAccountingStatusType(JRadiusRequest request) throws RadiusException {
        JRadiusSession session = request.getSession();
        RadiusLogEntry logEntry = session.getLogEntry(request);
        String error = "Accounting packet without a Acct-Status-Type!";
        RadiusLog.error(error);
        logEntry.addMessage(error);
        request.setReturnValue(0);
        return true;
    }
}

