/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler.proxy;

import java.util.Arrays;
import net.sf.jradius.dictionary.Attr_Class;
import net.sf.jradius.handler.RadiusSessionHandler;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;

public class ProxyClassHandler
extends RadiusSessionHandler {
    public boolean handle(JRadiusRequest request) throws Exception {
        JRadiusSession session = request.getSession();
        if (session == null) {
            session = this.buildSession(request);
        }
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket req = request.getRequestPacket();
        byte[] packetClass = (byte[])req.getAttributeValue(25);
        byte[] sessionClass = session.getRadiusClass();
        if (packetClass != null || sessionClass != null) {
            if (sessionClass == null) {
                session.addLogMessage(request, "Request has Class attribute when it should not");
            } else if (packetClass == null) {
                session.addLogMessage(request, "Missing Class Attribute (added)");
                req.overwriteAttribute((RadiusAttribute)new Attr_Class(sessionClass));
            } else if (!Arrays.equals(packetClass, sessionClass)) {
                session.addLogMessage(request, "Bad Class Attribute (replaced)");
                req.overwriteAttribute((RadiusAttribute)new Attr_Class(sessionClass));
            }
        }
        return false;
    }
}

