/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler.tlstunnel;

import java.util.HashMap;
import java.util.StringTokenizer;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.handler.RadiusSessionHandler;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.session.JRadiusSessionManager;
import net.sf.jradius.session.RadiusSessionKeyProvider;

public class InitTunnelSessionHandler
extends RadiusSessionHandler {
    private HashMap realms = new HashMap();

    public boolean handle(JRadiusRequest request) throws RadiusException {
        int type = request.getType();
        RadiusPacket req = request.getRequestPacket();
        String fullUserName = (String)req.getAttributeValue(1);
        String stripUserName = null;
        String realm = null;
        JRadiusSession session = request.getSession();
        if (fullUserName == null) {
            return false;
        }
        stripUserName = fullUserName;
        String[] s = this.splitUserName(stripUserName);
        if (s != null && s.length == 2) {
            stripUserName = s[0];
            realm = s[1];
        }
        if (type == 2 && req.findAttribute(743440385) != null) {
            RadiusSessionKeyProvider skp = (RadiusSessionKeyProvider)JRadiusSessionManager.getManager().getSessionKeyProvider(request.getSender());
            String sessionKey = (String)tlsTunnels.get(skp.getTunneledRequestKey(request));
            if (sessionKey == null) {
                request.setReturnValue(0);
                return true;
            }
            session = JRadiusSessionManager.getManager().getSession(sessionKey);
            if (session == null) {
                throw new RadiusException("Could not find on-going tunneled session: " + sessionKey);
            }
            session.setUsername(stripUserName);
            session.setRealm(realm);
            request.setSession(session);
            String r = (String)req.getAttributeValue(1045);
            if (r != null) {
                if ("DEFAULT".equals(r)) {
                    r = realm;
                }
                if (!this.isLocalRealm(r)) {
                    session.setProxyToRealm(r);
                }
            }
        }
        return false;
    }

    public void setLocalRealms(String localRealms) {
        StringTokenizer st = new StringTokenizer(localRealms, ",");
        while (st.hasMoreTokens()) {
            String realm = st.nextToken();
            this.realms.put(realm.trim().toLowerCase(), "local");
        }
    }

    public void setSecureRealms(String localRealms) {
        StringTokenizer st = new StringTokenizer(localRealms, ",");
        while (st.hasMoreTokens()) {
            String realm = st.nextToken();
            this.realms.put(realm.trim().toLowerCase(), "secure");
        }
    }

    public boolean isLocalRealm(String realm) {
        String s = (String)this.realms.get(realm.trim().toLowerCase());
        if (s == null) {
            return false;
        }
        return "local".equals(s);
    }

    public boolean isSecureRealm(String realm) {
        String s = (String)this.realms.get(realm.trim().toLowerCase());
        if (s == null) {
            return false;
        }
        return "secure".equals(s);
    }
}

