/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.ipdr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.sf.jradius.exception.UnknownAttributeException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.session.JRadiusSession;
import org.ipdr.common.BadCompositeException;
import org.ipdr.common.CompositeData;
import org.ipdr.common.Descriptor;
import org.ipdr.common.DescriptorContentHandler;
import org.ipdr.common.FNFData;
import org.ipdr.common.FNFType;
import org.ipdr.common.IPDRDocWriter;
import org.ipdr.common.NameSpaceInfo;
import org.ipdr.common.OpenType;
import org.ipdr.common.Schema;
import org.ipdr.utils.IPDRException;
import org.ipdr.utils.UUIDUtil;
import org.xml.sax.SAXException;

public abstract class IPDR_Base {
    private static final LinkedHashMap typeIndexMap = new LinkedHashMap();
    protected static final String defaultNameSpaceBase = "http://www.ipdr.org/namespaces/";
    protected static final String defaultNameSpaceURI = "http://www.ipdr.org/namespaces/ipdr";
    protected static final String defaultIPDRBaseURI = "http://www.ipdr.org/public/";
    protected OpenType[] openType;
    protected String serviceType;
    protected String schemaURI;
    protected int openTypeLength;

    protected IPDR_Base(String schemaURI) throws IOException, IPDRException, SAXException {
        int i;
        this.schemaURI = schemaURI;
        Descriptor descriptor = new Descriptor();
        ArrayList schemaArray = descriptor.parseSchema(schemaURI);
        DescriptorContentHandler dch = descriptor.getContentHandler();
        ArrayList location = dch.getSchemaLocation();
        this.serviceType = descriptor.getServType();
        for (int uriPos = 0; uriPos < location.size(); ++uriPos) {
            String extn = dch.getExtensionBase();
            if (extn.equalsIgnoreCase("ipdr:IPDRType")) continue;
            schemaArray.addAll(0, descriptor.parseSchema(location.get(uriPos).toString()));
        }
        ArrayList nameSpaceInfo = dch.getURIStorage();
        String nameSpaceURI = null;
        String nameSpaceID = null;
        ArrayList<NameSpaceInfo> localNameSpaceInfo = new ArrayList<NameSpaceInfo>();
        for (int count = 0; count < nameSpaceInfo.size(); ++count) {
            nameSpaceURI = ((NameSpaceInfo)nameSpaceInfo.get(count)).getNameSpaceURI();
            nameSpaceID = ((NameSpaceInfo)nameSpaceInfo.get(count)).getNameSpaceID();
            if (nameSpaceID.equals("") || nameSpaceID.equals("ipdr")) continue;
            NameSpaceInfo NSInfo = new NameSpaceInfo(nameSpaceURI, nameSpaceID);
            localNameSpaceInfo.add(NSInfo);
        }
        String name = null;
        for (i = 0; i < schemaArray.size(); i += 3) {
            name = (String)schemaArray.get(i);
            int colonPos = name.indexOf("$");
            String fnfURI = name.substring(0, colonPos);
            String fnfNSID = new String();
            for (int j = 0; j < localNameSpaceInfo.size(); ++j) {
                if (!((NameSpaceInfo)localNameSpaceInfo.get(j)).getNameSpaceURI().equals(fnfURI)) continue;
                fnfNSID = ((NameSpaceInfo)localNameSpaceInfo.get(j)).getNameSpaceID();
            }
            if (!fnfNSID.equals("")) {
                name = name.substring(colonPos + 1, name.length());
                name = fnfNSID + ":" + name;
                schemaArray.add(i, name);
                schemaArray.remove(i + 1);
                continue;
            }
            name = name.substring(colonPos + 1, name.length());
            schemaArray.add(i, name);
            schemaArray.remove(i + 1);
        }
        try {
            this.openType = descriptor.createOpenTypes(schemaArray);
            this.openTypeLength = this.openType.length;
            for (i = 0; i < this.openTypeLength; ++i) {
                typeIndexMap.put(this.openType[i].getName().toLowerCase(), new TypeIndex(i, this.openType[i]));
            }
        }
        catch (BadCompositeException e) {
            RadiusLog.error(e.getMessage());
        }
    }

    protected abstract String getServiceType();

    protected abstract String getNameSpaceID();

    protected String getNameSpacePrefix() {
        String ns = this.getNameSpaceID();
        if (ns == null) {
            return null;
        }
        return ns + ":";
    }

    protected abstract Object[] getIPDRData(JRadiusSession var1, RadiusPacket var2) throws Exception;

    public String toXML(JRadiusSession radiusSession) throws Exception {
        RadiusPacket p = radiusSession.getLastRadiusRequest().getRequestPacket();
        if (!(p instanceof AccountingRequest)) {
            RadiusLog.error("Can not build IPDR for session without accounting");
            return null;
        }
        if (((AccountingRequest)p).getAccountingStatusType() != 2) {
            RadiusLog.error("Can not build IPDR for session without STOP record");
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String[] serviceDefinitionURIs = new String[]{this.schemaURI};
        String ns = this.getNameSpaceID();
        NameSpaceInfo[] otherNameSpaces = ns != null ? new NameSpaceInfo[]{new NameSpaceInfo(defaultNameSpaceBase + ns, ns)} : new NameSpaceInfo[]{};
        String[] schemaNameSpaces = new String[]{defaultNameSpaceURI};
        Schema s = new Schema();
        s.setSchemaData(otherNameSpaces, serviceDefinitionURIs, defaultNameSpaceURI);
        IPDRDocWriter w = new IPDRDocWriter((OutputStream)out, 0);
        w.setSchema(s);
        w.writeHeader("JRadius", System.currentTimeMillis(), s.getDefaultNameSpaceURI(), s.getOtherNameSpaces(), schemaNameSpaces, s.getServiceDefinitionURIs(), UUIDUtil.getNewUUID());
        Object[] obj = this.getIPDRData(radiusSession, p);
        int nonNull = 0;
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) continue;
            ++nonNull;
        }
        Object[] finalObj = new Object[nonNull];
        OpenType[] finalType = new OpenType[nonNull];
        int c = 0;
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) continue;
            finalObj[c] = obj[i];
            finalType[c] = this.openType[i];
            ++c;
        }
        FNFType type = new FNFType(this.getNameSpacePrefix() + this.getServiceType(), finalType, "");
        FNFData data = new FNFData(finalObj, type);
        w.writeIPDR((CompositeData)data);
        w.writeEnd(System.currentTimeMillis());
        out.close();
        return out.toString();
    }

    protected void attributeToField(RadiusPacket p, Object[] obj, int attribute, String element) throws BadCompositeException, UnknownAttributeException {
        RadiusAttribute attr = p.findAttribute(attribute);
        TypeIndex ti = this.getTypeIndex(element);
        if (ti == null) {
            return;
        }
        if (attr != null) {
            Object o = attr.getValue().getValueObject();
            String s = attr.getValue().toString();
            switch (ti.openType.getTypeCode()) {
                case 'B': {
                    obj[ti.index] = attr.getValue().getBytes();
                    break;
                }
                case 'X': {
                    obj[ti.index] = s;
                    break;
                }
                case 'I': {
                    if (o instanceof Number) {
                        obj[ti.index] = new Integer(((Number)o).intValue());
                        break;
                    }
                    obj[ti.index] = Integer.valueOf(s);
                    break;
                }
                default: {
                    throw new BadCompositeException("unsupported field type");
                }
            }
        }
    }

    protected void addData(Object[] obj, String element, Object val, Object defVal) {
        TypeIndex ti = this.getTypeIndex(element);
        if (ti == null) {
            return;
        }
        if (val == null) {
            val = defVal;
        }
        if (val == null) {
            return;
        }
        obj[ti.index] = val;
    }

    private TypeIndex getTypeIndex(String element) {
        String key = this.getNameSpacePrefix() + element;
        TypeIndex ti = (TypeIndex)typeIndexMap.get(key.toLowerCase());
        if (ti == null) {
            RadiusLog.error("IPDR: Could not find element " + element + " in service definition");
            return null;
        }
        return ti;
    }

    private class TypeIndex {
        public int index;
        public OpenType openType;

        public TypeIndex(int i, OpenType t) {
            this.index = i;
            this.openType = t;
        }
    }
}

