/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet.attribute;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.exception.UnknownAttributeException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.attribute.AttributeDescription;
import net.sf.jradius.packet.attribute.AttributeDictionary;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.VSADictionary;

public final class AttributeFactory {
    private static LinkedHashMap attributeMap = new LinkedHashMap();
    private static LinkedHashMap vendorMap = new LinkedHashMap();
    private static LinkedHashMap attributeNameMap = new LinkedHashMap();

    public static boolean loadAttributeDictionary(String className) {
        AttributeDictionary dict = null;
        try {
            Class<?> dClass = Class.forName(className);
            if (dClass == null) {
                return false;
            }
            dict = (AttributeDictionary)dClass.newInstance();
        }
        catch (Exception e) {
            return false;
        }
        dict.loadAttributes(attributeMap);
        dict.loadAttributesNames(attributeNameMap);
        dict.loadVendorCodes(vendorMap);
        Iterator i = vendorMap.keySet().iterator();
        while (i.hasNext()) {
            Integer id = (Integer)i.next();
            Class c = (Class)vendorMap.get(id);
            try {
                LinkedHashMap map = new LinkedHashMap();
                VSADictionary vsadict = (VSADictionary)c.newInstance();
                vsadict.loadAttributes(map);
                vsadict.loadAttributesNames(attributeNameMap);
                vendorMap.put(id, new VendorValue(c, map));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static RadiusAttribute attributeFromString(String src) throws RadiusException, UnknownAttributeException {
        String[] parts = src.split("=", 2);
        if (parts.length == 2) {
            String attribute = parts[0].trim();
            String value = parts[1].trim();
            char q = value.charAt(0);
            if (q == value.charAt(value.length() - 1) && (q == '\'' || q == '\"')) {
                value = value.substring(1, value.length() - 1);
            }
            return AttributeFactory.newAttribute(attribute, value, "=");
        }
        throw new RadiusException("Syntax error for attributes: " + src);
    }

    public static void loadAttributesFromString(AttributeList list, String src, boolean beStrinct) throws RadiusException {
        StringTokenizer st = new StringTokenizer(src, "\n");
        while (st.hasMoreTokens()) {
            try {
                list.add(AttributeFactory.attributeFromString(st.nextToken()));
            }
            catch (RadiusException e) {
                if (!beStrinct) continue;
                throw e;
            }
        }
    }

    public static RadiusAttribute newAttribute(int vendor, int type, byte[] value, int op) {
        Class c = null;
        RadiusAttribute attr = null;
        try {
            if (vendor > 0 || type == 26) {
                ByteArrayInputStream bais = new ByteArrayInputStream(value);
                DataInputStream input = new DataInputStream(bais);
                if (vendor < 0) {
                    vendor = input.readInt();
                    VendorValue v = (VendorValue)vendorMap.get(new Integer(vendor));
                    if (v != null) {
                        int subType = input.readByte() & 0xFF;
                        c = (Class)v.map.get(new Integer(subType));
                        attr = (RadiusAttribute)c.newInstance();
                        int vsaLength = input.readByte() & 0xFF;
                        byte[] vsaValue = new byte[vsaLength - 2];
                        input.readFully(vsaValue);
                        attr.setValue(vsaValue);
                        return attr;
                    }
                    RadiusLog.error("no vendor found with id: " + vendor);
                } else {
                    VendorValue v = (VendorValue)vendorMap.get(new Integer(vendor));
                    if (v != null) {
                        c = (Class)v.map.get(new Integer(type));
                    } else {
                        RadiusLog.error("no vendor found with id: " + vendor);
                    }
                }
            } else {
                c = (Class)attributeMap.get(new Integer(type));
            }
            if (c != null) {
                attr = (RadiusAttribute)c.newInstance();
                if (value != null) {
                    attr.setValue(value);
                }
                attr.setAttributeOp(op);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(int type, byte[] value) {
        return AttributeFactory.newAttribute(-1, type, value, -1);
    }

    public static RadiusAttribute newAttribute(String aName) throws UnknownAttributeException {
        Class c = (Class)attributeNameMap.get(aName);
        RadiusAttribute attr = null;
        if (c == null) {
            throw new UnknownAttributeException("Unknown attribute " + aName);
        }
        try {
            attr = (RadiusAttribute)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(AttributeDescription desc) throws UnknownAttributeException {
        return AttributeFactory.newAttribute(desc.getName(), desc.getValue(), desc.getOp());
    }

    public static RadiusAttribute newAttribute(String aName, String aValue, String aOp) throws UnknownAttributeException {
        RadiusAttribute attr = AttributeFactory.newAttribute(aName);
        attr.setAttributeOp(aOp);
        attr.setValue(aValue);
        return attr;
    }

    public static int getTypeByName(String aName) throws UnknownAttributeException {
        Class c = (Class)attributeNameMap.get(aName);
        RadiusAttribute attr = null;
        if (c == null) {
            throw new UnknownAttributeException("Unknown attribute " + aName);
        }
        try {
            attr = (RadiusAttribute)c.newInstance();
            return attr.getType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static LinkedHashMap getAttributeMap() {
        return attributeMap;
    }

    public static LinkedHashMap getAttributeNameMap() {
        return attributeNameMap;
    }

    public static LinkedHashMap getVendorMap() {
        return vendorMap;
    }

    public static final class VendorValue {
        private Class c;
        private Map map;

        public VendorValue(Class c, Map m) {
            this.c = c;
            this.map = m;
        }

        public Map getAttributeMap() {
            return this.map;
        }

        public Class getDictClass() {
            return this.c;
        }
    }
}

