/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet.attribute;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jradius.exception.UnknownAttributeException;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.RadiusAttribute;

public class AttributeList
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Map attrs = new LinkedHashMap();

    public void add(AttributeList list) {
        if (list != null) {
            this.attrs.putAll(list.getMap());
        }
    }

    public void add(RadiusAttribute a) {
        this.add(a, true);
    }

    public void add(RadiusAttribute a, boolean overwrite) {
        Integer key = new Integer(a.getFormattedType());
        Object o = this.attrs.get(key);
        if (o == null || overwrite) {
            this.attrs.put(key, a);
        } else if (o instanceof LinkedList) {
            ((LinkedList)o).add(a);
        } else {
            LinkedList<Object> l = new LinkedList<Object>();
            l.add(o);
            l.add(a);
            this.attrs.put(key, l);
        }
    }

    public void remove(RadiusAttribute a) {
        this.remove(a.getFormattedType());
    }

    public void remove(int attributeType) {
        Integer key = new Integer(attributeType);
        this.attrs.remove(key);
    }

    public int getSize() {
        return this.attrs.size();
    }

    public List getAttributeList() {
        LinkedList<Object> list = new LinkedList<Object>();
        Collection c = this.attrs.values();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o == null || !(o instanceof LinkedList)) {
                list.add(o);
                continue;
            }
            list.add(((LinkedList)o).toArray());
        }
        return list;
    }

    public Object get(int type, boolean single) {
        Integer key = new Integer(type);
        Object o = this.attrs.get(key);
        if (o == null || !(o instanceof LinkedList)) {
            return o;
        }
        LinkedList l = (LinkedList)o;
        return single ? l.get(0) : o;
    }

    public RadiusAttribute get(int type) {
        return (RadiusAttribute)this.get(type, true);
    }

    public Object get(String name, boolean single) throws UnknownAttributeException {
        return this.get(AttributeFactory.getTypeByName(name), single);
    }

    public RadiusAttribute get(String name) throws UnknownAttributeException {
        return (RadiusAttribute)this.get(AttributeFactory.getTypeByName(name), true);
    }

    public Object[] getArray(int type) {
        Integer key = new Integer(type);
        return this.toArray(this.attrs.get(key));
    }

    public String toString(boolean allAttribtues) {
        StringBuffer sb = new StringBuffer();
        Iterator attributeList = this.attrs.values().iterator();
        while (attributeList.hasNext()) {
            Object[] ol = this.toArray(attributeList.next());
            for (int i = 0; i < ol.length; ++i) {
                RadiusAttribute attr = (RadiusAttribute)ol[i];
                if (!allAttribtues && attr.attributeType >= 256) continue;
                sb.append(attr.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public Map getMap() {
        return this.attrs;
    }

    private Object[] toArray(Object o) {
        if (o == null) {
            return null;
        }
        Object[] ol = o instanceof LinkedList ? ((LinkedList)o).toArray() : new Object[]{o};
        return ol;
    }
}

