/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet.attribute.value;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public class StringValue
extends AttributeValue {
    protected String stringValue = null;

    public StringValue() {
    }

    public StringValue(String s) {
        this.stringValue = s;
    }

    public void getBytes(DataOutputStream out) throws IOException {
        if (this.stringValue != null) {
            out.write(this.stringValue.getBytes());
        }
    }

    public int getLength() {
        if (this.stringValue != null) {
            return this.stringValue.length();
        }
        return 0;
    }

    public void setValue(byte[] b) {
        if (b == null) {
            return;
        }
        this.stringValue = new String(b);
    }

    public String toString() {
        return this.stringValue;
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<string>");
        if (this.stringValue != null) {
            sb.append(this.stringValue);
        }
        sb.append("</string>");
        return sb.toString();
    }

    public Object getValueObject() {
        return this.stringValue;
    }

    public void setValueObject(Object o) {
        this.stringValue = (String)o;
    }
}

