/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jradius.handler.chain.JRCommand;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.server.EventDispatcher;
import net.sf.jradius.server.Listener;
import net.sf.jradius.server.ObjectQueue;
import net.sf.jradius.server.Processor;
import net.sf.jradius.server.config.Configuration;
import net.sf.jradius.server.config.DictionaryConfigurationItem;
import net.sf.jradius.server.config.ListenerConfigurationItem;

public class JRadiusServer {
    public static final int JRADIUS_authenticate = 1;
    public static final int JRADIUS_authorize = 2;
    public static final int JRADIUS_preacct = 3;
    public static final int JRADIUS_accounting = 4;
    public static final int JRADIUS_checksimul = 5;
    public static final int JRADIUS_pre_proxy = 6;
    public static final int JRADIUS_post_proxy = 7;
    public static final int JRADIUS_post_auth = 8;
    public static final int JRADIUS_max_request_type = 8;
    public static final int RLM_MODULE_REJECT = 0;
    public static final int RLM_MODULE_FAIL = 1;
    public static final int RLM_MODULE_OK = 2;
    public static final int RLM_MODULE_HANDLED = 3;
    public static final int RLM_MODULE_INVALID = 4;
    public static final int RLM_MODULE_USERLOCK = 5;
    public static final int RLM_MODULE_NOTFOUND = 6;
    public static final int RLM_MODULE_NOOP = 7;
    public static final int RLM_MODULE_UPDATED = 8;
    public static final int RLM_MODULE_NUMCODES = 9;
    private Collection processors = new LinkedList();
    private Collection listeners = new LinkedList();
    private static final EventDispatcher eventDispatcher = new EventDispatcher();
    static /* synthetic */ Class class$net$sf$jradius$server$config$ListenerConfigurationItem;

    public JRadiusServer() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.initializeServer();
    }

    public void start() {
        RadiusLog.info("Starting Event Dispatcher...");
        eventDispatcher.start();
        RadiusLog.info("Starting Processors...");
        Iterator i = this.processors.iterator();
        while (i.hasNext()) {
            Processor processor = (Processor)i.next();
            processor.start();
            RadiusLog.info("  Started processor " + processor.getName());
        }
        RadiusLog.info("Processors succesfully started.");
        RadiusLog.info("Starting Listeners...");
        i = this.listeners.iterator();
        while (i.hasNext()) {
            Listener listener = (Listener)i.next();
            listener.start();
            RadiusLog.info("  Started listener " + listener.getName());
        }
        RadiusLog.info("Listeners succesfully started.");
    }

    public void stop() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            Listener listener = (Listener)i.next();
            listener.interrupt();
            RadiusLog.info("Stopping listener " + listener.getName());
        }
        i = this.processors.iterator();
        while (i.hasNext()) {
            Processor processor = (Processor)i.next();
            processor.interrupt();
            RadiusLog.info("Stopping processor " + processor.getName());
        }
        eventDispatcher.interrupt();
    }

    private void initializeServer() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        RadiusLog.info("Initializing JRadius Server....");
        Iterator i = Configuration.getDictionaryConfigs().iterator();
        while (i.hasNext()) {
            DictionaryConfigurationItem dictionaryConfig = (DictionaryConfigurationItem)i.next();
            RadiusLog.info("  Loading dictionary: " + dictionaryConfig.getClassName());
            AttributeFactory.loadAttributeDictionary(dictionaryConfig.getClassName());
        }
        i = Configuration.getListenerConfigs().iterator();
        while (i.hasNext()) {
            ListenerConfigurationItem listenerConfig = (ListenerConfigurationItem)i.next();
            ObjectQueue queue = new ObjectQueue();
            this.createListenerWithConfigAndQueue(listenerConfig, queue);
            this.createProcessorsWithConfigAndQueue(listenerConfig, queue);
        }
        RadiusLog.info("JRadius Server succesfully Initialized.");
    }

    private void createProcessorsWithConfigAndQueue(ListenerConfigurationItem listenerConfig, ObjectQueue queue) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        for (int j = 0; j < listenerConfig.getNumberOfThreads(); ++j) {
            Processor processor = this.newProcessorForName(listenerConfig.getProcessorClassName());
            processor.setRequestQueue(queue);
            RadiusLog.info("    Created processor " + processor.getName());
            this.setPacketHandlersForProcessor(listenerConfig, processor);
            this.setEventHandlersForProcessor(listenerConfig, eventDispatcher);
            processor.setEventDispatcher(eventDispatcher);
            this.processors.add(processor);
        }
    }

    private void setPacketHandlersForProcessor(ListenerConfigurationItem cfg, Processor processor) {
        Collection packetHandlers = cfg.getRequestHandlers();
        if (packetHandlers == null) {
            RadiusLog.debug("No packet handlers are configured, maybe using chains instead.");
            return;
        }
        Iterator l = packetHandlers.iterator();
        while (l.hasNext()) {
            JRCommand handler = (JRCommand)l.next();
            RadiusLog.info("      Packet handler " + handler.getClass().getName());
        }
        processor.setRequestHandlers(packetHandlers);
    }

    private void setEventHandlersForProcessor(ListenerConfigurationItem cfg, EventDispatcher dispatcher) {
        Collection eventHandlers = cfg.getEventHandlers();
        if (eventHandlers == null) {
            return;
        }
        Iterator l = eventHandlers.iterator();
        while (l.hasNext()) {
            JRCommand handler = (JRCommand)l.next();
            RadiusLog.info("      Event handler " + handler.getClass().getName());
        }
        dispatcher.setEventHandlers(eventHandlers);
    }

    private void createListenerWithConfigAndQueue(ListenerConfigurationItem listenerConfig, ObjectQueue queue) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Listener listener = this.newListenerWithConfig(listenerConfig);
        listener.setRequestQueue(queue);
        this.listeners.add(listener);
        RadiusLog.info("  Created listener " + listener.getName());
    }

    private Listener newListenerWithConfig(ListenerConfigurationItem cfg) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(cfg.getClassName());
        Constructor<?> constructor = clazz.getConstructor(class$net$sf$jradius$server$config$ListenerConfigurationItem == null ? (class$net$sf$jradius$server$config$ListenerConfigurationItem = JRadiusServer.class$("net.sf.jradius.server.config.ListenerConfigurationItem")) : class$net$sf$jradius$server$config$ListenerConfigurationItem);
        Listener listener = (Listener)constructor.newInstance(cfg);
        return listener;
    }

    private Processor newProcessorForName(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> processorClass = Class.forName(className);
        Processor processor = (Processor)processorClass.newInstance();
        return processor;
    }

    public static String resultCodeToString(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "REJECT";
            }
            case 1: {
                return "FAIL";
            }
            case 2: {
                return "OK";
            }
            case 3: {
                return "HANDLED";
            }
            case 4: {
                return "INVALID";
            }
            case 5: {
                return "USERLOCK";
            }
            case 6: {
                return "NOTFOUND";
            }
            case 7: {
                return "NOOP";
            }
            case 8: {
                return "UPDATED";
            }
            case 9: {
                return "NUMCODES";
            }
        }
        return "UNKNOWN";
    }

    public static EventDispatcher getEventDispatcher() {
        return eventDispatcher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

