/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server;

import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.server.JRadiusThread;
import net.sf.jradius.server.ObjectQueue;
import net.sf.jradius.server.config.ListenerConfigurationItem;

public abstract class Listener
extends JRadiusThread {
    private boolean active = false;
    protected ObjectQueue queue;
    protected ListenerConfigurationItem config;

    public Listener(ListenerConfigurationItem cfg) {
        this.config = cfg;
    }

    public void setRequestQueue(ObjectQueue q) {
        this.queue = q;
    }

    public void setListenerConfigurationItem(ListenerConfigurationItem cfg) {
        this.config = cfg;
        this.setName(this.config.getName());
    }

    public abstract void listen() throws Throwable;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void run() {
        while (this.isActive()) {
            try {
                Thread.yield();
                this.listen();
            }
            catch (Throwable e) {
                System.err.println("The Listener's listen() method threw an exception: " + e);
                RadiusLog.error(e.getMessage());
            }
        }
        RadiusLog.error("Listener: " + this.getClass().getName() + " exiting (not active)");
    }
}

