/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class ObjectQueue
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int maxSize = Integer.MAX_VALUE;
    private List list;

    public ObjectQueue() {
        this(new LinkedList());
    }

    public ObjectQueue(List list) {
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(Object o) {
        List list = this.list;
        synchronized (list) {
            if (this.list.size() < Integer.MAX_VALUE) {
                this.list.add(o);
                this.list.notifyAll();
                return true;
            }
        }
        return false;
    }

    public Object dequeue() throws InterruptedException {
        return this.dequeue(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        List list = this.list;
        synchronized (list) {
            if (this.list.size() > 0) {
                return this.list.remove(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue(long timeout) throws InterruptedException {
        long stopTime = System.currentTimeMillis() + timeout;
        Object o = null;
        while ((o = this.poll()) == null) {
            if (timeout == 0L) {
                List list = this.list;
                synchronized (list) {
                    this.list.wait();
                    continue;
                }
            }
            long nowTime = System.currentTimeMillis();
            if (stopTime <= nowTime) break;
            List list = this.list;
            synchronized (list) {
                this.list.wait(stopTime - nowTime);
            }
        }
        return o;
    }
}

