/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server;

import java.util.Iterator;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.exception.RadiusSecurityException;
import net.sf.jradius.handler.chain.JRCommand;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.server.Processor;
import net.sf.jradius.server.event.HandlerLogEvent;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.session.JRadiusSessionManager;
import org.apache.commons.chain.Context;

public abstract class RadiusProcessor
extends Processor {
    protected abstract void logReturnCode(int var1, JRCommand var2);

    protected int runPacketHandlers(JRadiusRequest request) {
        int result = 7;
        RadiusLog.debug("Processing JRadiusRequest: " + request.toString());
        if (this.getRequestHandlers() == null) {
            return result;
        }
        JRadiusSessionManager sessionManager = JRadiusSessionManager.getManager();
        Iterator i = this.getRequestHandlers().iterator();
        while (i.hasNext()) {
            JRCommand handler = (JRCommand)i.next();
            boolean stop = false;
            try {
                if (!handler.doesHandle(request)) continue;
                stop = handler.execute((Context)request);
                result = request.getReturnValue();
                this.logReturnCode(result, handler);
                if (!stop) continue;
            }
            catch (RadiusException e) {
                JRadiusSession session = request.getSession();
                String error = e.getMessage();
                RadiusLog.error(error);
                if (session != null) {
                    try {
                        session.getLogEntry(request).addMessage(error);
                    }
                    catch (RadiusException re) {
                        RadiusLog.problem(request, session, re, re.getMessage());
                    }
                    session.setSessionState(-1);
                    sessionManager.removeSession(session);
                }
                result = e instanceof RadiusSecurityException ? 0 : 1;
                this.logReturnCode(result, handler);
            }
            catch (Throwable e) {
                e.printStackTrace();
                String error = e.getMessage();
                RadiusLog.error("Handler " + handler.getName() + " threw exception: " + error);
                result = 1;
                this.logReturnCode(result, handler);
            }
            break;
        }
        HandlerLogEvent log = new HandlerLogEvent(request, request.getSessionKey(), result);
        sessionManager.putSession(request.getSession());
        this.getEventDispatcher().post(log);
        return result;
    }
}

