/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jradius.handler.chain.JRCommand;
import net.sf.jradius.handler.chain.JRConfigParser;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.log.RadiusLogger;
import net.sf.jradius.server.config.DictionaryConfigurationItem;
import net.sf.jradius.server.config.HandlerConfigurationItem;
import net.sf.jradius.server.config.ListenerConfigurationItem;
import net.sf.jradius.server.config.LogConfigurationItem;
import net.sf.jradius.server.config.PacketHandlerConfigurationItem;
import net.sf.jradius.server.config.XMLConfiguration;
import net.sf.jradius.session.JRadiusSessionManager;
import net.sf.jradius.session.SessionFactory;
import net.sf.jradius.session.SessionKeyProvider;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class Configuration {
    private static XMLConfiguration xmlCfg;
    private static HierarchicalConfiguration.Node root;
    private static boolean debug;
    private static int timeoutSeconds;
    private static File configFile;
    private static Map listeners;
    private static Map packetHandlers;
    private static Map eventHandlers;
    private static Map dictionaries;
    private static JRConfigParser parser;
    private static CatalogFactory factory;
    private static LogConfigurationItem logConfig;
    private static final String SESSION_MANAGER_KEY = "session-manager";
    private static final String REQUESTER_KEY = "requester";
    private static final String KEY_PROVIDER_KEY = "key-provider";
    private static final String SESSION_FACTORY_KEY = "session-factory";
    static /* synthetic */ Class class$net$sf$jradius$server$config$LogConfigurationItem;

    public static void initialize(File file) throws FileNotFoundException, ConfigurationException {
        xmlCfg = new XMLConfiguration(new FileReader(file));
        configFile = file;
        root = xmlCfg.getRoot();
        RadiusLog.info("Configuring JRadius Server....");
        Configuration.setLogConfig();
        Configuration.setGeneralOptions();
        Configuration.setSessionManagerConfig();
        Configuration.setDictionaryConfigs();
        Configuration.setPacketHandlersConfigs();
        Configuration.setEventHandlersConfigs();
        Configuration.setListenerConfigs();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static String getConfigFileDir() {
        String configFileDir = configFile.getParent();
        if (configFileDir == null) {
            return ".";
        }
        return configFileDir;
    }

    public static Collection getPacketHandlers() {
        return packetHandlers.values();
    }

    public static Collection getEventHandlers() {
        return eventHandlers.values();
    }

    public static PacketHandlerConfigurationItem packetHandlerConfigurationForName(String name) {
        return (PacketHandlerConfigurationItem)packetHandlers.get(name);
    }

    public static HandlerConfigurationItem eventHandlerConfigurationForName(String name) {
        return (HandlerConfigurationItem)eventHandlers.get(name);
    }

    public static JRCommand packetHandlerForName(String name) {
        return (JRCommand)Configuration.getCommand(name);
    }

    public static JRCommand eventHandlerForName(String name) {
        return (JRCommand)Configuration.getCommand(name);
    }

    public static Command getCommand(String commandID) throws IllegalArgumentException {
        int splitPos;
        String DELIMITER = ":";
        String commandName = commandID;
        String catalogName = null;
        Catalog catalog = null;
        if (commandID != null && (splitPos = commandID.indexOf(DELIMITER)) != -1) {
            catalogName = commandID.substring(0, splitPos);
            commandName = commandID.substring(splitPos + DELIMITER.length());
            if (commandName.indexOf(DELIMITER) != -1) {
                throw new IllegalArgumentException("commandID [" + commandID + "] has too many delimiters (reserved for future use)");
            }
        }
        if (catalogName != null) {
            catalog = factory.getCatalog(catalogName);
            if (catalog == null) {
                RadiusLog.warn("No catalog found for name: " + catalogName + ".");
                return null;
            }
        } else {
            catalog = factory.getCatalog();
            if (catalog == null) {
                RadiusLog.warn("No default catalog found.");
                return null;
            }
        }
        return catalog.getCommand(commandName);
    }

    public static Collection getListenerConfigs() {
        return listeners.values();
    }

    public static ListenerConfigurationItem listenerConfigurationForName(String name) {
        return (ListenerConfigurationItem)listeners.get(name);
    }

    public static Collection getDictionaryConfigs() {
        return dictionaries.values();
    }

    public static DictionaryConfigurationItem dictionaryConfigurationForName(String name) {
        return (DictionaryConfigurationItem)dictionaries.get(name);
    }

    public static int getTimeoutSeconds() {
        return timeoutSeconds;
    }

    private static void setGeneralOptions() {
        debug = xmlCfg.getConfigBoolean("debug");
        timeoutSeconds = xmlCfg.getConfigInt("timeout");
        List children = root.getChildren("chain-catalog");
        Iterator i = children.iterator();
        while (i.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)i.next();
            xmlCfg.setRoot(node);
            String catalogURL = xmlCfg.getConfigString("name");
            if (catalogURL != null) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    RadiusLog.debug("Loading Chains URL: " + catalogURL);
                    parser.parse(classLoader.getResource(catalogURL));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            xmlCfg.setRoot(root);
        }
    }

    private static void setDictionaryConfigs() {
        List children = root.getChildren(DictionaryConfigurationItem.XML_KEY);
        Iterator i = children.iterator();
        while (i.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)i.next();
            xmlCfg.setRoot(node);
            DictionaryConfigurationItem item = new DictionaryConfigurationItem(node, xmlCfg);
            dictionaries.put(item.getName(), item);
            xmlCfg.setRoot(root);
        }
    }

    private static void setLogConfig() {
        List children = root.getChildren(LogConfigurationItem.XML_KEY);
        Iterator i = children.iterator();
        while (i.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)i.next();
            xmlCfg.setRoot(node);
            if (logConfig != null) {
                RadiusLog.warn("A RadiusLogger is already configured, skipping configuration");
                return;
            }
            logConfig = new LogConfigurationItem(node, xmlCfg);
            try {
                Class<?> clazz = Class.forName(logConfig.getClassName());
                Constructor<?> constructor = clazz.getConstructor(class$net$sf$jradius$server$config$LogConfigurationItem == null ? Configuration.class$("net.sf.jradius.server.config.LogConfigurationItem") : class$net$sf$jradius$server$config$LogConfigurationItem);
                RadiusLogger logger = (RadiusLogger)constructor.newInstance(logConfig);
                RadiusLog.setRadiusLogger(logger);
                RadiusLog.info("  Configuring RadiusLogger " + logConfig.getName() + ": " + logger.getClass().getName());
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage());
                logConfig = null;
            }
            xmlCfg.setRoot(root);
        }
    }

    private static void setPacketHandlersConfigs() {
        List list = root.getChildren("packet-handlers");
        Iterator l = list.iterator();
        while (l.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)l.next();
            List children = node.getChildren("packet-handler");
            Iterator i = children.iterator();
            while (i.hasNext()) {
                node = (HierarchicalConfiguration.Node)i.next();
                xmlCfg.setRoot(node);
                PacketHandlerConfigurationItem item = new PacketHandlerConfigurationItem(node, xmlCfg);
                packetHandlers.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setEventHandlersConfigs() {
        List list = root.getChildren("event-handlers");
        Iterator l = list.iterator();
        while (l.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)l.next();
            List children = node.getChildren("event-handler");
            Iterator i = children.iterator();
            while (i.hasNext()) {
                node = (HierarchicalConfiguration.Node)i.next();
                xmlCfg.setRoot(node);
                HandlerConfigurationItem item = new HandlerConfigurationItem(node, xmlCfg);
                eventHandlers.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setListenerConfigs() {
        List list = root.getChildren(ListenerConfigurationItem.XML_LIST_KEY);
        Iterator l = list.iterator();
        while (l.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)l.next();
            List children = node.getChildren(ListenerConfigurationItem.XML_KEY);
            Iterator i = children.iterator();
            while (i.hasNext()) {
                node = (HierarchicalConfiguration.Node)i.next();
                xmlCfg.setRoot(node);
                ListenerConfigurationItem item = new ListenerConfigurationItem(node, xmlCfg);
                listeners.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setSessionManagerConfig() {
        List list = root.getChildren(SESSION_MANAGER_KEY);
        RadiusLog.info("  Initializing session manager");
        Iterator l = list.iterator();
        while (l.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)l.next();
            xmlCfg.setRoot(node);
            String requester = xmlCfg.getConfigString(REQUESTER_KEY);
            String keyProvider = xmlCfg.getConfigString(KEY_PROVIDER_KEY);
            String sessionFactory = xmlCfg.getConfigString(SESSION_FACTORY_KEY);
            if (keyProvider != null) {
                try {
                    RadiusLog.info("    Session Key Provider (" + requester + "): " + keyProvider);
                    Class<?> providerClass = Class.forName(keyProvider);
                    SessionKeyProvider provider = (SessionKeyProvider)providerClass.newInstance();
                    JRadiusSessionManager.getManager().setSessionKeyProvider(requester, provider);
                }
                catch (Exception e) {
                    RadiusLog.error(e.getMessage());
                }
            }
            if (sessionFactory == null) continue;
            try {
                RadiusLog.info("    Session Factory (" + requester + "): " + sessionFactory);
                Class<?> factoryClass = Class.forName(sessionFactory);
                SessionFactory factory = (SessionFactory)factoryClass.newInstance();
                JRadiusSessionManager.getManager().setSessionFactory(requester, factory);
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        listeners = new LinkedHashMap();
        packetHandlers = new LinkedHashMap();
        eventHandlers = new LinkedHashMap();
        dictionaries = new LinkedHashMap();
        parser = new JRConfigParser();
        factory = CatalogFactory.getInstance();
    }
}

