/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server.config;

import java.util.Collection;
import java.util.LinkedList;
import net.sf.jradius.server.config.ConfigurationItem;
import net.sf.jradius.server.config.XMLConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class HandlerConfigurationItem
extends ConfigurationItem {
    public static final String XML_LIST_KEY = "event-handlers";
    public static final String XML_KEY = "event-handler";
    public static final String TYPE_KEY = "type";
    public static final String SENDER_KEY = "sender";
    public static final String HANDLER_KEY = "handler";
    public static final String CATALOG_KEY = "catalog";
    private Collection possibleTypes;
    private Collection handleTypes;
    private Collection senders;
    String handlerName;
    String catalogName;

    public HandlerConfigurationItem(String name) {
        super(name);
    }

    public HandlerConfigurationItem(String name, String className) {
        super(name, className);
    }

    public HandlerConfigurationItem(HierarchicalConfiguration.Node node, XMLConfiguration config) {
        super(node, config);
        this.possibleTypes = config.getList(".handle.type");
        String type = config.getConfigString(TYPE_KEY);
        String sender = config.getConfigString(SENDER_KEY);
        this.handlerName = config.getConfigString(HANDLER_KEY);
        this.catalogName = config.getConfigString(CATALOG_KEY);
        this.setSenders(sender);
        this.setHandleTypes(type);
    }

    public Collection getHandleTypes() {
        return this.handleTypes;
    }

    public void setHandleTypes(Collection handleTypes) {
        this.handleTypes = handleTypes;
    }

    public void setHandleTypes(String handleTypes) {
        String[] types;
        LinkedList<String> list = new LinkedList<String>();
        if (handleTypes == null) {
            handleTypes = "";
        }
        if ((types = handleTypes.split("[ \\t]*,[ \\t]*")) != null) {
            for (int i = 0; i < types.length; ++i) {
                if (types[i].length() <= 0 || this.possibleTypes != null && !this.possibleTypes.isEmpty() && !this.possibleTypes.contains(types[i])) continue;
                list.add(types[i]);
            }
        }
        this.handleTypes = list;
    }

    public void setSenders(String sender) {
        String[] types;
        LinkedList<String> list = new LinkedList<String>();
        if (sender == null) {
            sender = "";
        }
        if ((types = sender.split("[ \\t]*,[ \\t]*")) != null) {
            for (int i = 0; i < types.length; ++i) {
                if (types[i].length() <= 0) continue;
                list.add(types[i]);
            }
        }
        this.senders = list;
    }

    public Collection getSenders() {
        return this.senders;
    }

    public Collection getPossibleTypes() {
        return this.possibleTypes;
    }

    public void setPossibleTypes(Collection possibleTypes) {
        this.possibleTypes = possibleTypes;
    }

    public boolean handlesType(String type) {
        if (this.handleTypes.isEmpty()) {
            return true;
        }
        return this.handleTypes.contains(type);
    }

    public boolean handlesSender(Object sender) {
        if (this.senders.isEmpty()) {
            return true;
        }
        return this.senders.contains(sender);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    public void setSenders(Collection senders) {
        this.senders = senders;
    }
}

