/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.log.RadiusLogEntry;
import net.sf.jradius.server.JRadiusEvent;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.server.JRadiusServer;
import net.sf.jradius.server.JRadiusThread;
import net.sf.jradius.server.event.SessionExpiredEvent;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.session.SessionFactory;
import net.sf.jradius.session.SessionKeyProvider;

public class JRadiusSessionManager {
    private static JRadiusSessionManager defaultManager = new JRadiusSessionManager();
    private Map sessions = Collections.synchronizedMap(new LinkedHashMap());
    private HashMap providers = new HashMap();
    private HashMap factories = new HashMap();
    private HashMap objects = new HashMap(19);

    public static JRadiusSessionManager getManager() {
        return defaultManager;
    }

    public JRadiusSessionManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            Class<?> c = Class.forName("net.sf.jradius.session.RadiusSessionKeyProvider");
            this.providers.put(null, c.newInstance());
            c = Class.forName("net.sf.jradius.session.RadiusSessionFactory");
            this.factories.put(null, c.newInstance());
        }
        catch (Exception e) {
            RadiusLog.error("Could not find extended JRadius classes - not running JRadiusSessionManager");
            RadiusLog.error("Error: The server will choke with Null pointer Exceptions!!!");
            return;
        }
        new SessionManagerThread().start();
    }

    public void setSessionKeyProvider(String name, SessionKeyProvider provider) {
        this.providers.put(name, provider);
    }

    public void setSessionFactory(String name, SessionFactory factory) {
        this.factories.put(name, factory);
    }

    public SessionKeyProvider getSessionKeyProvider(Object name) {
        SessionKeyProvider provider = (SessionKeyProvider)this.providers.get(name);
        if (provider == null && name != null) {
            provider = (SessionKeyProvider)this.providers.get(null);
        }
        return provider;
    }

    public SessionFactory getSessionFactory(Object name) {
        SessionFactory factory = (SessionFactory)this.factories.get(name);
        if (factory == null && name != null) {
            factory = (SessionFactory)this.factories.get(null);
        }
        return factory;
    }

    public synchronized JRadiusSession getSession(JRadiusRequest request) throws RadiusException {
        Object keys = this.getSessionKeyProvider(request.getSender()).getSessionKey(request);
        RadiusLog.debug(request.toString() + ": " + keys.toString());
        if (keys == null) {
            return null;
        }
        Object key = null;
        Object nkey = null;
        if (keys instanceof Object[]) {
            key = ((Object[])keys)[0];
            nkey = ((Object[])keys)[1];
            RadiusLog.debug("Rehashing session with key " + key + " under new key " + nkey);
        } else {
            key = keys;
        }
        boolean isNew = false;
        JRadiusSession session = (JRadiusSession)this.sessions.get(key);
        if (session == null) {
            session = this.getSessionFactory(request.getSender()).newSession(request);
            isNew = true;
        } else {
            session.setNewSession(false);
        }
        if (nkey != null) {
            this.sessions.remove(key);
            key = nkey;
            isNew = true;
        }
        session.setTimeStamp(System.currentTimeMillis());
        if (isNew) {
            session.setJRadiusKey((String)key);
            this.sessions.put(session.getJRadiusKey(), session);
            this.sessions.put(session.getSessionKey(), session);
        }
        session.setLastRadiusRequest(request);
        this.lock(session);
        return session;
    }

    public synchronized JRadiusSession getSession(String key) throws RadiusException {
        JRadiusSession session = (JRadiusSession)this.sessions.get(key);
        if (session == null) {
            throw new RadiusException(key + ": no such session");
        }
        this.lock(session);
        return session;
    }

    public synchronized void putSession(JRadiusSession session) {
        if (session != null) {
            this.release(session);
        }
    }

    private void lock(JRadiusSession session) {
        String thisThread = Thread.currentThread().getName();
        String sessionToLock = session.getSessionKey();
        String sessionOwner = null;
        while (true) {
            if ((sessionOwner = (String)this.objects.get(sessionToLock)) == null) {
                this.objects.put(sessionToLock, thisThread);
                RadiusLog.debug("Lock: Thread " + thisThread + " locked session " + sessionToLock);
                return;
            }
            if (sessionOwner.equals(thisThread)) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
            }
        }
    }

    private void release(JRadiusSession session) {
        String thisThread = Thread.currentThread().getName();
        String sessionToUnlock = session.getSessionKey();
        String sessionOwner = (String)this.objects.get(sessionToUnlock);
        if (sessionOwner != null) {
            if (sessionOwner.equals(thisThread)) {
                this.objects.remove(sessionToUnlock);
                RadiusLog.debug("Release: Thread " + thisThread + " unlocking session " + sessionToUnlock);
            } else {
                RadiusLog.error("Releasing session lock not owned by this thread (" + sessionOwner + ")");
            }
        }
        this.notify();
    }

    public RadiusLogEntry newLogEntry(JRadiusEvent event, JRadiusSession session, String packetId) {
        Object sender = null;
        if (event != null) {
            sender = event.getSender();
        } else if (session.getLastRadiusRequest() != null) {
            sender = session.getLastRadiusRequest().getSender();
        }
        return this.getSessionFactory(sender).newSessionLogEntry(session, packetId);
    }

    public boolean sessionExists(JRadiusRequest request) throws RadiusException {
        Object sessionKey = this.getSessionKeyProvider(request.getSender()).getSessionKey(request);
        return this.sessionExistsForKey(sessionKey);
    }

    public boolean sessionExistsForKey(Object key) {
        return this.sessions.containsKey(key);
    }

    public synchronized void removeSession(JRadiusRequest request) throws RadiusException {
        Object key = this.getSessionKeyProvider(request.getSender()).getSessionKey(request);
        JRadiusSession session = (JRadiusSession)this.sessions.get(key);
        this.removeSession(session);
    }

    public synchronized void removeSession(JRadiusSession session) {
        if (session != null) {
            this.removeSessionWithKey(session.getJRadiusKey());
            this.removeSessionWithKey(session.getSessionKey());
        }
    }

    private void removeSessionWithKey(Object key) {
        this.sessions.remove(key);
    }

    private class SessionManagerThread
    extends JRadiusThread {
        int INTERVAL = 900000;
        int THRESHOLD = 1800000;
        private LinkedList removeList = new LinkedList();

        SessionManagerThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    block8: while (true) {
                        JRadiusSession session;
                        try {
                            Thread.sleep(this.INTERVAL);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        long currentTime = System.currentTimeMillis();
                        this.removeList.clear();
                        JRadiusSessionManager jRadiusSessionManager = JRadiusSessionManager.this;
                        synchronized (jRadiusSessionManager) {
                            Iterator iter = JRadiusSessionManager.this.sessions.values().iterator();
                            while (iter.hasNext()) {
                                session = (JRadiusSession)iter.next();
                                if (currentTime - session.getTimeStamp() > (long)this.THRESHOLD) {
                                    if (this.removeList.contains(session.getSessionKey())) continue;
                                    RadiusLog.debug("Removing session from Session Manager: " + session.getSessionKey());
                                    this.removeList.add(session.getSessionKey());
                                    continue;
                                }
                                RadiusLog.debug("Active session: " + session.getSessionKey() + ": " + session.getUsername() + "@" + session.getRealm());
                            }
                        }
                        Iterator i = this.removeList.iterator();
                        while (true) {
                            if (!i.hasNext()) continue block8;
                            Object key = i.next();
                            session = (JRadiusSession)JRadiusSessionManager.this.sessions.get(key);
                            JRadiusSessionManager.this.removeSession(session);
                            if (JRadiusServer.getEventDispatcher() == null) continue;
                            SessionExpiredEvent evt = new SessionExpiredEvent(session);
                            JRadiusServer.getEventDispatcher().post(evt);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    RadiusLog.error(e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

