/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.discovery.PortInfo;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphXMLConstants;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.ClassMap;
import com.sysuptime.common.model.Customer;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.ParentNode;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.RrpGroup;
import com.sysuptime.common.model.RrpInterface;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.trap.AesCipher;
import com.sysuptime.server.msp.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import util.Base64;

public class GraphXMLReader
implements Serializable,
GraphXMLConstants {
    private static Logger _logger = Logger.getLogger((String)GraphXMLReader.class.getName());
    private static Map _id2BeanMap;

    protected GraphXMLReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized CustomerNode fromNodesXML(String string) {
        block9: {
            if (string == null) return null;
            try {
                if (string.trim().length() != 0) break block9;
                return null;
                catch (DocumentException documentException) {
                    throw GraphXMLReader.a((Exception)((Object)documentException));
                }
            }
            catch (DocumentException documentException) {
                throw GraphXMLReader.a((Exception)((Object)documentException));
            }
        }
        try {
            TopologyData topologyData = new TopologyData();
            _id2BeanMap = new HashMap();
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            Element element2 = element.element("customer");
            if (element2 == null) return null;
            CustomerNode customerNode = GraphXMLReader.a(element2);
            topologyData.addCustomer(customerNode);
            CustomerNode customerNode2 = topologyData.getCustomer(customerNode.getBean().getCustomerID());
            return customerNode2;
        }
        catch (DocumentException documentException) {
            _logger.error((Object)string, (Throwable)documentException);
            CustomerNode customerNode = null;
            return customerNode;
        }
        finally {
            _id2BeanMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TopologyData fromNodesXML(List list) {
        int[] nArray;
        block14: {
            nArray = NetworkGraphModel.b();
            if (list == null) return new TopologyData();
            try {
                if (list.size() != 0) break block14;
                return new TopologyData();
                catch (Exception exception) {
                    throw GraphXMLReader.a(exception);
                }
            }
            catch (Exception exception) {
                throw GraphXMLReader.a(exception);
            }
        }
        _id2BeanMap = new HashMap();
        Iterator iterator = list.iterator();
        TopologyData topologyData = new TopologyData();
        try {
            while (iterator.hasNext()) {
                block15: {
                    String string = String.valueOf(iterator.next());
                    try {
                        Document document = DocumentHelper.parseText((String)string);
                        Element element = document.getRootElement();
                        Element element2 = element.element("customer");
                        try {
                            if (nArray == null) return topologyData;
                            if (element2 == null) break block15;
                        }
                        catch (Exception exception) {
                            throw GraphXMLReader.a(exception);
                        }
                        CustomerNode customerNode = GraphXMLReader.a(element2);
                        topologyData.addCustomer(customerNode);
                    }
                    catch (Exception exception) {
                        _logger.error((Object)string, (Throwable)exception);
                    }
                }
                if (nArray != null) continue;
                return topologyData;
            }
            return topologyData;
        }
        catch (Exception exception) {
            _logger.error((Object)"fromNodesXML", (Throwable)exception);
            return topologyData;
        }
        finally {
            _id2BeanMap = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList getCustomersId(String string) {
        int[] nArray = NetworkGraphModel.b();
        try {
            if (string == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw GraphXMLReader.a(exception);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            List list = element.elements("customer");
            for (Object e10 : list) {
                Element element2 = (Element)e10;
                try {
                    arrayList.add(element2.attributeValue("id"));
                    if (nArray != null && nArray != null) continue;
                    return arrayList;
                }
                catch (Exception exception) {
                    throw GraphXMLReader.a(exception);
                    return arrayList;
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)string, (Throwable)exception);
        }
        return arrayList;
    }

    private static NetworkNodeBean a(String string) {
        Set set;
        if (_id2BeanMap != null && !_id2BeanMap.isEmpty() && (set = _id2BeanMap.keySet()).contains(string)) {
            return (NetworkNodeBean)_id2BeanMap.get(string);
        }
        return null;
    }

    private static CustomerNode a(Element element) {
        CustomerNode customerNode;
        block4: {
            customerNode = GraphXMLReader.b(element);
            int[] nArray = NetworkGraphModel.b();
            if (customerNode == null) {
                return null;
            }
            Path path = new Path(customerNode.getBean().getCustomerID());
            List list = element.elements("subnet");
            for (Object e10 : list) {
                Element element2 = (Element)e10;
                SubnetNode subnetNode = GraphXMLReader.c(element2);
                if (nArray != null) {
                    if (subnetNode != null) {
                        customerNode.addSubNode(subnetNode);
                        path.setSubDeviceID(subnetNode.getBean().getPrivateID());
                        GraphXMLReader.a(element2, subnetNode);
                    }
                    if (nArray != null) continue;
                }
                break block4;
            }
            GraphXMLReader.a(element, customerNode);
        }
        return customerNode;
    }

    private static void a(Element element, ParentNode parentNode) {
        block5: {
            List list = element.elements("device");
            int[] nArray = NetworkGraphModel.b();
            if (list == null) break block5;
            for (Object e10 : list) {
                block6: {
                    DeviceNode deviceNode;
                    block7: {
                        Element element2 = (Element)e10;
                        deviceNode = GraphXMLReader.d(element2);
                        if (deviceNode == null) break block6;
                        if (!(parentNode instanceof SubnetNode)) break block7;
                        ((SubnetNode)parentNode).addSubNode(deviceNode);
                        if (nArray != null) break block6;
                    }
                    if (parentNode instanceof CustomerNode) {
                        ((CustomerNode)parentNode).addSubNode(deviceNode);
                    }
                }
                if (nArray != null) continue;
            }
        }
    }

    private static CustomerNode b(Element element) {
        Customer customer = new Customer();
        GraphXMLReader.a(element, customer);
        NetworkNodeBean networkNodeBean = GraphXMLReader.a(customer.getID());
        if (networkNodeBean != null) {
            return new CustomerNode((Customer)networkNodeBean);
        }
        _id2BeanMap.put(customer.getID(), customer);
        return new CustomerNode(customer);
    }

    private static SubnetNode c(Element element) {
        Subnet subnet = new Subnet();
        GraphXMLReader.a(element, subnet);
        NetworkNodeBean networkNodeBean = GraphXMLReader.a(subnet.getID());
        if (networkNodeBean != null) {
            return new SubnetNode((Subnet)networkNodeBean);
        }
        _id2BeanMap.put(subnet.getID(), subnet);
        return new SubnetNode(subnet);
    }

    protected static DeviceNode d(Element element) {
        try {
            String string = element.attribute("type").getValue();
            DeviceBean deviceBean = (DeviceBean)ClassMap.getClass(string).newInstance();
            GraphXMLReader.a(element, deviceBean);
            NetworkNodeBean networkNodeBean = GraphXMLReader.a(deviceBean.getID());
            if (networkNodeBean != null) {
                return new DeviceNode((DeviceBean)networkNodeBean);
            }
            _id2BeanMap.put(deviceBean.getID(), deviceBean);
            return new DeviceNode(deviceBean);
        }
        catch (Exception exception) {
            _logger.error((Object)"getNodeBeanByElement", (Throwable)exception);
            return null;
        }
    }

    protected static void a(Element element, NetworkNodeBean networkNodeBean) {
        Element element2;
        networkNodeBean.setCustomerID(element.attributeValue("customerId"));
        int[] nArray = NetworkGraphModel.b();
        networkNodeBean.setDisplayName(GraphXMLReader.b(element.attributeValue("displayName")));
        int[] nArray2 = nArray;
        networkNodeBean.setManuallyAdded(Boolean.valueOf(element.attributeValue("manuallyAdded")));
        Element element3 = element.element("interfaces");
        GraphXMLReader.g(element3, networkNodeBean);
        if (element != null) {
            GraphXMLReader.d(element, networkNodeBean);
        }
        Element element4 = element.element("otherProperties");
        GraphXMLReader.f(element4, networkNodeBean);
        Element element5 = element.element("sysObjectIdValue");
        GraphXMLReader.e(element5, networkNodeBean);
        Element element6 = element.element("SNMPParams");
        if (element6 != null) {
            GraphXMLReader.c(element6, networkNodeBean);
        }
        if ((element2 = element.element("scanServices")) != null) {
            GraphXMLReader.b(element2, networkNodeBean);
        }
        if (nArray2 == null) {
            Command.b(new int[4]);
        }
    }

    protected static void b(Element element, NetworkNodeBean networkNodeBean) {
        block6: {
            List list = element.elements("scanService");
            int[] nArray = NetworkGraphModel.b();
            if (list != null) {
                ArrayList<PortInfo> arrayList = new ArrayList<PortInfo>();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Element element2 = (Element)list.get(i2);
                    Attribute attribute = element2.attribute("name");
                    String string = null;
                    if (nArray != null) {
                        if (attribute != null) {
                            string = attribute.getValue();
                        }
                        Attribute attribute2 = element2.attribute("port");
                        int n2 = 0;
                        if (attribute2 != null) {
                            n2 = Integer.parseInt(attribute2.getValue());
                        }
                        Attribute attribute3 = element2.attribute("isAlive");
                        boolean bl2 = false;
                        if (attribute3 != null) {
                            bl2 = Boolean.valueOf(attribute3.getValue());
                        }
                        PortInfo portInfo = new PortInfo(string, n2);
                        portInfo.setAlive(bl2);
                        arrayList.add(portInfo);
                        if (nArray != null) continue;
                    }
                    break block6;
                }
                networkNodeBean.setScanServices(arrayList);
            }
        }
    }

    protected static void c(Element element, NetworkNodeBean networkNodeBean) {
        Element element2;
        String string;
        int n2;
        ReadCommunity readCommunity;
        block5: {
            block4: {
                readCommunity = null;
                int[] nArray = NetworkGraphModel.b();
                n2 = Integer.parseInt(element.attribute("Port").getValue());
                string = element.attribute("Community").getValue();
                if (string.trim().length() >= 1) break block4;
                string = "public";
                if (nArray != null) break block5;
            }
            string = GraphXMLReader.a("Community", string);
        }
        int n3 = Integer.parseInt(element.attribute("Version").getValue());
        V3Params v3Params = null;
        if (3 == n3 && (element2 = element.element("V3Params")) != null) {
            String string2 = GraphXMLReader.a(element2, "User");
            String string3 = GraphXMLReader.a(element2, "Auth");
            String string4 = GraphXMLReader.a("AuthPwd", GraphXMLReader.a(element2, "AuthPwd"));
            String string5 = GraphXMLReader.a(element2, "Privacy");
            String string6 = GraphXMLReader.a("PrivacyPwd", GraphXMLReader.a(element2, "PrivacyPwd"));
            v3Params = new V3Params(string2, string3, string4, Integer.parseInt(string5), string6);
        }
        readCommunity = new ReadCommunity(null, string, n3, v3Params, n2);
        networkNodeBean.setReadCommunity(readCommunity);
    }

    private static String a(Element element, String string) {
        String string2 = element.attributeValue(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    private static String a(String string, String string2) {
        if (string2.length() == 0) {
            return "";
        }
        AesCipher aesCipher = new AesCipher(string);
        return aesCipher.decrypt(string2);
    }

    protected static void d(Element element, NetworkNodeBean networkNodeBean) {
        GraphID graphID;
        String string;
        String string2;
        Element element2;
        int n2;
        List list;
        Element element3 = element.element("topoGraphIDs");
        int[] nArray = NetworkGraphModel.b();
        if (element3 != null) {
            list = element3.elements("graphID");
            for (n2 = 0; n2 < list.size(); ++n2) {
                element2 = (Element)list.get(n2);
                string2 = element2.attributeValue("customerId");
                string = element2.attributeValue("graphName");
                graphID = new GraphID(string2, string);
                networkNodeBean.addTopoGraph(graphID);
                if (nArray != null) {
                    if (nArray != null) continue;
                }
                break;
            }
        } else {
            element3 = element.element("viewGraphIDs");
        }
        if (element3 != null) {
            list = element3.elements("graphID");
            for (n2 = 0; n2 < list.size(); ++n2) {
                element2 = (Element)list.get(n2);
                string2 = element2.attributeValue("customerId");
                string = element2.attributeValue("graphName");
                graphID = new GraphID(string2, string);
                networkNodeBean.addViewGraph(graphID);
                if (nArray != null) continue;
            }
        }
    }

    protected static void e(Element element, NetworkNodeBean networkNodeBean) {
        block3: {
            block2: {
                int[] nArray = NetworkGraphModel.b();
                if (element == null) break block2;
                networkNodeBean.setSysObjectIdValue(element.getTextTrim());
                if (nArray != null) break block3;
            }
            networkNodeBean.setSysObjectIdValue("");
        }
    }

    protected static void f(Element element, NetworkNodeBean networkNodeBean) {
        int[] nArray = NetworkGraphModel.b();
        if (element == null) {
            return;
        }
        List list = element.elements("comp");
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object object;
                String string;
                block10: {
                    Element element2;
                    int n2;
                    Element element3 = (Element)list.get(i2);
                    string = element3.attribute("key").getValue();
                    List list2 = element3.elements("a");
                    Attribute attribute = element3.attribute("type");
                    if (attribute != null && attribute.getValue().equals("List")) {
                        block9: {
                            object = new ArrayList();
                            for (n2 = 0; n2 < list2.size(); ++n2) {
                                element2 = (Element)list2.get(n2);
                                object.add(element2.attribute("value").getValue());
                                if (nArray != null) {
                                    if (nArray != null) continue;
                                }
                                break block9;
                            }
                            networkNodeBean.setOtherProperty((Comparable)((Object)string), object);
                        }
                        if (nArray != null) continue;
                    }
                    object = new String[list2.size()];
                    for (n2 = 0; n2 < list2.size(); ++n2) {
                        element2 = (Element)list2.get(n2);
                        object[n2] = GraphXMLReader.b(element2.attributeValue("value"));
                        if (nArray != null) {
                            if (nArray != null) continue;
                        }
                        break block10;
                    }
                    if (((String[])object).length == 1) {
                        networkNodeBean.setOtherProperty((Comparable)((Object)string), object[0]);
                        if (nArray != null) continue;
                    }
                }
                networkNodeBean.setOtherProperty((Comparable)((Object)string), object);
                if (nArray != null) continue;
            }
        }
    }

    protected static void g(Element element, NetworkNodeBean networkNodeBean) {
        block4: {
            int[] nArray = NetworkGraphModel.b();
            if (element == null) {
                return;
            }
            List list = element.elements("interface");
            NetworkInterface[] networkInterfaceArray = new EthernetInterface[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Element element2 = (Element)list.get(i2);
                networkInterfaceArray[i2] = GraphXMLReader.e(element2);
                if (nArray != null) {
                    if (nArray != null) continue;
                }
                break block4;
            }
            if (networkInterfaceArray.length > 0) {
                networkNodeBean.setInterfaces(networkInterfaceArray);
            }
        }
    }

    protected static EthernetInterface e(Element element) {
        EthernetInterface ethernetInterface;
        block9: {
            String string = element.attribute("type").getValue();
            ethernetInterface = null;
            int[] nArray = NetworkGraphModel.b();
            if (string.indexOf("EthernetInterface") >= 0) {
                ethernetInterface = new EthernetInterface();
            } else if (string.indexOf("rrpInterface") >= 0) {
                ethernetInterface = new RrpInterface();
            }
            if (ethernetInterface != null) {
                ethernetInterface.setIpAddress(element.attribute("ip").getValue());
                ethernetInterface.setMacAddress(element.attribute("MAC").getValue());
                ethernetInterface.setIsUsed(Boolean.valueOf(element.attribute("status").getValue()));
                String string2 = element.attribute("index").getValue();
                int n2 = -1;
                if (StringUtil.isDigit(string2)) {
                    n2 = Integer.parseInt(string2);
                }
                ethernetInterface.setIfIndex(n2);
                ethernetInterface.isVirtual(Boolean.valueOf(element.attribute("virtual").getValue()));
                String string3 = element.attribute("speed").getValue();
                ethernetInterface.setIfSpeed(Long.parseLong(string3));
                ethernetInterface.setIfName(GraphXMLReader.b(element.attribute("name").getValue()));
                if (ethernetInterface instanceof RrpInterface) {
                    RrpInterface rrpInterface = (RrpInterface)ethernetInterface;
                    List list = element.elements("RrpGroup");
                    int n3 = list.size();
                    RrpGroup[] rrpGroupArray = new RrpGroup[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Element element2 = (Element)list.get(i2);
                        rrpGroupArray[i2] = new RrpGroup();
                        rrpGroupArray[i2].setRrpId(element2.attribute("RrpId").getValue());
                        int n4 = 0;
                        String string4 = element2.attribute("state").getValue();
                        if (nArray != null) {
                            if (StringUtil.isDigit(string4)) {
                                n4 = Integer.parseInt(string4);
                            }
                            rrpGroupArray[i2].setState(n4);
                            if (nArray != null) continue;
                        }
                        break block9;
                    }
                    rrpInterface.setRrpGroups(rrpGroupArray);
                }
            }
        }
        return ethernetInterface;
    }

    protected static String[] b(String string, String string2) {
        String[] stringArray;
        block2: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            String[] stringArray2 = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            int[] nArray = NetworkGraphModel.b();
            while (stringTokenizer.hasMoreElements()) {
                stringArray = stringArray2;
                if (nArray != null) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                    if (nArray != null) continue;
                }
                break block2;
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private static String b(String string) {
        return new String(Base64.decode((String)string));
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

