/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.model;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.model.CIM_UnitaryComputerSystemBeanSupport;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.ParentNode;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.model.TopoNode;
import com.sysuptime.common.util.CompactProperties;
import com.sysuptime.common.util.ComparablePair;
import com.sysuptime.server.msp.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopologyData
implements Serializable {
    private long _time;
    private Map<String, CustomerNode> _customers;

    public synchronized List getCustomers() {
        if (!this._customers.isEmpty()) {
            return new ArrayList<CustomerNode>(this._customers.values());
        }
        return null;
    }

    public synchronized void addCustomer(CustomerNode customerNode) {
        if (this._customers == null) {
            this._customers = new Hashtable<String, CustomerNode>();
        }
        this._customers.put(customerNode.getCustomerID(), customerNode);
    }

    public synchronized void removeCustomer(String string) {
        if (this._customers != null) {
            this._customers.remove(string);
        }
    }

    public synchronized CustomerNode getCustomer(String string) {
        if (this._customers != null) {
            return this._customers.get(string);
        }
        return null;
    }

    public SubnetNode getSubnetNode(Subnet subnet) {
        CustomerNode customerNode = this.getCustomer(subnet.getCustomerID());
        return (SubnetNode)customerNode.getSubNode(subnet.getPrivateID());
    }

    public synchronized void addNode(TopoNode topoNode, Path path) {
        block5: {
            CustomerNode customerNode;
            String string;
            block6: {
                String string2;
                String string3;
                Command[] commandArray;
                block4: {
                    commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
                    if (this._customers == null) {
                        this._customers = new Hashtable<String, CustomerNode>();
                    }
                    string3 = path.getCustomerID();
                    string = path.getSubDeviceID();
                    string2 = path.getDeviceID();
                    if (string != null) break block4;
                    this._customers.put(string3, (CustomerNode)topoNode);
                    if (commandArray == null) break block5;
                }
                customerNode = this._customers.get(string3);
                if (string2 != null) break block6;
                customerNode.addSubNode(topoNode);
                if (commandArray == null) break block5;
            }
            SubnetNode subnetNode = (SubnetNode)customerNode.getSubNode(string);
            subnetNode.addSubNode(topoNode);
        }
    }

    public synchronized void removeNode(Path path) {
        block2: {
            CustomerNode customerNode;
            String string;
            String string2;
            block4: {
                String string3;
                Command[] commandArray;
                block3: {
                    commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
                    if (this._customers == null) break block2;
                    string3 = path.getCustomerID();
                    string2 = path.getSubDeviceID();
                    string = path.getDeviceID();
                    if (string2 != null) break block3;
                    this._customers.remove(string3);
                    if (commandArray == null) break block2;
                }
                customerNode = this._customers.get(string3);
                if (string != null) break block4;
                customerNode.removeSubNode(string2);
                if (commandArray == null) break block2;
            }
            SubnetNode subnetNode = (SubnetNode)customerNode.getSubNode(string2);
            subnetNode.removeSubNode(string);
        }
    }

    public synchronized TopoNode getNode(Path path) {
        if (this._customers != null) {
            String string = path.getCustomerID();
            String string2 = path.getSubDeviceID();
            String string3 = path.getDeviceID();
            CustomerNode customerNode = this._customers.get(string);
            if (string2 == null) {
                return customerNode;
            }
            TopoNode topoNode = customerNode.getSubNode(string2);
            if (string3 == null) {
                return topoNode;
            }
            SubnetNode subnetNode = (SubnetNode)topoNode;
            return subnetNode.getSubNode(string3);
        }
        return null;
    }

    public synchronized void setBean(NetworkNodeBean networkNodeBean) {
        String string = networkNodeBean.getID();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        if (this._customers != null) {
            Iterator<CustomerNode> iterator = this._customers.values().iterator();
            block0: while (true) {
                boolean bl2 = iterator.hasNext();
                block1: while (bl2) {
                    CustomerNode customerNode = iterator.next();
                    if (customerNode.getID().equals(string)) {
                        customerNode.setBean(networkNodeBean);
                        if (commandArray == null) continue block0;
                    }
                    if (!customerNode.hasChildren()) continue block0;
                    Iterator iterator2 = customerNode.childrenIterator();
                    block2: while (true) {
                        boolean bl3 = iterator2.hasNext();
                        block3: while (bl3) {
                            SubnetNode subnetNode;
                            Object e10 = iterator2.next();
                            TopoNode topoNode = (TopoNode)e10;
                            bl2 = topoNode.getID().equals(string);
                            if (commandArray != null) continue block1;
                            if (bl2) {
                                topoNode.setBean(networkNodeBean);
                            }
                            if (!(e10 instanceof SubnetNode) || !(subnetNode = (SubnetNode)e10).hasChildren()) continue block2;
                            Iterator iterator3 = subnetNode.childrenIterator();
                            while (iterator3.hasNext()) {
                                TopoNode topoNode2 = (TopoNode)iterator3.next();
                                bl3 = topoNode2.getID().equals(string);
                                if (commandArray != null) continue block3;
                                if (bl3) {
                                    topoNode2.setBean(networkNodeBean);
                                }
                                if (commandArray == null) continue;
                            }
                            if (commandArray == null) continue block2;
                        }
                        break;
                    }
                    if (commandArray == null) continue block0;
                }
                break;
            }
        }
    }

    public synchronized NetworkNodeBean getBean(String string) {
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        if (this._customers != null) {
            Iterator<CustomerNode> iterator = this._customers.values().iterator();
            block0: while (true) {
                boolean bl2 = iterator.hasNext();
                block1: while (bl2) {
                    CustomerNode customerNode = iterator.next();
                    if (customerNode.getID().equals(string)) {
                        return customerNode.getBean();
                    }
                    if (!customerNode.hasChildren()) continue block0;
                    Iterator iterator2 = customerNode.childrenIterator();
                    block2: while (true) {
                        boolean bl3 = iterator2.hasNext();
                        block3: while (bl3) {
                            SubnetNode subnetNode;
                            Object e10 = iterator2.next();
                            TopoNode topoNode = (TopoNode)e10;
                            bl2 = topoNode.getID().equals(string);
                            if (commandArray != null) continue block1;
                            if (bl2) {
                                return topoNode.getBean();
                            }
                            if (!(e10 instanceof SubnetNode) || !(subnetNode = (SubnetNode)e10).hasChildren()) continue block2;
                            Iterator iterator3 = subnetNode.childrenIterator();
                            while (iterator3.hasNext()) {
                                TopoNode topoNode2 = (TopoNode)iterator3.next();
                                bl3 = topoNode2.getID().equals(string);
                                if (commandArray != null) continue block3;
                                if (bl3) {
                                    return topoNode2.getBean();
                                }
                                if (commandArray == null) continue;
                            }
                            if (commandArray == null) continue block2;
                        }
                        break;
                    }
                    if (commandArray == null) continue block0;
                }
                break;
            }
        }
        return null;
    }

    public Iterator customersIterator() {
        return this._customers.values().iterator();
    }

    public synchronized Set getAllTopoNodes() {
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        if (this._customers == null || this._customers.isEmpty()) {
            return null;
        }
        HashSet<CustomerNode> hashSet = new HashSet<CustomerNode>(this._customers.values());
        Iterator iterator = this.customersIterator();
        block0: while (true) {
            boolean bl2 = iterator.hasNext();
            block1: while (bl2) {
                CustomerNode customerNode = (CustomerNode)iterator.next();
                if (!customerNode.hasChildren()) continue block0;
                hashSet.addAll(customerNode.getChildren());
                Iterator iterator2 = customerNode.childrenIterator();
                while (iterator2.hasNext()) {
                    SubnetNode subnetNode;
                    Object e10 = iterator2.next();
                    bl2 = e10 instanceof SubnetNode;
                    if (commandArray != null) continue block1;
                    if (bl2 && (subnetNode = (SubnetNode)e10).hasChildren()) {
                        hashSet.addAll(subnetNode.getChildren());
                    }
                    if (commandArray == null) continue;
                }
                if (commandArray == null) continue block0;
            }
            break;
        }
        return hashSet;
    }

    public synchronized Set getAllBeans() {
        HashSet<NetworkNodeBean> hashSet;
        HashSet<NetworkNodeBean> hashSet2 = new HashSet<NetworkNodeBean>();
        Set set = this.getAllTopoNodes();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        if (set != null) {
            for (Object e10 : set) {
                TopoNode topoNode = (TopoNode)e10;
                hashSet = hashSet2;
                if (commandArray == null) {
                    hashSet.add(topoNode.getBean());
                    if (commandArray == null) continue;
                }
                break;
            }
        } else {
            hashSet = hashSet2;
        }
        return hashSet;
    }

    public static void update(CustomerNode customerNode, CustomerNode customerNode2) {
        TopologyData.a(customerNode.getBean(), customerNode2.getBean());
        Iterator iterator = customerNode.childrenIterator();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        while (iterator.hasNext()) {
            TopoNode topoNode;
            TopoNode topoNode2 = (TopoNode)iterator.next();
            TopoNode topoNode3 = topoNode = customerNode2.getSubNode(topoNode2.getPrivateID());
            block1: while (topoNode3 != null) {
                TopologyData.a(topoNode2.getBean(), topoNode.getBean());
                if (!(topoNode2 instanceof SubnetNode) || !(topoNode instanceof SubnetNode)) break;
                SubnetNode subnetNode = (SubnetNode)topoNode2;
                SubnetNode subnetNode2 = (SubnetNode)topoNode;
                if (!subnetNode.hasChildren()) break;
                Iterator iterator2 = subnetNode.childrenIterator();
                while (iterator2.hasNext()) {
                    TopoNode topoNode4;
                    TopoNode topoNode5 = (TopoNode)iterator2.next();
                    topoNode3 = topoNode4 = subnetNode2.getSubNode(topoNode5.getPrivateID());
                    if (commandArray != null) continue block1;
                    if (topoNode3 != null) {
                        TopologyData.a(topoNode5.getBean(), topoNode4.getBean());
                    }
                    if (commandArray == null) continue;
                }
                TopologyData.a(subnetNode, subnetNode2);
                break;
            }
            if (commandArray == null) continue;
        }
    }

    private static void a(NetworkNodeBean networkNodeBean, NetworkNodeBean networkNodeBean2) {
        TopologyData.b(networkNodeBean, networkNodeBean2);
    }

    private static void b(NetworkNodeBean networkNodeBean, NetworkNodeBean networkNodeBean2) {
        CompactProperties compactProperties = networkNodeBean.getOtherProperties();
        CompactProperties compactProperties2 = networkNodeBean2.getOtherProperties();
        LinkedList linkedList = compactProperties2.getProperties();
        List<String> list = Arrays.asList(NetworkNodeBean.QUERY_INFOS);
        Iterator iterator = linkedList.iterator();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        while (iterator.hasNext()) {
            ComparablePair comparablePair = (ComparablePair)iterator.next();
            if (!list.contains((String)((Object)comparablePair.name))) {
                compactProperties.put(comparablePair);
            }
            if (commandArray == null) continue;
        }
    }

    private static void a(ParentNode parentNode, ParentNode parentNode2) {
        Iterator iterator = parentNode2.childrenIterator();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        while (iterator.hasNext()) {
            TopoNode topoNode = (TopoNode)iterator.next();
            if (topoNode.getBean().isManuallyAdded() && !parentNode.includesSubBean(topoNode.getPrivateID())) {
                parentNode.addSubNode(topoNode);
            }
            if (commandArray == null) continue;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer;
        block7: {
            StringBuffer stringBuffer2 = new StringBuffer();
            Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
            if (this._customers == null || this._customers.isEmpty()) {
                return stringBuffer2.toString();
            }
            Iterator iterator = this.customersIterator();
            block0: while (true) {
                boolean bl2 = iterator.hasNext();
                block1: while (bl2) {
                    CustomerNode customerNode = (CustomerNode)iterator.next();
                    stringBuffer = stringBuffer2.append(customerNode.getID()).append('\n');
                    if (commandArray != null) break block7;
                    if (!customerNode.hasChildren()) continue block0;
                    Iterator iterator2 = customerNode.childrenIterator();
                    block2: while (iterator2.hasNext()) {
                        Object e10 = iterator2.next();
                        bl2 = e10 instanceof SubnetNode;
                        if (commandArray != null) continue block1;
                        if (bl2) {
                            SubnetNode subnetNode = (SubnetNode)e10;
                            stringBuffer2.append("\t").append(subnetNode.getID()).append('\n');
                            if (subnetNode.hasChildren()) {
                                Iterator iterator3 = subnetNode.childrenIterator();
                                while (iterator3.hasNext()) {
                                    TopoNode topoNode = (TopoNode)iterator3.next();
                                    stringBuffer2.append("\t\t").append(topoNode).append('\n');
                                    stringBuffer2.append("\t\t\t").append(topoNode.getBean().interfacesToString());
                                    if (commandArray != null) continue block2;
                                    if (commandArray == null) continue;
                                }
                            }
                        }
                        if (commandArray == null) continue;
                    }
                    if (commandArray == null) continue block0;
                }
                break;
            }
            stringBuffer = stringBuffer2;
        }
        return stringBuffer.toString();
    }

    public synchronized boolean isEmpty() {
        return this._customers == null || this._customers.isEmpty();
    }

    public synchronized String getCustomerName(String string) {
        CustomerNode customerNode = this.getCustomer(string);
        if (customerNode != null) {
            return customerNode.getBean().getDisplayName();
        }
        return null;
    }

    public synchronized Set getAllDevices() {
        HashSet<NetworkNodeBean> hashSet = new HashSet<NetworkNodeBean>();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        Set set = this.getAllTopoNodes();
        if (set != null) {
            for (Object e10 : set) {
                TopoNode topoNode = (TopoNode)e10;
                if (topoNode instanceof DeviceNode) {
                    hashSet.add(topoNode.getBean());
                }
                if (commandArray == null) continue;
            }
        }
        return hashSet;
    }

    public long getTime() {
        return this._time;
    }

    public void setTime(long l2) {
        this._time = l2;
    }

    public Set getBeansInGraph(GraphID graphID) {
        HashSet<NetworkNodeBean> hashSet = new HashSet<NetworkNodeBean>();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        for (Object e10 : this.getAllTopoNodes()) {
            TopoNode topoNode = (TopoNode)e10;
            NetworkNodeBean networkNodeBean = topoNode.getBean();
            if (networkNodeBean.contained(graphID)) {
                hashSet.add(networkNodeBean);
            }
            if (commandArray == null) continue;
        }
        return hashSet;
    }

    public NetworkNodeBean getBean(Path path) {
        TopoNode topoNode = this.getNode(path);
        if (topoNode != null) {
            return topoNode.getBean();
        }
        return null;
    }

    public boolean existsInterface(EthernetInterface ethernetInterface, EthernetInterface ethernetInterface2) {
        int n2;
        block3: {
            Set set = this.getAllDevices();
            Iterator iterator = set.iterator();
            Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
            block0: while (true) {
                boolean bl2 = iterator.hasNext();
                block1: while (bl2) {
                    NetworkNodeBean networkNodeBean = (NetworkNodeBean)iterator.next();
                    NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
                    n2 = 0;
                    if (commandArray != null) break block3;
                    for (int i2 = v653112; i2 < networkInterfaceArray.length; ++i2) {
                        EthernetInterface ethernetInterface3 = (EthernetInterface)networkInterfaceArray[i2];
                        bl2 = ethernetInterface3.equals(ethernetInterface);
                        if (commandArray != null) continue block1;
                        if (!bl2 || ethernetInterface3.equals(ethernetInterface2)) continue;
                        return true;
                    }
                    if (commandArray == null) continue block0;
                }
                break;
            }
            n2 = 0;
        }
        return n2 != 0;
    }
}

