/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.trapreceiver;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.trapreceiver.AlarmAction;
import com.sysuptime.common.trapreceiver.EscalationEmailParameter;
import com.sysuptime.common.trapreceiver.TimeBasedEmails;
import com.sysuptime.server.performance.NoUseStateTimebucketCache;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class EscalationSchedule
extends Monitor {
    private static Logger _logger = Logger.getLogger((String)EscalationSchedule.class.getName());
    private boolean _isEnabled = false;
    private int _severity = 3;
    private List _emailParameterList;

    public EscalationSchedule() {
        this.setPeriod(3600000L);
        this.setScheduleId(1);
        this.setStartDateTime(0L);
        this.setScheduleName("escalation");
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setEnabled(boolean bl2) {
        this._isEnabled = bl2;
    }

    public void setEmailParameterList(List list) {
        this._emailParameterList = list;
    }

    public List getEmailParameterList() {
        return this._emailParameterList;
    }

    public String getAction() {
        return EscalationSchedule.toXML(this._emailParameterList);
    }

    public void setAction(String string) {
        this._emailParameterList = EscalationSchedule.fromXML(string);
    }

    @Override
    public String toString() {
        return "Enabled:" + this._isEnabled + "; Severity:" + this._severity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toXML(List list) {
        Document document = DocumentHelper.createDocument();
        boolean bl2 = AlarmAction.c();
        try {
            Element element = document.addElement("EscalationEmail");
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                EscalationEmailParameter escalationEmailParameter = (EscalationEmailParameter)list.get(i2);
                Element element2 = element.addElement("EscalationItem");
                Element element3 = element2.addElement("Time");
                element3.addAttribute("range", String.valueOf(escalationEmailParameter.getActiveTime()));
                Element element4 = element2.addElement("Severity");
                element4.addAttribute("status", escalationEmailParameter.getSeverity());
                Element element5 = element2.addElement("Subject");
                element5.addAttribute("content", escalationEmailParameter.getEmailSubject());
                Element element6 = element2.addElement("EmailAccounts");
                element6.addAttribute("to", escalationEmailParameter.getEmailTimeString());
                Document document2 = DocumentHelper.parseText((String)TimeBasedEmails.toXML(escalationEmailParameter.getEmailTimePairList()));
                try {
                    element2.add(document2.getRootElement());
                    if (!bl2 && !bl2) continue;
                    return document.asXML();
                }
                catch (Exception exception) {
                    throw EscalationSchedule.a(exception);
                    return document.asXML();
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
        return document.asXML();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List fromXML(String string) {
        ArrayList<EscalationEmailParameter> arrayList = new ArrayList<EscalationEmailParameter>();
        boolean bl2 = AlarmAction.b();
        if (string == null) return arrayList;
        try {
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            List list = element.elements("EscalationItem");
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Element element2 = (Element)list.get(i2);
                Element element3 = element2.element("Time");
                int n3 = Integer.parseInt(String.valueOf(element3.attributeValue("range")));
                Element element4 = element2.element("Severity");
                String string2 = element4.attributeValue("status");
                Element element5 = element2.element("Subject");
                String string3 = element5.attributeValue("content");
                Element element6 = element2.element("EmailAccounts");
                String string4 = element6.attributeValue("to");
                Element element7 = element2.element("email");
                List list2 = TimeBasedEmails.fromXML(element7.asXML(), NoUseStateTimebucketCache.getCacheMap());
                EscalationEmailParameter escalationEmailParameter = new EscalationEmailParameter(string2, n3, string3, string4);
                try {
                    escalationEmailParameter.setEmailTimePairList(list2);
                    escalationEmailParameter.setEmailGroupName(TimeBasedEmails.toXML(list2));
                    arrayList.add(escalationEmailParameter);
                    if (bl2 && bl2) continue;
                    return arrayList;
                }
                catch (Exception exception) {
                    throw EscalationSchedule.a(exception);
                    return arrayList;
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
        return arrayList;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

