/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.util;

import com.sysuptime.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class FileUtil {
    public static final String ENCODING = "UTF-8";
    private static Logger _logger = Logger.getLogger((String)FileUtil.class.getName());

    private FileUtil() {
    }

    public static BufferedReader getReader(String string) throws FileNotFoundException {
        return FileUtil.getReader(string, null);
    }

    public static BufferedReader getReader(String string, String string2) throws FileNotFoundException {
        if (string2 == null) {
            string2 = ENCODING;
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static BufferedInputStream getInputStream(String string) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(string));
    }

    public static BufferedWriter getWriter(String string) throws FileNotFoundException {
        return FileUtil.getWriter(string, null);
    }

    public static BufferedWriter getWriter(String string, String string2) throws FileNotFoundException {
        if (string2 == null) {
            string2 = ENCODING;
        }
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static BufferedOutputStream getOutputStream(String string) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(string));
    }

    public static String readFile(String string) {
        return FileUtil.readFile(string, null);
    }

    public static String readFile(String string, String string2) {
        return FileUtil.readFile(string, string2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String string, String string2, long l2) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = FileUtil.getReader(string, string2);
            try {
                if (l2 > 0L) {
                    bufferedReader.skip(l2);
                }
            }
            catch (Exception exception) {
                throw FileUtil.a(exception);
            }
            char[] cArray = new char[16384];
            while (true) {
                int n2;
                block18: {
                    n2 = bufferedReader.read(cArray, 0, cArray.length);
                    try {
                        if (n2 >= 0) break block18;
                        break;
                    }
                    catch (Exception exception) {
                        throw FileUtil.a(exception);
                    }
                }
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            _logger.error((Object)"File reader", (Throwable)iOException);
            String string3 = null;
            return string3;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return stringBuffer.toString();
    }

    public static void writeFile(String string, String string2) throws IOException {
        FileUtil.writeFile(string, string2, null);
    }

    public static void writeFile(String string, String string2, String string3) throws IOException {
        BufferedWriter bufferedWriter = FileUtil.getWriter(string, string3);
        bufferedWriter.write(string2, 0, string2.length());
        bufferedWriter.close();
    }

    public static String getFullPath(String string, String string2) {
        if (string.endsWith(File.separator)) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    public static void copyFile(File file, File file2) throws IOException {
        block4: {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[16384];
            String[] stringArray = StringUtil.b();
            int n2 = 0;
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                try {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    if (stringArray != null) {
                        if (stringArray != null) continue;
                        break;
                    }
                    break block4;
                }
                catch (IOException iOException) {
                    throw FileUtil.a(iOException);
                }
            }
            ((OutputStream)fileOutputStream).close();
            ((InputStream)fileInputStream).close();
        }
    }

    public static void copyFile(String string, String string2) throws IOException {
        block4: {
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[16384];
            int n2 = 0;
            String[] stringArray = StringUtil.b();
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                try {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    if (stringArray != null) {
                        if (stringArray != null) continue;
                        break;
                    }
                    break block4;
                }
                catch (IOException iOException) {
                    throw FileUtil.a(iOException);
                }
            }
            ((OutputStream)fileOutputStream).close();
            ((InputStream)fileInputStream).close();
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

