/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.actions;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.mainframe.ComponentUtils;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.ViewComponent;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openide.util.actions.Presenter;

public class OpenGraphViewAction
extends AbstractAction
implements Presenter.Menu {
    private GraphID _graphID;

    public OpenGraphViewAction(String string, GraphID graphID) {
        super(string);
        this._graphID = graphID;
    }

    public JMenuItem getMenuPresenter() {
        return new JMenuItem(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.getValue("Name");
        ViewComponent viewComponent = ComponentUtils.getOpenedViewComponent(string);
        if (viewComponent == null) {
            boolean bl2 = ComponentUtils.noOpenedViews();
            NetworkGraphModel networkGraphModel = GraphLoader.loadModel(this._graphID, bl2);
            networkGraphModel.setCustomView(true);
            viewComponent = new ViewComponent(networkGraphModel);
            if (networkGraphModel == null && IGraphParameters.TOPOLOGY_VIEW.equals(string)) {
                viewComponent.setDisplayName(IGraphParameters.TOPOLOGY_VIEW);
            }
        }
        Startup.addViewTab(viewComponent, string, SwingUtil.getImage("actions/connect.gif"), true);
    }
}

