/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.graph;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.graph.GraphScheduleBean;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.graph.GraphScheduleDialog$1;
import com.sysuptime.mainframe.graph.GraphScheduleDialog$2;
import com.sysuptime.mainframe.graph.GraphScheduleDialog$3;
import com.sysuptime.mainframe.graph.GraphScheduleProviderInvoker;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GraphScheduleDialog
extends JDialog {
    private static final Logger _logger = Logger.getLogger((String)GraphScheduleDialog.class.getName());
    private JLabel _periodLabel = new JLabel(GraphScheduleDialog.a("graphscheduledialog_period"));
    private JLabel _enableLabel = new JLabel(GraphScheduleDialog.a("graphscheduledialog_enable"));
    private JLabel _timeoutLabel = new JLabel(GraphScheduleDialog.a("graphscheduledialog_timeout"));
    private JLabel _retryLabel = new JLabel(GraphScheduleDialog.a("graphscheduledialog_retry"));
    private JTextField _periodField = SwingUtil.createTextLimitField(5);
    private JCheckBox _enableBox = new JCheckBox();
    private JTextField _timeoutField = SwingUtil.createTextLimitField(1);
    private JTextField _retryField = SwingUtil.createTextLimitField(1);
    private JDialog _dialog = this;
    private int _periodTime;
    private int _timeout;
    private int _retry;
    private boolean _isEnable = false;

    public GraphScheduleDialog() {
        super(Startup.getFrame(), true);
        this.setTitle(GraphScheduleDialog.a("graphscheduledialog_title"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.a(), "Center");
        this.setSize(470, 280);
        SwingUtil.centerOnFrame(Startup.getFrame(), this);
        this.setVisible(true);
    }

    private JPanel a() {
        CellConstraints cellConstraints;
        PanelBuilder panelBuilder;
        block3: {
            block2: {
                FormLayout formLayout = new FormLayout("FILL:9PX:NONE,FILL:8PX:NONE,FILL:50PX:NONE,FILL:50PX:NONE,FILL:70PX:NONE,FILL:10PX:NONE,FILL:80PX:NONE,FILL:50PX:NONE,FILL:50PX:NONE,FILL:50PX:NONE", "CENTER:12PX:NONE,CENTER:DEFAULT:NONE,CENTER:20PX:NONE,CENTER:DEFAULT:NONE,CENTER:20PX:NONE,CENTER:DEFAULT:NONE,CENTER:20PX:NONE,CENTER:DEFAULT:NONE,CENTER:18PX:NONE,CENTER:27PX:NONE,CENTER:30PX:NONE");
                int n2 = NetworkGraph.d();
                panelBuilder = new PanelBuilder(formLayout);
                panelBuilder.setDefaultDialogBorder();
                cellConstraints = new CellConstraints();
                panelBuilder.add((Component)this._periodLabel, cellConstraints.xywh(3, 4, 6, 1));
                GraphScheduleBean graphScheduleBean = GraphScheduleProviderInvoker.getInstance().getPingSchedule();
                if (graphScheduleBean == null) break block2;
                this._isEnable = !graphScheduleBean.isSuspended();
                this._periodField.setText("" + graphScheduleBean.getPeriod() / 60000L);
                this._timeoutField.setText("" + graphScheduleBean.getTimeout() / 1000);
                this._retryField.setText("" + graphScheduleBean.getRetries());
                if (n2 == 0) break block3;
            }
            this._periodField.setText("10");
        }
        panelBuilder.add((Component)this._periodField, cellConstraints.xywh(9, 4, 2, 1));
        panelBuilder.add((Component)this._enableLabel, cellConstraints.xywh(3, 2, 6, 1));
        this._periodField.setEnabled(this._isEnable);
        this._enableBox.setSelected(this._isEnable);
        panelBuilder.add((Component)this._enableBox, cellConstraints.xywh(9, 2, 2, 1));
        panelBuilder.add((Component)this._timeoutLabel, cellConstraints.xywh(3, 6, 6, 1));
        this._timeoutField.setEnabled(this._isEnable);
        panelBuilder.add((Component)this._timeoutField, cellConstraints.xywh(9, 6, 2, 1));
        panelBuilder.add((Component)this._retryLabel, cellConstraints.xywh(3, 8, 6, 1));
        this._retryField.setEnabled(this._isEnable);
        panelBuilder.add((Component)this._retryField, cellConstraints.xywh(9, 8, 2, 1));
        this._enableBox.addActionListener(new GraphScheduleDialog$1(this));
        JButton jButton = new JButton(ICommonBundle.OK);
        jButton.addActionListener(new GraphScheduleDialog$2(this));
        JButton jButton2 = new JButton(ICommonBundle.CANCEL);
        jButton2.addActionListener(new GraphScheduleDialog$3(this));
        panelBuilder.add((Component)jButton, cellConstraints.xyw(5, 10, 1));
        panelBuilder.add((Component)jButton2, cellConstraints.xyw(7, 10, 1));
        this.getRootPane().setDefaultButton(jButton);
        return panelBuilder.getPanel();
    }

    private void a(GraphScheduleBean graphScheduleBean) {
        try {
            try {
                ClientProxy.getInstance().updatePingSchedule(graphScheduleBean);
                if (graphScheduleBean.isSuspended()) {
                    AlarmViewController.INSTANCE.clearAllPingAlarms();
                }
            }
            catch (Exception exception) {
                throw GraphScheduleDialog.a(exception);
            }
            this.dispose();
        }
        catch (Exception exception) {
            _logger.error((Object)"clearAllPingAlarms", (Throwable)exception);
        }
    }

    private boolean a(String string, String string2, String string3) {
        boolean bl2 = true;
        if (string == null || !StringUtil.isDigit(string)) {
            bl2 = false;
            JOptionPane.showMessageDialog(this._dialog, GraphScheduleDialog.a("graphscheduledialog_numberformat_error"), GraphScheduleDialog.a("graphscheduledialog_invalid_period"), 0);
        }
        if (string2 == null || !StringUtil.isDigit(string2)) {
            bl2 = false;
            JOptionPane.showMessageDialog(this._dialog, GraphScheduleDialog.a("graphscheduledialog_numberformat_error"), GraphScheduleDialog.a("graphscheduledialog_invalid_timeout"), 0);
        }
        if (string3 == null || !StringUtil.isDigit(string3)) {
            bl2 = false;
            JOptionPane.showMessageDialog(this._dialog, GraphScheduleDialog.a("graphscheduledialog_numberformat_error"), GraphScheduleDialog.a("graphscheduledialog_invalid_retry"), 0);
        }
        return bl2;
    }

    private static String a(String string) {
        return NbBundle.getMessage(GraphScheduleDialog.class, (String)string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

