/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.graph;

import com.sysuptime.common.graph.CustomerGraphModel;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.MasterGraphModel;
import com.sysuptime.common.graph.MyMarqueeHandler;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.NewGraphUI;
import com.sysuptime.common.graph.PadGraph;
import com.sysuptime.common.graph.SubnetGraphModel;
import com.sysuptime.common.graph.TopologyGraphModel;
import com.sysuptime.common.graph.ViewGraphModel;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.ParentBean;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.msp.Probe;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.SNMPInfoMenu;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.actions.ClearTrapOnGraphAction;
import com.sysuptime.mainframe.actions.DeleteAction;
import com.sysuptime.mainframe.actions.InsertDeviceAction;
import com.sysuptime.mainframe.actions.ParentGraphAction;
import com.sysuptime.mainframe.actions.PingOrTraceAction;
import com.sysuptime.mainframe.actions.SNMPInfoAction;
import com.sysuptime.mainframe.actions.ShowPropertiesDialogAction;
import com.sysuptime.mainframe.actions.SubGraphAction;
import com.sysuptime.mainframe.actions.UpdateNodeAction;
import com.sysuptime.mainframe.actions.ViewTrapsAction;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.graph.NetGraphUndoManager;
import com.sysuptime.mainframe.graph.NetworkCellViewFactory;
import com.sysuptime.mainframe.graph.NetworkGraph$1;
import com.sysuptime.mainframe.graph.NetworkGraphLayoutCache;
import com.sysuptime.mainframe.performance.GraphMonitorUtil;
import com.sysuptime.mainframe.util.FunctionManager;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.plaf.GraphUI;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class NetworkGraph
extends PadGraph
implements KeyListener,
GraphModelListener {
    protected transient GraphUndoManager _undoManager = new NetGraphUndoManager();
    private transient File _backgroundFile;
    public boolean _isSaved = false;
    private static int a;

    public NetworkGraph(NetworkGraphModel networkGraphModel) {
        this(networkGraphModel, (GraphLayoutCache)new NetworkGraphLayoutCache((GraphModel)(networkGraphModel != null ? networkGraphModel : new MasterGraphModel(null, IGraphParameters.MASTER_MASTER, null, null)), (CellViewFactory)new NetworkCellViewFactory(), null, false));
    }

    private NetworkGraph(NetworkGraphModel networkGraphModel, GraphLayoutCache graphLayoutCache) {
        super((GraphModel)networkGraphModel, graphLayoutCache);
        this.setMarqueeHandler(new MyMarqueeHandler(this));
        this.b();
        this.updateUI();
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        ToolTipManager.sharedInstance().setDismissDelay(7000);
        this.addKeyListener(this);
        this.a();
    }

    private void a() {
        this.addMouseListener(new NetworkGraph$1(this));
    }

    protected void b() {
        this.setEditable(false);
        this.setBendable(false);
        this.setMoveBelowZero(false);
        this.setEditEnable(FunctionManager.getInstance().isEditGraphEnabled());
        this.setAntiAliased(true);
        this.setHandleColor(Color.RED);
        this.setLockedHandleColor(Color.RED);
        this.setHighlightColor(Color.RED);
        this.setMarqueeColor(Color.RED);
    }

    public void setEditEnable(boolean bl2) {
        this.discardAllEdits();
        this.setDropEnabled(bl2);
        this.setSizeable(bl2);
        this.setMoveable(bl2);
    }

    public Object[] getNodes() {
        return ((NetworkGraphModel)this.getModel()).getNodes();
    }

    public List getConnections() {
        return ((NetworkGraphModel)this.getModel()).getConnections();
    }

    private GraphUndoManager c() {
        return this._undoManager;
    }

    public void undo() {
        if (this._undoManager != null) {
            this.c().undo((Object)this.getGraphLayoutCache());
        }
    }

    public void redo() {
        if (this._undoManager != null) {
            this.c().redo((Object)this.getGraphLayoutCache());
        }
    }

    public boolean canUndo() {
        return this.c().canUndo((Object)this.getGraphLayoutCache());
    }

    public boolean canRedo() {
        return this.c().canRedo((Object)this.getGraphLayoutCache());
    }

    public GraphID getGraphID() {
        return ((NetworkGraphModel)this.getModel()).getID();
    }

    public void setGraphID(GraphID graphID) {
        ((NetworkGraphModel)this.getModel()).setID(graphID);
    }

    public List getBeans() {
        return ((NetworkGraphModel)this.getModel()).getBeans();
    }

    public GraphID getParentGraph() {
        return ((NetworkGraphModel)this.getModel()).getParentGraph();
    }

    public void setParentGraph(GraphID graphID) {
        ((NetworkGraphModel)this.getModel()).setParentGraph(graphID);
    }

    public void removeUndoableEditListener() {
    }

    public void addUndoableEditListener() {
    }

    public File getBackgroundFile() {
        if (this.isCustomer()) {
            return this._backgroundFile;
        }
        return null;
    }

    public void setBackgroundFile(File file) {
        block5: {
            block4: {
                this._backgroundFile = file;
                int n2 = NetworkGraph.e();
                if (this._backgroundFile == null) break block4;
                ((NetworkGraphModel)this.getModel()).setBackgroundImagePath(file.getPath());
                Image image = Toolkit.getDefaultToolkit().getImage(file.getPath());
                if (image != null) {
                    this.setBackgroundImage(image);
                }
                if (n2 != 0) break block5;
            }
            ((NetworkGraphModel)this.getModel()).setBackgroundImagePath(null);
            this.setBackgroundImage(null);
        }
    }

    public void applyLayout() {
        GraphModel graphModel;
        Object[] objectArray = NetworkGraphModel.getAll((GraphModel)this.getModel());
        if (objectArray != null && (graphModel = this.getModel()) instanceof NetworkGraphModel) {
            JGraphLayoutAlgorithm jGraphLayoutAlgorithm = ((NetworkGraphModel)graphModel).getLayoutAlgorithm();
            JGraphLayoutAlgorithm.applyLayout(this, jGraphLayoutAlgorithm, objectArray, null);
        }
    }

    public void flash(NetworkNode networkNode, Color color) {
        ((NetworkGraphLayoutCache)this.getGraphLayoutCache()).flash(networkNode, color);
    }

    public void stopFlash(NetworkNode networkNode) {
        ((NetworkGraphLayoutCache)this.getGraphLayoutCache()).stopFlashing(networkNode);
    }

    @Override
    public void updateUI() {
        this.setUI((GraphUI)new NewGraphUI());
        this.invalidate();
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        this.saveChanged();
    }

    public void saveChanged() {
        if (this._isSaved) {
            return;
        }
        this._isSaved = true;
        NetworkGraphModel networkGraphModel = (NetworkGraphModel)this.getModel();
        if (!networkGraphModel.isIgnoreChanges()) {
            networkGraphModel.setIgnoreChanges(true);
            GraphLoader.save2Local(this);
            GraphLoader.save2Server(networkGraphModel, true);
            this.discardAllEdits();
            FunctionManager.getInstance().updateEditAction();
            networkGraphModel.setIgnoreChanges(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            SystemAction.get(DeleteAction.class).actionPerformed(null);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public JPopupMenu createPopupMenu(Point point, Object object) {
        JPopupMenu jPopupMenu;
        block9: {
            block11: {
                block10: {
                    jPopupMenu = new JPopupMenu();
                    int n2 = NetworkGraph.e();
                    if (this.isSubnet() || this.isCustomer()) {
                        jPopupMenu.add(new ParentGraphAction());
                    }
                    NetworkGraphModel networkGraphModel = (NetworkGraphModel)this.getModel();
                    if (object == null && FunctionManager.getInstance().isEditGraphEnabled() && !networkGraphModel.isCustomView() && !(networkGraphModel instanceof MasterGraphModel)) {
                        jPopupMenu.add(new InsertDeviceAction(networkGraphModel, point));
                    }
                    if (object == null || !(object instanceof NetworkNode)) break block9;
                    NetworkNodeBean networkNodeBean = (NetworkNodeBean)((NetworkNode)object).getUserObject();
                    if (networkNodeBean instanceof ParentBean) {
                        jPopupMenu.add(new SubGraphAction((NetworkNode)object));
                    }
                    if (jPopupMenu.getSubElements().length > 0) {
                        jPopupMenu.addSeparator();
                    }
                    if (!Startup.isMspEdition() || Startup.isMspEdition() && Startup.isMaster()) {
                        jPopupMenu.add(new UpdateNodeAction(networkNodeBean));
                        jPopupMenu.addSeparator();
                    }
                    if (!(networkNodeBean instanceof ParentBean)) break block10;
                    this.a(jPopupMenu, (NetworkNode)object);
                    if (n2 != 0) break block11;
                }
                this.b(jPopupMenu, (NetworkNode)object);
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ShowPropertiesDialogAction((NetworkNode)object));
        }
        if (jPopupMenu.getSubElements().length > 0) {
            return jPopupMenu;
        }
        return null;
    }

    private void a(JPopupMenu jPopupMenu, NetworkNode networkNode) {
        jPopupMenu.add(new ViewTrapsAction(networkNode));
        jPopupMenu.add(new ClearTrapOnGraphAction(networkNode));
    }

    private void b(JPopupMenu jPopupMenu, NetworkNode networkNode) {
        NetworkNodeBean networkNodeBean = (NetworkNodeBean)networkNode.getUserObject();
        String string = null;
        if (this.isSubnet()) {
            SubnetGraphModel subnetGraphModel = (SubnetGraphModel)this.getModel();
            string = subnetGraphModel.getOwnIP(networkNodeBean);
        } else {
            string = networkNodeBean.getFirstIp();
        }
        long l2 = Long.parseLong(networkNodeBean.getCustomerID());
        jPopupMenu.add(new PingOrTraceAction("Ping", string, l2));
        jPopupMenu.add(new PingOrTraceAction("Trace Route", string, l2));
        if (l2 == Probe.LOCAL_PROBE.getId()) {
            this.a(jPopupMenu, networkNodeBean);
        }
        if (l2 == Probe.LOCAL_PROBE.getId()) {
            jPopupMenu.addSeparator();
            this.b(jPopupMenu, networkNodeBean);
            jPopupMenu.add(new SNMPInfoAction(SNMPInfoAction.MIBBROWSER, networkNodeBean, string));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ViewTrapsAction(networkNode));
        jPopupMenu.add(new ClearTrapOnGraphAction(networkNode));
    }

    private void a(JPopupMenu jPopupMenu, NetworkNodeBean networkNodeBean) {
        jPopupMenu.add(GraphMonitorUtil.getPopupMonitorMenu(NbBundle.getBundle(NetworkGraph.class).getString("MSG_add_monitor"), networkNodeBean));
    }

    private void b(JPopupMenu jPopupMenu, NetworkNodeBean networkNodeBean) {
        jPopupMenu.add(new SNMPInfoMenu(networkNodeBean));
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Object object = this.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (object instanceof NetworkNode) {
                NetworkNodeBean networkNodeBean = ((NetworkNode)object).getBean();
                if (networkNodeBean instanceof ParentBean) {
                    ParentBean parentBean = (ParentBean)networkNodeBean;
                    if (networkNodeBean instanceof Subnet) {
                        SubnetNode subnetNode = (SubnetNode)((TopologyGraphModel)this.getModel()).getTopoNode((NetworkNode)object);
                        return AlarmViewController.INSTANCE.getSubnetToolTip(subnetNode, parentBean.getDisplayName());
                    }
                    CustomerNode customerNode = (CustomerNode)((TopologyGraphModel)this.getModel()).getTopoNode((NetworkNode)object);
                    return AlarmViewController.INSTANCE.getCustomerToolTip(customerNode, parentBean.getDisplayName());
                }
                return AlarmViewController.INSTANCE.getDeviceToolTipContent((DeviceBean)networkNodeBean);
            }
            if (object instanceof NetworkConnection) {
                return AlarmViewController.INSTANCE.getConnectionToolTip((NetworkConnection)object);
            }
        }
        return null;
    }

    public void setModel(GraphModel graphModel) {
        block4: {
            block6: {
                block5: {
                    int n2 = NetworkGraph.e();
                    super.setModel(graphModel);
                    int n3 = n2;
                    if (!(graphModel instanceof NetworkGraphModel)) break block4;
                    this.getModel().addGraphModelListener((GraphModelListener)this);
                    this.addUndoableEditListener();
                    NetworkGraphModel networkGraphModel = (NetworkGraphModel)graphModel;
                    String string = networkGraphModel.getBackgroundImagePath();
                    if (string != null) {
                        this.setBackgroundFile(new File(string));
                    }
                    if (string == null) break block5;
                    Image image = Toolkit.getDefaultToolkit().getImage(string);
                    this.setBackgroundImage(image);
                    if (n3 != 0) break block6;
                }
                this.setBackgroundImage(null);
            }
            this.setDisconnectable(!this.isSubnet());
        }
    }

    public void setSelectionCells(Object[] objectArray) {
        super.setSelectionCells(objectArray);
    }

    public void discardAllEdits() {
        block2: {
            int n2 = NetworkGraph.d();
            while (this._undoManager.canUndo()) {
                this.undo();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this._undoManager.discardAllEdits();
        }
    }

    public boolean hasErrorConnections() {
        return ((NetworkGraphModel)this.getModel()).hasErrorConnections();
    }

    public boolean isMaster() {
        return false;
    }

    public boolean isCustomer() {
        return this.getModel() instanceof CustomerGraphModel;
    }

    public boolean isSubnet() {
        return this.getModel() instanceof SubnetGraphModel;
    }

    public boolean isView() {
        return this.getModel() instanceof ViewGraphModel;
    }

    public boolean isTopology() {
        return this.getModel() instanceof TopologyGraphModel;
    }

    /*
     * Exception decompiling
     */
    public void updateStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isAlarming(NetworkNode networkNode) {
        return AlarmViewController.INSTANCE.isAlarming(networkNode.getBean(), (NetworkGraphModel)this.getModel());
    }

    public static void b(int n2) {
        a = n2;
    }

    public static int d() {
        return a;
    }

    public static int e() {
        int n2 = NetworkGraph.d();
        if (n2 == 0) {
            return 54;
        }
        return 0;
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    static {
        if (NetworkGraph.e() == 0) {
            NetworkGraph.b(27);
        }
    }
}

