/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.app.mibbrowser.SnmpUtil;
import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpTableModel;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.AgentProperties;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.NbBundle;

public class CPUMonitorPane
extends SnmpDevicesMonitorPane {
    private String _expressionName = "";
    private static final String LINUX_OS = "linux";

    public CPUMonitorPane(String string, AgentProperties agentProperties) throws Exception {
        this.initCPUComponent(string, agentProperties);
    }

    private void initCPUComponent(String string, AgentProperties agentProperties) throws Exception {
        if (string == null || string.length() == 0 || !string.equalsIgnoreCase(LINUX_OS) ? !this.doWindowsSnmpAgent(agentProperties) && !this.doNetSnmpAgent(agentProperties) : string != null && string.equalsIgnoreCase(LINUX_OS) && !this.doNetSnmpAgent(agentProperties)) {
            throw new Exception(NbBundle.getMessage(CPUMonitorPane.class, (String)"MSG_get_data_error"));
        }
    }

    private boolean doNetSnmpAgent(AgentProperties agentProperties) throws Exception {
        SnmpPdu snmpPdu = null;
        snmpPdu = ClientProxy.getInstance().snmpGetRequest(agentProperties, ".1.3.6.1.4.1.2021.11.1.0");
        Integer n2 = this.getSSIndex(snmpPdu);
        String string = CPUMonitorPane.fromBundle("Label_all_cpu_util");
        if (n2 == -1) {
            return false;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(n2, string);
        this.createComponent(hashMap);
        this._expressionName = "CPU Utilization from NET-SNMP agent";
        return true;
    }

    private boolean doWindowsSnmpAgent(AgentProperties agentProperties) throws IOException {
        SnmpTableModel snmpTableModel = null;
        String string = SnmpUtil.getTableOID(new SnmpOID(".1.3.6.1.2.1.25.3.3.1.2"));
        snmpTableModel = ClientProxy.getInstance().snmpGetTable(agentProperties, string);
        List list = this.getAllProcessorLoadOids(snmpTableModel, 1);
        if (snmpTableModel != null && snmpTableModel.getColumnCount() > 0 && list != null && list.size() != 0) {
            Map map = this.getDeviceIndex2DescrMap(agentProperties, list);
            if (!map.isEmpty()) {
                this.createComponent(map);
            }
            this._expressionName = "CPU load from MS Windows agent";
            return true;
        }
        return false;
    }

    private Integer getSSIndex(SnmpPdu snmpPdu) throws Exception {
        Integer n2 = -1;
        if (!snmpPdu.isSnmpV3AuthenticationFailed() && snmpPdu.getErrorStatus() <= 0) {
            int n3 = snmpPdu.getVarBindCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                SnmpVarBind snmpVarBind = snmpPdu.getVarBind(i2);
                SnmpDataType snmpDataType = snmpVarBind.getValue();
                String string = null;
                if (snmpDataType == null) continue;
                string = snmpDataType.toString();
                n2 = Integer.valueOf(MibUtil.translateValue(snmpVarBind.getName(), string));
            }
        }
        return n2;
    }

    private List getAllProcessorLoadOids(SnmpTableModel snmpTableModel, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (snmpTableModel == null) {
            return arrayList;
        }
        int n3 = snmpTableModel.getRowCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            SnmpVarBind snmpVarBind = snmpTableModel.get(i2, n2);
            String string = snmpVarBind.getName().toString();
            if (string == null || string.trim().length() == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Map getDeviceIndex2DescrMap(AgentProperties agentProperties, List list) throws IOException {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)list.get(i2);
            int n3 = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1, string.length()));
            SnmpPdu snmpPdu = ClientProxy.getInstance().snmpGetRequest(agentProperties, ".1.3.6.1.2.1.25.3.2.1.3." + n3);
            if (snmpPdu.isSnmpV3AuthenticationFailed() || snmpPdu.getErrorStatus() > 0) continue;
            int n4 = snmpPdu.getVarBindCount();
            for (int i3 = 0; i3 < n4; ++i3) {
                SnmpVarBind snmpVarBind = snmpPdu.getVarBind(i3);
                SnmpDataType snmpDataType = snmpVarBind.getValue();
                String string2 = null;
                string2 = snmpDataType == null ? "" : snmpDataType.toString();
                String string3 = MibUtil.translateValue(snmpVarBind.getName(), string2);
                hashMap.put(n3, string3);
            }
        }
        return hashMap;
    }

    public String getExpressionName() {
        return this._expressionName;
    }

    @Override
    protected String getTitleBorderText() {
        return CPUMonitorPane.fromBundle("Title_cpu");
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(CPUMonitorPane.class, (String)string);
    }
}

