/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.AgentProperties;
import com.ireasoning.util.Tokenizer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openide.util.NbBundle;

public class CheckProcessStateMonitorPane
extends SnmpDevicesMonitorPane {
    private String _expressionName = "";
    private List _allProcesses = new ArrayList();

    public CheckProcessStateMonitorPane(AgentProperties agentProperties) throws Exception {
        this._useCheckboxInMainPane = false;
        this._showUnit = false;
        this.initCheckProcessStateComponent(agentProperties);
    }

    private void initCheckProcessStateComponent(AgentProperties agentProperties) throws Exception {
        if (!this.doWindowsSNMPAgent(agentProperties) && !this.doNetSnmpAgent(agentProperties)) {
            throw new Exception(NbBundle.getMessage(CheckProcessStateMonitorPane.class, (String)"MSG_get_data_error"));
        }
    }

    private boolean doNetSnmpAgent(AgentProperties agentProperties) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = ".1.3.6.1.4.1.2021.2.1.2.s";
        String string2 = ".1.3.6.1.4.1.2021.2.1.100.s";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = (String)arrayList.get(i2);
            String string4 = string3.substring(0, string3.length() - 2);
            SnmpVarBind[] snmpVarBindArray = ClientProxy.getInstance().snmpGetSubtree(agentProperties, string4);
            if (snmpVarBindArray.length <= 0) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i3 = 0; i3 < snmpVarBindArray.length; ++i3) {
                stringBuffer.append(snmpVarBindArray[i3].getValue().toString());
                if (i3 == snmpVarBindArray.length - 1) continue;
                stringBuffer.append("\n");
            }
            hashMap.put(string3, stringBuffer.toString());
        }
        this.joinColumns(hashMap, arrayList);
        this.createComponent(null);
        this._expressionName = "Check Process State from NET-SNMP agent";
        return true;
    }

    private void joinColumns(Map map, List list) {
        Object object;
        Object object2;
        int n2;
        int n3 = list.size();
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (String)list.get(n2);
            String string = (String)map.get(object2);
            object = Tokenizer.parse(string, '\n');
            if (((String[])object).length > n4) {
                n4 = ((String[])object).length;
            }
            objectArray[n2] = object;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = "";
            for (int i2 = 0; i2 < n3; ++i2) {
                object = "";
                String[] stringArray = (String[])objectArray[i2];
                if (stringArray.length > n2) {
                    object = stringArray[n2];
                }
                object2 = (String)object2 + (String)object + "<>";
            }
            this._allProcesses.add(object2);
        }
    }

    private boolean doWindowsSNMPAgent(AgentProperties agentProperties) throws Exception {
        String string = ".1.3.6.1.2.1.25.4.2.1.2.s";
        String string2 = ".1.3.6.1.2.1.25.4.2.1.2.s".substring(0, string.length() - 2);
        SnmpVarBind[] snmpVarBindArray = ClientProxy.getInstance().snmpGetSubtree(agentProperties, string2);
        if (snmpVarBindArray == null || snmpVarBindArray.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < snmpVarBindArray.length; ++i2) {
            this._allProcesses.add(snmpVarBindArray[i2].getValue().toString());
        }
        this.createComponent(null);
        this._expressionName = "Check Process State";
        return true;
    }

    @Override
    protected JPanel initDevicesPane(Map map) {
        FormLayout formLayout = this.getFormLayout(this._allProcesses.size());
        CellConstraints cellConstraints = new CellConstraints();
        int n2 = 0;
        int n3 = this._allProcesses.size();
        CommonUtil.sortIgnoreCase(this._allProcesses);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = (String)this._allProcesses.get(i2);
            int n4 = string.indexOf("<>");
            ProcessRadioButton processRadioButton = new ProcessRadioButton(string);
            if (n4 > 0) {
                processRadioButton.setText(string.substring(0, n4));
            } else {
                processRadioButton.setText(string);
            }
            processRadioButton.addActionListener(new SelectedActionListener(this));
            buttonGroup.add(processRadioButton);
            jPanel.add((Component)processRadioButton, cellConstraints.xywh(1, ++n2, 3, 1));
            if (i2 != 0) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(processRadioButton.getText());
            if (processRadioButton.getProcess().indexOf("<>") > 0) {
                stringBuffer.append("<>").append("0");
                stringBuffer.append("<>");
            }
            this.setThresholdResult(stringBuffer.toString());
            processRadioButton.setSelected(true);
        }
        this.fillComponents(jPanel, n3);
        return jPanel;
    }

    public String getExpressionName() {
        return this._expressionName;
    }

    @Override
    protected String getTitleBorderText() {
        return CheckProcessStateMonitorPane.fromBundle("Title_check_process_state");
    }

    @Override
    public Map getAllSelectedCheckBoxIndex2DescrMap() {
        return null;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(CheckProcessStateMonitorPane.class, (String)string);
    }

    private class ProcessRadioButton
    extends JRadioButton {
        private String _process;

        public ProcessRadioButton(String string) {
            this._process = string;
        }

        public String getProcess() {
            return this._process;
        }
    }

    private class SelectedActionListener
    implements ActionListener {
        private DevicesMonitorPane _pane;

        public SelectedActionListener(DevicesMonitorPane devicesMonitorPane) {
            this._pane = devicesMonitorPane;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcessRadioButton processRadioButton;
            Object object = actionEvent.getSource();
            if (object instanceof ProcessRadioButton && (processRadioButton = (ProcessRadioButton)object).isSelected()) {
                String string = processRadioButton.getProcess();
                if (string.indexOf("<>") > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(processRadioButton.getText());
                    stringBuffer.append("<>").append("0");
                    stringBuffer.append("<>");
                    this._pane.setThresholdResult(stringBuffer.toString());
                } else {
                    this._pane.setThresholdResult(processRadioButton.getProcess());
                }
            }
        }
    }
}

