/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.AgentProperties;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ConciseCiscoMonitorFirstDialog;
import com.sysuptime.mainframe.performance.SingleSelectHybridPane;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.NbBundle;

class CiscoDevicePane
extends SingleSelectHybridPane {
    private static final String CURRENT_VALUE_COLON = NbBundle.getMessage(CiscoDevicePane.class, (String)"current_value") + ": ";
    private static final String CURRENT_VALUE = NbBundle.getMessage(CiscoDevicePane.class, (String)"current_value");
    private static final String[] OIDS = new String[]{".1.3.6.1.4.1.9.9.147.1.2.2.2.1.4", ".1.3.6.1.4.1.9.9.48.1.1.1.5.0", ".1.3.6.1.4.1.9.9.48.1.1.1.6.0", "1.3.6.1.4.1.9.2.1.57", "1.3.6.1.4.1.9.2.1.58", ".1.3.6.1.4.1.9.9.109.1.1.1.1.7", ".1.3.6.1.4.1.9.9.109.1.1.1.1.8", ".1.3.6.1.4.1.9.9.109.1.1.1.1.4", ".1.3.6.1.4.1.9.9.109.1.1.1.1.5", ".1.3.6.1.4.1.9.9.13.1.3.1.3", ".1.3.6.1.4.1.9.9.13.1.3.1.2", ".1.3.6.1.4.1.9.9.91.1.1.1.1.1", ".1.3.6.1.4.1.9.9.91.1.1.1.1.4", ".1.3.6.1.2.1.47.1.1.1.1.2"};

    public CiscoDevicePane(AgentProperties agentProperties) {
        this.init(agentProperties);
    }

    @Override
    protected String getTitleBorderText() {
        return NbBundle.getMessage(ConciseCiscoMonitorFirstDialog.class, (String)"Titile_cisco");
    }

    private void processNonRepeators(Map map, SnmpVarBind[] snmpVarBindArray, int n2) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[i2];
            SnmpOID snmpOID = snmpVarBind.getName();
            SnmpDataType snmpDataType = snmpVarBind.getValue();
            String string = snmpDataType.toString();
            if (i2 == 2 || bl2 && i2 <= 8 && i2 >= 5 || bl3 && i2 <= 8 && i2 >= 7 || snmpDataType.getType() == 130 || (i2 != 0 ? (i2 != 1 ? (i2 != 2 ? !snmpOID.startsWith(OIDS[i2]) : !snmpOID.startsWith(".1.3.6.1.4.1.9.9.48.1.1.1.6.1")) : !snmpOID.startsWith(".1.3.6.1.4.1.9.9.48.1.1.1.5.1")) : !snmpOID.startsWith(".1.3.6.1.4.1.9.9.147.1.2.2.2.1.5"))) continue;
            if (i2 == 0) {
                map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"active_connections") + ". " + CURRENT_VALUE_COLON + string, "Cisco PIX firewall: activeConnections");
                continue;
            }
            if (i2 == 1) {
                int n3 = Integer.parseInt(string);
                int n4 = Integer.parseInt(snmpVarBindArray[2].getValue().toString());
                map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"memory_util") + ". " + CURRENT_VALUE_COLON + n3 * 100 / (n3 + n4) + "%", "Cisco PIX firewall: memory utilization");
                continue;
            }
            if (i2 == 3) {
                map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"cpu_last1") + ". " + CURRENT_VALUE_COLON + string, "Cisco device: avgBusy1");
                bl2 = true;
                continue;
            }
            if (i2 == 4) {
                map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"cpu_last5") + ". " + CURRENT_VALUE_COLON + string, "Cisco device: avgBusy5");
                bl2 = true;
                continue;
            }
            if (i2 == 5) {
                map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"cpu_last1") + ". " + CURRENT_VALUE_COLON + string, "Cisco device: cpmCPUTotal1minRev@1");
                bl3 = true;
                continue;
            }
            if (i2 == 6) {
                map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"cpu_last5") + ". " + CURRENT_VALUE_COLON + string, "Cisco device: cpmCPUTotal5minRev@1");
                bl3 = true;
                continue;
            }
            if (i2 == 7) {
                map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"cpu_last1") + ". " + CURRENT_VALUE_COLON + string, "Cisco device: cpmCPUTotal1min@1");
                bl3 = true;
                continue;
            }
            if (i2 != 8) continue;
            map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"cpu_last5") + ". " + CURRENT_VALUE_COLON + string, "Cisco device: cpmCPUTotal5min@1");
            bl3 = true;
        }
    }

    private void processRepeators(Map map, SnmpVarBind[] snmpVarBindArray, int n2) {
        for (int i2 = n2; i2 < snmpVarBindArray.length; ++i2) {
            int n3 = i2 - n2;
            int n4 = n3 % 5;
            if (n4 != 0 && n4 != 2) continue;
            SnmpDataType snmpDataType = snmpVarBindArray[i2].getValue();
            SnmpOID snmpOID = snmpVarBindArray[i2].getName();
            if (snmpDataType.getType() == 130) continue;
            int n5 = snmpOID.get(snmpOID.getLength() - 1);
            if (n4 == 0) {
                if (!snmpOID.startsWith(".1.3.6.1.4.1.9.9.13.1.3.1.3")) continue;
                map.put("Temperature (" + snmpVarBindArray[i2 + 1].getValue() + "). " + CURRENT_VALUE + "(celsius): " + snmpDataType, "Cisco device: temperatureStatusValue@" + n5);
                continue;
            }
            if (n4 != 2 || !snmpOID.startsWith(".1.3.6.1.4.1.9.9.91.1.1.1.1.1") || !snmpDataType.toString().equals("8")) continue;
            Object object = "";
            if (snmpVarBindArray[i2 + 2].getValue().getType() != 130) {
                object = " (" + snmpVarBindArray[i2 + 2].getValue() + ")";
            }
            map.put(NbBundle.getMessage(CiscoDevicePane.class, (String)"label_temperature") + (String)object + ". " + CURRENT_VALUE + "(celsius): " + snmpVarBindArray[i2 + 1].getValue(), "Cisco device: censorValue@" + n5);
        }
    }

    private void init(AgentProperties agentProperties) {
        int n2 = 9;
        int n3 = 10;
        try {
            HashMap hashMap = new HashMap();
            SnmpPdu snmpPdu = ClientProxy.getInstance().snmpGetBulkRequest(agentProperties, OIDS, n2, n3);
            if (snmpPdu == null || snmpPdu.getErrorStatus() != 0) {
                throw new RuntimeException("No data available");
            }
            SnmpVarBind[] snmpVarBindArray = snmpPdu.getVarBinds();
            this.processNonRepeators(hashMap, snmpVarBindArray, n2);
            this.processRepeators(hashMap, snmpVarBindArray, n2);
            this._exprs = hashMap;
            if (hashMap.size() == 0) {
                throw new RuntimeException("No data available");
            }
            this.createComponent(hashMap);
        }
        catch (Exception exception) {
            throw new RuntimeException("No data available");
        }
    }
}

