/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.ProcessResult;
import com.sysuptime.mainframe.performance.ConciseMonitorUtil;
import com.sysuptime.mainframe.performance.ConciseWMIMonitorFirstDialog;
import com.sysuptime.mainframe.performance.ConciseWmiCPUMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPanelFactory;
import com.sysuptime.mainframe.performance.WmiDevicesMonitorPane;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseWmiCPUMonitorFirstDialog
extends ConciseWMIMonitorFirstDialog {
    public ConciseWmiCPUMonitorFirstDialog(DefaultTableModel defaultTableModel) {
        super(defaultTableModel);
        this.setTitle(ConciseWmiCPUMonitorFirstDialog.fromBundle("Title_wmi_cpu_util"));
    }

    public ConciseWmiCPUMonitorFirstDialog() {
        this.setTitle(ConciseWmiCPUMonitorFirstDialog.fromBundle("Title_wmi_cpu_util"));
    }

    @Override
    public WmiDevicesMonitorPane initDevicesMonitorPane(String string) {
        return DevicesMonitorPanelFactory.getInstance().createWmiCPUMonitorPane(string);
    }

    @Override
    public boolean checkResult(ProcessResult processResult) {
        if (super.checkResult(processResult)) {
            try {
                Double.parseDouble(processResult.getResult());
                return true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, processResult.getResult());
                return false;
            }
        }
        return false;
    }

    @Override
    public String getScriptFilePath() {
        return ConciseMonitorUtil.CPU_FILE_PATH;
    }

    @Override
    public void createNextDialog(DefaultTableModel defaultTableModel, WmiDevicesMonitorPane wmiDevicesMonitorPane, long l2, int n2, String string) {
        ConciseWmiCPUMonitorSecondDialog conciseWmiCPUMonitorSecondDialog = new ConciseWmiCPUMonitorSecondDialog(true, wmiDevicesMonitorPane, defaultTableModel, l2, n2, string);
        conciseWmiCPUMonitorSecondDialog.setVisible(true);
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseWmiCPUMonitorFirstDialog.class, (String)string);
    }
}

