/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorTestRun;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.ConciseMonitorUtil;
import com.sysuptime.mainframe.performance.ConciseWmiMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.WmiServiceMonitorPane;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseWmiServiceMonitorSecondDialog
extends ConciseWmiMonitorSecondDialog {
    private WmiServiceMonitorPane _serviceMonitorPane;

    public ConciseWmiServiceMonitorSecondDialog(boolean bl2, DevicesMonitorPane devicesMonitorPane, DefaultTableModel defaultTableModel, long l2, int n2, String string) {
        super(bl2, ConciseWmiServiceMonitorSecondDialog.fromBundle("Title_wmi_service_util"), devicesMonitorPane, defaultTableModel, l2, n2, string);
        this._serviceMonitorPane = (WmiServiceMonitorPane)devicesMonitorPane;
        this._serviceMonitorPane.setThresholdCondition(DialogConstants.EXCLUDE);
    }

    @Override
    protected String getFilePath() {
        return ConciseMonitorUtil.CHECK_SERVICE_FILE_PATH;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseWmiServiceMonitorSecondDialog.class, (String)string);
    }

    @Override
    protected void formatResult(StringBuffer stringBuffer, MonitorTestRun monitorTestRun) {
        String string = this._serviceMonitorPane.getThresholdResult();
        for (Map.Entry entry : monitorTestRun.getResultMap().entrySet()) {
            Integer n2 = (Integer)entry.getKey();
            ResultValue resultValue = (ResultValue)entry.getValue();
            String string2 = MonitorHelper.getConstantLocaleName(n2);
            if (resultValue.isError()) {
                stringBuffer.append("<b>").append(Snippet.getBundledString("errormessage")).append(" ( ").append(string2).append(" ) ").append(":").append("</b>").append("<br>");
                stringBuffer.append(resultValue.getErrorUnknownMessage());
            } else {
                stringBuffer.append("<b>").append(this.getQueryResultString()).append(" ").append("</b>");
                if (resultValue.isNormal()) {
                    stringBuffer.append("<table><tr><td><pre>").append(this.getRunningService(resultValue.getValue().toString(), string)).append("</pre></table>");
                } else if (resultValue.isUnknown()) {
                    stringBuffer.append(resultValue.getErrorUnknownMessage());
                }
            }
            stringBuffer.append("<p>");
        }
        stringBuffer.append("<p>").append(monitorTestRun.getErrorText());
        stringBuffer.append("<br>");
    }

    @Override
    protected String getQueryResultString() {
        return ConciseWmiServiceMonitorSecondDialog.fromBundle("wmi_service_state_result");
    }

    @Override
    protected List getOtherParameter(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this._serviceMonitorPane.getThresholdResult());
        return arrayList;
    }

    private String getRunningService(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(string2) < 0) continue;
            bl2 = true;
            stringBuffer.append("<b>").append(string3).append(" ");
            stringBuffer.append(ConciseWmiServiceMonitorSecondDialog.fromBundle("MSG_service_is_running")).append("</b>").append("<br>");
        }
        if (!bl2) {
            stringBuffer.append("<b>").append(string2).append(" ");
            stringBuffer.append(ConciseWmiServiceMonitorSecondDialog.fromBundle("MSG_service_stopped")).append("</b>").append("<br>");
        }
        return stringBuffer.toString();
    }

    @Override
    protected int getMonitorType() {
        return this.WINDOWS_SERVICE_TYPE;
    }
}

