/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.openapi.performance.DefaultProtocolDialog;
import com.sysuptime.common.performance.Baseline;
import com.sysuptime.common.performance.ConfigThresholdElement;
import com.sysuptime.common.performance.FixedThreshold;
import com.sysuptime.common.performance.Metrics;
import com.sysuptime.common.performance.MetricsTimebucket;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.StatisticalThreshold;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.performance.TimebucketItem;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.PermittedBreaksValidator;
import com.sysuptime.mainframe.performance.PositiveLongValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DefaultThresholdDialog
extends ConfirmDialog {
    private static final String ENABLE_THRESHOLD = _bundle.getString("label_enablethreshold");
    private static final String REARM = _bundle.getString("panel_rearm");
    private static final String ARM_BREAKS_1 = _bundle.getString("label_armpermittedbreaks1");
    private static final String ARM_BREAKS_2 = _bundle.getString("label_armpermittedbreaks2");
    private static final String ARM_BREAKS_3 = _bundle.getString("message_armpermittedbreaks3");
    private static final String REARM_BREAKS_1 = _bundle.getString("label_rearmpermittedbreaks1");
    private static final String REARM_BREAKS_2 = _bundle.getString("label_rearmpermittedbreaks2");
    private static final String REARM_BREAKS_3 = _bundle.getString("message_rearmpermittedbreaks3");
    private static final String INTERVAL = _bundle.getString("label_baselineinterval");
    private static final String MESSAGE_STAT_CONDITION = _bundle.getString("message_statcondition");
    private static final String GENERATE_ALARM = _bundle.getString("label_generatealarm");
    private static final String GENERATE_REARM = _bundle.getString("label_generaterearm");
    private static final String MESSAGE_CONFLICT_THRESHOLDS = _bundle.getString("message_conflictthresholds");
    private static final String MESSAGE_INVALID_THRESHOLDS = _bundle.getString("message_invalidthresholds");
    private static final String MESSAGE_THRESHOLDS_FORMAT = _bundle.getString("message_thresholdsformat");
    private static final String LABEL_FIXED = _bundle.getString("label_fixed");
    private static final String LABEL_STATISTICAL = _bundle.getString("label_statistical");
    private static final String LABEL_TIMES = _bundle.getString("label_times");
    private static final String LABEL_DEV = _bundle.getString("label_stddev");
    private static final String LABEL_AVG = _bundle.getString("label_avg");
    private static final String[] COMBOBOX_AVG = new String[]{DialogConstants.ABOVE, DialogConstants.BELOW};
    private JCheckBox _isThresholdEnabledBox;
    private ThresholdPanel[] _thresholds;
    private List _metricsList;
    private JPanel _bodyPanel;
    private ConfigThresholdElement _configElement;
    private int _index;
    private Metrics _metrics;
    private List _metricsTimebucketList;
    private String _localeMetrics;
    private String _unit;
    private boolean _isNumeric;
    private static final int ALARM_INDEX = 0;
    private static final int REARM_INDEX = 1;

    public DefaultThresholdDialog(Dialog dialog, boolean bl2, String string, String string2, List list, int n2, boolean bl3, boolean bl4) {
        super(dialog, string, bl2);
        this._isNumeric = bl4;
        this.initMetrics(dialog, string, string2, list, n2);
        this.initComponents();
        ChangedItem changedItem = new ChangedItem();
        this.addListenersBeforeUser(changedItem);
        this.initBeforeUserData(bl3);
        this.initUserData();
        this.addListenersAfterUser(changedItem);
    }

    private void initMetrics(Dialog dialog, String string, String string2, List list, int n2) {
        this._localeMetrics = string;
        this._metricsList = list;
        this._index = n2;
        DefaultProtocolDialog defaultProtocolDialog = (DefaultProtocolDialog)dialog;
        ServiceNameElement serviceNameElement = defaultProtocolDialog.getServiceNameElement();
        this._configElement = MonitorHelper.getConfig(serviceNameElement, defaultProtocolDialog.getMetricsName(), string2);
        this.initUnit();
    }

    private void initUnit() {
        String string = this._configElement.getUnit();
        this._unit = string == null ? "" : _bundle.getString(string);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getTitledPanel(), "North");
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getTitledPanel() {
        FormLayout formLayout = new FormLayout("l:p", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._isThresholdEnabledBox = new JCheckBox(ENABLE_THRESHOLD, true);
        this._isThresholdEnabledBox.setToolTipText(_bundle.getString("tooltip_isThresholdEnabled"));
        panelBuilder.add((Component)this._isThresholdEnabledBox, cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    private void addListenersBeforeUser(ChangedItem changedItem) {
        this._thresholds[0]._fixedStatisticalBox.addItemListener(changedItem);
        this._thresholds[0]._fixedBox.addItemListener(changedItem);
        this._thresholds[0]._stddevStatisticalBox.addItemListener(changedItem);
        this._thresholds[0]._avgStatisticalBox.addItemListener(changedItem);
        this._thresholds[0]._statMode.addItemListener(changedItem);
        AdvancedAction advancedAction = new AdvancedAction();
        this._thresholds[0]._fixedAdvance.addActionListener(advancedAction);
        this._thresholds[0]._statAdvance.addActionListener(advancedAction);
        this._thresholds[1]._fixedAdvance.addActionListener(advancedAction);
    }

    private void addListenersAfterUser(ChangedItem changedItem) {
        this._isThresholdEnabledBox.addItemListener(changedItem);
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p:g", "p,3dlu,p,3dlu,p:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._thresholds = new ThresholdPanel[2];
        panelBuilder.add((Component)this.getArmPanel(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.getRearmPanel(), cellConstraints.xy(1, 5));
        this._bodyPanel = panelBuilder.getPanel();
        return this._bodyPanel;
    }

    private JPanel getArmPanel() {
        this._thresholds[0] = new ThresholdPanel(DialogConstants.LABEL_THRESHOLD, true);
        if (this._configElement.isFixedOnly()) {
            this._thresholds[0]._fixedStatisticalBox.setEnabled(false);
        }
        this._thresholds[0]._labelSeverity.setVisible(true);
        this._thresholds[0]._severityBox.setVisible(true);
        this._thresholds[0]._severityBox.setSelectedIndex(1);
        ChangedDocument changedDocument = new ChangedDocument();
        this._thresholds[0]._fixedThreshold.getDocument().addDocumentListener(changedDocument);
        this._thresholds[0]._statisticalThreshold.getDocument().addDocumentListener(changedDocument);
        this._thresholds[0]._breaks.getDocument().addDocumentListener(changedDocument);
        this._thresholds[0]._statMode.setEnabled(true);
        this._thresholds[0]._labelPeriod.setVisible(true);
        this._thresholds[0]._period.setVisible(true);
        this._thresholds[0]._periodBox.setVisible(true);
        this._thresholds[0]._statAdvance.setVisible(true);
        this.setSize(this.getPreferredSize());
        return this._thresholds[0].getPanel();
    }

    private JPanel getRearmPanel() {
        this._thresholds[1] = new ThresholdPanel(REARM, false);
        this._thresholds[1]._fixedStatisticalBox.setEnabled(false);
        this._thresholds[1]._fixedBox.setSelectedIndex(this._thresholds[1]._fixedBox.getItemCount() - 1);
        this._thresholds[1]._fixedBox.setEnabled(false);
        this._thresholds[1]._stddevStatisticalBox.setSelectedIndex(DialogConstants.COMBOBOX_STATISTICAL_CONDITION.length - 1);
        this._thresholds[1]._avgStatisticalBox.setSelectedIndex(COMBOBOX_AVG.length - 1);
        this._thresholds[1]._fixedAdvance.setEnabled(false);
        return this._thresholds[1].getPanel();
    }

    private void initBeforeUserData(boolean bl2) {
        String string;
        String string2;
        this.setStatisticalEnabled(false);
        if (this._configElement.isNoThreshold() || bl2) {
            if (!this._isNumeric) {
                this._thresholds[0]._fixedBox.setSelectedItem(DialogConstants.EXCLUDE);
            }
            this._thresholds[0]._fixedBox.setVisible(false);
            this._thresholds[0]._fixedThreshold.setText(ICommonBundle.ERROR);
            this._thresholds[0]._fixedThreshold.setVisible(false);
            this._thresholds[0]._fixedAdvance.setEnabled(false);
            this._thresholds[0]._noThreshold.setVisible(true);
            this._thresholds[1]._fixedBox.setVisible(false);
            this._thresholds[1]._fixedThreshold.setText(ICommonBundle.OK);
            this._thresholds[1]._fixedThreshold.setVisible(false);
            this._thresholds[1]._noThreshold.setVisible(true);
            return;
        }
        if (this._isNumeric) {
            this._thresholds[0]._fixedBox.setSelectedItem(DialogConstants.ABOVE);
        } else {
            string2 = this._configElement.getLocalizedCondition();
            if (string2 != null) {
                this._thresholds[0]._fixedBox.setSelectedItem(string2);
            }
        }
        string2 = this._configElement.getValue();
        if (string2 != null) {
            this._thresholds[0]._fixedThreshold.setText(string2);
        }
        if ((string = this._configElement.getValueTooltip()) != null) {
            String string3 = Snippet.getBundledString(string);
            if (string3 != null) {
                string = string3;
            }
            this._thresholds[0]._fixedThreshold.setToolTipText(string);
            this._thresholds[1]._fixedThreshold.setToolTipText(string);
        }
    }

    private void initUserData() {
        this._metricsTimebucketList = new ArrayList();
        if (this._index != -1) {
            this._metrics = (Metrics)this._metricsList.get(this._index);
            if (this._metrics.isThresholdEnabled()) {
                this.initBodyData();
            } else {
                this._isThresholdEnabledBox.setSelected(false);
                this._bodyPanel.setVisible(false);
                this.setSize(this.getPreferredSize());
                SwingUtil.centerOnScreen(this);
            }
        } else {
            this._metrics = TargetFactory.getBaseline();
        }
    }

    private void initBodyData() {
        this.initMetrics();
        this.initStatThreshold();
        this.initFixedThreshold();
        this.initRearmAdvanceButton();
    }

    private void initMetrics() {
        this._thresholds[0]._fixedStatisticalBox.setSelectedIndex(this._metrics.getFixedStatisticalId());
        this._thresholds[0]._breaks.setText(String.valueOf(this._metrics.getArmBreaks()));
        this._thresholds[1]._breaks.setText(String.valueOf(this._metrics.getRearmBreaks()));
    }

    private void initStatThreshold() {
        if (!(this._metrics instanceof Baseline)) {
            return;
        }
        Baseline baseline = (Baseline)this._metrics;
        int n2 = baseline.getStatThresholdListSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            StatisticalThreshold statisticalThreshold = baseline.getStatThreshold(i2);
            if (!statisticalThreshold.isClearAlarm()) {
                this._thresholds[0]._severityBox.setSelectedIndex(statisticalThreshold.getSeverityId());
                this.setStddevOrAvgVisible(statisticalThreshold.isStddev());
                if (statisticalThreshold.isStddev()) {
                    this._thresholds[0]._stddevStatisticalBox.setSelectedIndex(statisticalThreshold.getStatisticalConditionId());
                } else {
                    this._thresholds[0]._avgStatisticalBox.setSelectedIndex(statisticalThreshold.getStatisticalConditionId());
                }
                this._thresholds[0]._statisticalThreshold.setText(String.valueOf(statisticalThreshold.getStatisticalThreshold()));
                this._thresholds[0]._statMode.setSelectedIndex(statisticalThreshold.isStddev() ? 0 : 1);
                continue;
            }
            this._thresholds[1]._stddevStatisticalBox.setSelectedIndex(statisticalThreshold.getStatisticalConditionId());
            this._thresholds[1]._statisticalThreshold.setText(String.valueOf(statisticalThreshold.getStatisticalThreshold()));
        }
        if (n2 > 0) {
            this.initPeriod();
        }
    }

    private void setStddevOrAvgVisible(boolean bl2) {
        this._thresholds[0]._stddevStatisticalBox.setVisible(bl2);
        this._thresholds[0]._avgStatisticalBox.setVisible(!bl2);
        this._thresholds[1]._stddevStatisticalBox.setVisible(bl2);
        this._thresholds[1]._avgStatisticalBox.setVisible(!bl2);
    }

    private void initPeriod() {
        Baseline baseline = (Baseline)this._metrics;
        short s2 = baseline.getUnit();
        this._thresholds[0]._periodBox.setSelectedIndex(s2);
        long l2 = baseline.getPeriod() / 60000L;
        if (s2 == 1) {
            l2 /= 60L;
        } else if (s2 == 2) {
            l2 /= 1440L;
        }
        this._thresholds[0]._period.setText(String.valueOf(l2));
    }

    private void initFixedThreshold() {
        int n2 = this._metrics.getMetricsTimebucketListSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            MetricsTimebucket metricsTimebucket = this._metrics.getMetricsTimebucket(i2);
            if (metricsTimebucket.getTimebucketId() == -1L) {
                this.initDefaultFixedThreshold(metricsTimebucket);
                continue;
            }
            try {
                this._metricsTimebucketList.add(metricsTimebucket.clone());
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this._logger.error((Object)"init error", (Throwable)cloneNotSupportedException);
            }
        }
    }

    private void initDefaultFixedThreshold(MetricsTimebucket metricsTimebucket) {
        int n2 = metricsTimebucket.getThresholdListSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            FixedThreshold fixedThreshold = metricsTimebucket.getThreshold(i2);
            if (!fixedThreshold.isClearAlarm()) {
                this._thresholds[0]._severityBox.setSelectedIndex(fixedThreshold.getSeverityId());
                this._thresholds[0]._fixedBox.setSelectedIndex(fixedThreshold.getFixedConditionId());
                this._thresholds[0]._fixedThreshold.setText(fixedThreshold.getFixedThreshold());
                continue;
            }
            this._thresholds[1]._severityBox.setSelectedIndex(fixedThreshold.getSeverityId());
            this._thresholds[1]._fixedBox.setSelectedIndex(fixedThreshold.getFixedConditionId());
            this._thresholds[1]._fixedThreshold.setText(fixedThreshold.getFixedThreshold());
        }
    }

    private void initRearmAdvanceButton() {
        if (this._metricsTimebucketList.size() == 0) {
            this._thresholds[1]._fixedAdvance.setEnabled(false);
        } else {
            this._thresholds[1]._fixedAdvance.setEnabled(true);
        }
    }

    private void setThresholdEnabled(boolean bl2) {
        this._bodyPanel.setVisible(bl2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultThresholdDialog.this.setSize(DefaultThresholdDialog.this.getPreferredSize());
                SwingUtil.centerOnScreen(DefaultThresholdDialog.this);
            }
        });
    }

    private void setStatisticalEnabled(boolean bl2) {
        this._thresholds[0]._stddevStatisticalBox.setEnabled(bl2);
        this._thresholds[0]._avgStatisticalBox.setEnabled(bl2);
        this._thresholds[0]._statisticalThreshold.setEnabled(bl2);
        this._thresholds[0]._statMode.setEnabled(bl2);
        this._thresholds[0]._period.setEnabled(bl2);
        this._thresholds[0]._periodBox.setEnabled(bl2);
        this._thresholds[0]._statAdvance.setEnabled(bl2);
        this._thresholds[1]._stddevStatisticalBox.setEnabled(bl2);
        this._thresholds[1]._avgStatisticalBox.setEnabled(bl2);
        this._thresholds[1]._statisticalThreshold.setEnabled(bl2);
        this._thresholds[1]._statAdvance.setEnabled(bl2);
    }

    private void setFixedEnabled(boolean bl2) {
        this._thresholds[0]._fixedBox.setEnabled(bl2);
        this._thresholds[0]._fixedThreshold.setEnabled(bl2);
        this._thresholds[0]._fixedAdvance.setEnabled(bl2);
        this._thresholds[1]._fixedThreshold.setEnabled(bl2);
        this._thresholds[1]._fixedAdvance.setEnabled(bl2);
        this.initRearmAdvanceButton();
    }

    @Override
    protected void okDialog() {
        if (this._isThresholdEnabledBox.isSelected()) {
            if (this.checkMetrics()) {
                boolean bl2 = false;
                boolean bl3 = false;
                int n2 = this._thresholds[0]._fixedStatisticalBox.getSelectedIndex();
                if (n2 != 0 && !this.checkStatThreshold()) {
                    return;
                }
                if (n2 != 1 && (!(bl2 = this.isCoverAll()) ? !this.checkAllFixedThresholds() : (bl3 = this.isRearmUseDefault()) && !this.checkFixedThreshold(true))) {
                    return;
                }
                this.clearMetrics();
                this.setMetrics(true);
                if (!bl2) {
                    this.setFixedThreshold();
                } else if (bl3) {
                    this.setRearmFixedThreshold();
                }
                this.setStatThreshold();
                this.setAdvThresholds();
                this.dispose();
            }
        } else {
            this.clearMetrics();
            this.setMetrics(false);
            this.dispose();
        }
    }

    private void clearMetrics() {
        this._metrics.removeAllMetricsTimebuckets();
        if (this._metrics instanceof Baseline) {
            ((Baseline)this._metrics).removeAllThresholds();
        }
    }

    private boolean isCoverAll() {
        int n2 = this._metricsTimebucketList.size();
        if (n2 > 0) {
            Cloneable cloneable;
            Cloneable cloneable2;
            int n3;
            Hashtable hashtable = MonitorBroker.getTimebucketNameToObject();
            ArrayList arrayList = new ArrayList();
            for (n3 = 0; n3 < n2; ++n3) {
                cloneable2 = (Timebucket)this._metricsTimebucketList.get(n3);
                cloneable = (Timebucket)hashtable.get(((Timebucket)cloneable2).getTimebucketName());
                arrayList.addAll(((Timebucket)cloneable).getTimebucketItemList());
            }
            Collections.sort(arrayList);
            n3 = arrayList.size();
            cloneable2 = (TimebucketItem)arrayList.get(0);
            if (((TimebucketItem)cloneable2).getStartDayId() > 1 || ((TimebucketItem)cloneable2).getStartTime() > 0) {
                return false;
            }
            cloneable = (TimebucketItem)arrayList.get(n3 - 1);
            if (((TimebucketItem)cloneable).getEndDayId() < 7 || ((TimebucketItem)cloneable).getEndTime() < 86340) {
                return false;
            }
            for (int i2 = 0; i2 < n3 - 1; ++i2) {
                TimebucketItem timebucketItem = (TimebucketItem)arrayList.get(i2);
                TimebucketItem timebucketItem2 = (TimebucketItem)arrayList.get(i2 + 1);
                if (timebucketItem.getEndDayId() == timebucketItem2.getStartDayId() && timebucketItem.getEndTime() == timebucketItem2.getStartTime() - 1 || timebucketItem.getEndDayId() == timebucketItem2.getStartDayId() - 1 && timebucketItem.getEndTime() >= 86340 && timebucketItem2.getStartTime() <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isRearmUseDefault() {
        int n2 = this._metricsTimebucketList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MetricsTimebucket metricsTimebucket = (MetricsTimebucket)this._metricsTimebucketList.get(i2);
            if (!metricsTimebucket.containThreshold(true)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAllFixedThresholds() {
        if (!this.checkFixedThreshold(false)) {
            return false;
        }
        if (!this.checkFixedThreshold(true)) {
            return false;
        }
        if (this.isConflictThresholds()) {
            JOptionPane.showMessageDialog(this, MESSAGE_CONFLICT_THRESHOLDS);
            return false;
        }
        return true;
    }

    private boolean checkFixedThreshold(boolean bl2) {
        int n2 = 0;
        if (bl2) {
            n2 = 1;
        }
        Object object = null;
        int n3 = this._thresholds[n2]._fixedBox.getSelectedIndex();
        if (n3 != 3 && n3 != 6) {
            if (n3 != 4 && n3 != 5) {
                object = SingletonValidator.checkAllDialog(this, LABEL_FIXED, this._thresholds[n2]._fixedThreshold.getText(), NumberValidator.CLASS);
                if (object == null) {
                    return false;
                }
            } else {
                String string = this.parseThreshold(this._thresholds[n2]._fixedThreshold.getText());
                String[] stringArray = string.split("~");
                if (stringArray.length != 2) {
                    JOptionPane.showMessageDialog(this, MESSAGE_THRESHOLDS_FORMAT);
                    return false;
                }
                Object object2 = SingletonValidator.checkAllDialog(this, LABEL_FIXED, stringArray[0].trim(), NumberValidator.CLASS);
                if (object2 == null) {
                    return false;
                }
                Object object3 = SingletonValidator.checkAllDialog(this, LABEL_FIXED, stringArray[1].trim(), NumberValidator.CLASS);
                if (object3 == null) {
                    return false;
                }
                if ((Double)object2 >= (Double)object3) {
                    JOptionPane.showMessageDialog(this, MESSAGE_INVALID_THRESHOLDS);
                    return false;
                }
                object = String.valueOf(object2) + "~" + String.valueOf(object3);
            }
        } else {
            object = SingletonValidator.checkAllDialog(this, LABEL_FIXED, this._thresholds[n2]._fixedThreshold.getText(), NonNullValidator.CLASS);
            if (object == null) {
                return false;
            }
        }
        this._thresholds[n2]._fixedConditionId = (short)this._thresholds[n2]._fixedBox.getSelectedIndex();
        this._thresholds[n2]._checkedFixedThreshold = String.valueOf(object);
        return true;
    }

    private boolean checkStatThreshold() {
        for (int i2 = 0; i2 < 2; ++i2) {
            Double d10 = (Double)SingletonValidator.checkAllDialog(this, LABEL_STATISTICAL, this._thresholds[i2]._statisticalThreshold.getText(), NumberValidator.CLASS);
            if (d10 == null) {
                return false;
            }
            if (i2 == 0) {
                Long l2 = (Long)SingletonValidator.checkAllDialog(this, INTERVAL, this._thresholds[i2]._period.getText(), PositiveLongValidator.CLASS);
                if (l2 == null) {
                    return false;
                }
                this.calculatePeriod(l2);
            } else if (!this.checkStatCondition()) {
                JOptionPane.showMessageDialog(this, MESSAGE_STAT_CONDITION);
                return false;
            }
            this._thresholds[i2]._checkedStatisticalThreshold = d10;
        }
        return true;
    }

    private boolean checkMetrics() {
        for (int i2 = 0; i2 < 2; ++i2) {
            Short s2 = null;
            s2 = i2 == 0 ? (Short)SingletonValidator.checkAllDialog(this, ARM_BREAKS_3, this._thresholds[i2]._breaks.getText(), PermittedBreaksValidator.CLASS) : (Short)SingletonValidator.checkAllDialog(this, REARM_BREAKS_3, this._thresholds[i2]._breaks.getText(), PermittedBreaksValidator.CLASS);
            if (s2 == null) {
                return false;
            }
            this._thresholds[i2]._fixedStatisticalId = (short)this._thresholds[i2]._fixedStatisticalBox.getSelectedIndex();
            this._thresholds[i2]._severityId = (short)this._thresholds[i2]._severityBox.getSelectedIndex();
            this._thresholds[i2]._checkedBreaks = s2;
        }
        return true;
    }

    private boolean isConflictThresholds() {
        if (this._thresholds[0]._fixedConditionId == 0 || this._thresholds[0]._fixedConditionId == 1 || this._thresholds[0]._fixedConditionId == 8 || this._thresholds[0]._fixedConditionId == 9) {
            boolean bl2 = this._thresholds[0]._fixedConditionId == 0 || this._thresholds[0]._fixedConditionId == 1;
            double d10 = Double.parseDouble(this._thresholds[0]._checkedFixedThreshold);
            double d11 = Double.parseDouble(this._thresholds[1]._checkedFixedThreshold);
            if (bl2 ? d10 < d11 : d11 < d10) {
                return true;
            }
        }
        if (this._thresholds[0]._fixedConditionId == 4) {
            String[] stringArray = this._thresholds[0]._checkedFixedThreshold.split("~");
            String[] stringArray2 = this._thresholds[1]._checkedFixedThreshold.split("~");
            if (Double.parseDouble(stringArray[0]) < Double.parseDouble(stringArray2[0]) || Double.parseDouble(stringArray[1]) > Double.parseDouble(stringArray2[1])) {
                return true;
            }
        }
        if (this._thresholds[0]._fixedConditionId == 5) {
            String[] stringArray = this._thresholds[0]._checkedFixedThreshold.split("~");
            String[] stringArray3 = this._thresholds[1]._checkedFixedThreshold.split("~");
            if (Double.parseDouble(stringArray[0]) > Double.parseDouble(stringArray3[0]) || Double.parseDouble(stringArray[1]) < Double.parseDouble(stringArray3[1])) {
                return true;
            }
        }
        return false;
    }

    private boolean checkStatCondition() {
        if (this._thresholds[0]._statMode.getSelectedItem().equals(LABEL_DEV)) {
            Object object = this._thresholds[0]._stddevStatisticalBox.getSelectedItem();
            Object object2 = this._thresholds[1]._stddevStatisticalBox.getSelectedItem();
            if (object.equals(DialogConstants.ABOVE) ? object2.equals(DialogConstants.ABOVE) || object2.equals(DialogConstants.ABOVE_OR_WITHIN) || object2.equals(DialogConstants.ABOVE_OR_BELOW) : (object.equals(DialogConstants.ABOVE_OR_WITHIN) ? !object2.equals(DialogConstants.BELOW) : (object.equals(DialogConstants.WITHIN) ? object2.equals(DialogConstants.ABOVE_OR_WITHIN) || object2.equals(DialogConstants.WITHIN) || object2.equals(DialogConstants.WITHIN_OR_BELOW) : (object.equals(DialogConstants.ABOVE_OR_BELOW) ? !object2.equals(DialogConstants.WITHIN) : (object.equals(DialogConstants.BELOW) ? object2.equals(DialogConstants.ABOVE_OR_BELOW) || object2.equals(DialogConstants.BELOW) || object2.equals(DialogConstants.WITHIN_OR_BELOW) : object.equals(DialogConstants.WITHIN_OR_BELOW) && !object2.equals(DialogConstants.ABOVE)))))) {
                return false;
            }
        }
        return true;
    }

    private void calculatePeriod(long l2) {
        long l3 = l2 * 60000L;
        int n2 = this._thresholds[0]._periodBox.getSelectedIndex();
        if (n2 == 1) {
            l3 *= 60L;
        } else if (n2 == 2) {
            l3 *= 1440L;
        }
        this._thresholds[0]._checkedPeriod = l3;
    }

    private void setMetrics(boolean bl2) {
        this._metrics.setThresholdEnabled(bl2);
        this._metrics.setFixedStatisticalId(this._thresholds[0]._fixedStatisticalId);
        this._metrics.setArmBreaks(this._thresholds[0]._checkedBreaks);
        this._metrics.setRearmBreaks(this._thresholds[1]._checkedBreaks);
        if (this._index == -1) {
            this._metrics.setResultTypeId(MonitorHelper.getConstantId(this._configElement.getName()));
            this._metricsList.add(this._metrics);
        }
    }

    private void setFixedThreshold() {
        if (this._thresholds[0]._fixedStatisticalBox.getSelectedIndex() != 1) {
            MetricsTimebucket metricsTimebucket = TargetFactory.getMetricsTimebucket();
            for (int i2 = 0; i2 < 2; ++i2) {
                FixedThreshold fixedThreshold = TargetFactory.getFixedThreshold();
                if (i2 == 0) {
                    fixedThreshold.setClearAlarm(false);
                } else {
                    fixedThreshold.setClearAlarm(true);
                }
                fixedThreshold.setSeverityId(this._thresholds[i2]._severityId);
                fixedThreshold.setFixedConditionId(this._thresholds[i2]._fixedConditionId);
                fixedThreshold.setFixedThreshold(this._thresholds[i2]._checkedFixedThreshold);
                metricsTimebucket.addThreshold(fixedThreshold);
            }
            metricsTimebucket.setTimebucketId(-1L);
            this._metrics.addMetricsTimebucket(metricsTimebucket);
        }
    }

    private void setRearmFixedThreshold() {
        if (this._thresholds[0]._fixedStatisticalBox.getSelectedIndex() != 1) {
            MetricsTimebucket metricsTimebucket = TargetFactory.getMetricsTimebucket();
            FixedThreshold fixedThreshold = TargetFactory.getFixedThreshold();
            fixedThreshold.setClearAlarm(true);
            fixedThreshold.setSeverityId(this._thresholds[1]._severityId);
            fixedThreshold.setFixedConditionId(this._thresholds[1]._fixedConditionId);
            fixedThreshold.setFixedThreshold(this._thresholds[1]._checkedFixedThreshold);
            metricsTimebucket.addThreshold(fixedThreshold);
            metricsTimebucket.setTimebucketId(-1L);
            this._metrics.addMetricsTimebucket(metricsTimebucket);
        }
    }

    private void setStatThreshold() {
        if (this._thresholds[0]._fixedStatisticalBox.getSelectedIndex() != 0) {
            Baseline baseline = (Baseline)this._metrics;
            for (int i2 = 0; i2 < 2; ++i2) {
                StatisticalThreshold statisticalThreshold = TargetFactory.getStatisticalThreshold();
                if (i2 == 0) {
                    statisticalThreshold.setClearAlarm(false);
                    baseline.setPeriod(this._thresholds[0]._checkedPeriod);
                    baseline.setUnit((short)this._thresholds[0]._periodBox.getSelectedIndex());
                } else {
                    statisticalThreshold.setClearAlarm(true);
                }
                statisticalThreshold.setSeverityId(this._thresholds[i2]._severityId);
                statisticalThreshold.setStatisticalThreshold(this._thresholds[i2]._checkedStatisticalThreshold);
                int n2 = this._thresholds[i2]._statMode.getSelectedIndex();
                if (this._thresholds[i2]._statMode.getItemAt(n2).equals(LABEL_DEV)) {
                    statisticalThreshold.setStatisticalConditionId((short)this._thresholds[i2]._stddevStatisticalBox.getSelectedIndex());
                    statisticalThreshold.setStddev(true);
                } else {
                    statisticalThreshold.setStatisticalConditionId((short)this._thresholds[i2]._avgStatisticalBox.getSelectedIndex());
                    statisticalThreshold.setStddev(false);
                }
                baseline.addStatThreshold(statisticalThreshold);
            }
        }
    }

    private void setAdvThresholds() {
        this._metrics.addMetricsTimebucketList(this._metricsTimebucketList);
    }

    private String parseThreshold(String string) {
        return string.replaceAll("[-,~,,,;,|,&,#,:]+", "~");
    }

    private class ChangedItem
    implements ItemListener {
        private ChangedItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable.equals(DefaultThresholdDialog.this._isThresholdEnabledBox)) {
                DefaultThresholdDialog.this.setThresholdEnabled(itemEvent.getStateChange() == 1);
            } else if (itemEvent.getStateChange() == 1) {
                if (itemSelectable.equals(DefaultThresholdDialog.this._thresholds[0]._fixedStatisticalBox)) {
                    int n2 = DefaultThresholdDialog.this._thresholds[0]._fixedStatisticalBox.getSelectedIndex();
                    DefaultThresholdDialog.this._thresholds[1]._fixedStatisticalBox.setSelectedIndex(n2);
                    if (n2 == 0) {
                        DefaultThresholdDialog.this.setFixedEnabled(true);
                        DefaultThresholdDialog.this.setStatisticalEnabled(false);
                    } else if (n2 == 1) {
                        DefaultThresholdDialog.this.setFixedEnabled(false);
                        DefaultThresholdDialog.this.setStatisticalEnabled(true);
                    } else {
                        DefaultThresholdDialog.this.setFixedEnabled(true);
                        DefaultThresholdDialog.this.setStatisticalEnabled(true);
                    }
                } else if (itemSelectable.equals(DefaultThresholdDialog.this._thresholds[0]._fixedBox)) {
                    int n3 = DefaultThresholdDialog.this._thresholds[0]._fixedBox.getSelectedIndex();
                    int n4 = DialogConstants.COMBOBOX_FIXED_CONDITION.length - 1 - n3;
                    DefaultThresholdDialog.this._thresholds[1]._fixedBox.setSelectedIndex(n4);
                } else if (itemSelectable.equals(DefaultThresholdDialog.this._thresholds[0]._stddevStatisticalBox)) {
                    int n5 = DefaultThresholdDialog.this._thresholds[0]._stddevStatisticalBox.getSelectedIndex();
                    int n6 = DialogConstants.COMBOBOX_STATISTICAL_CONDITION.length - 1 - n5;
                    DefaultThresholdDialog.this._thresholds[1]._stddevStatisticalBox.setSelectedIndex(n6);
                } else if (itemSelectable.equals(DefaultThresholdDialog.this._thresholds[0]._avgStatisticalBox)) {
                    int n7 = DefaultThresholdDialog.this._thresholds[0]._avgStatisticalBox.getSelectedIndex();
                    int n8 = COMBOBOX_AVG.length - 1 - n7;
                    DefaultThresholdDialog.this._thresholds[1]._avgStatisticalBox.setSelectedIndex(n8);
                } else if (itemSelectable.equals(DefaultThresholdDialog.this._thresholds[0]._statMode)) {
                    int n9 = DefaultThresholdDialog.this._thresholds[0]._statMode.getSelectedIndex();
                    DefaultThresholdDialog.this._thresholds[1]._statMode.setSelectedIndex(n9);
                    boolean bl2 = DefaultThresholdDialog.this._thresholds[0]._statMode.getSelectedItem().equals(LABEL_DEV);
                    DefaultThresholdDialog.this.setStddevOrAvgVisible(bl2);
                }
            }
        }
    }

    private class ThresholdPanel {
        private PanelBuilder _builder;
        private JComboBox _fixedStatisticalBox;
        private JLabel _labelSeverity;
        private JComboBox _severityBox;
        private JComboBox _fixedBox;
        private JTextField _fixedThreshold;
        private JComboBox _stddevStatisticalBox;
        private JComboBox _avgStatisticalBox;
        private JTextField _statisticalThreshold;
        private JButton _fixedAdvance;
        private JButton _statAdvance;
        private JTextField _breaks;
        private JLabel _labelPeriod;
        private JComboBox _statMode;
        private JTextField _period;
        private JComboBox _periodBox;
        private JLabel _noThreshold;
        private short _fixedStatisticalId = (short)-1;
        private short _severityId = (short)-1;
        private short _fixedConditionId = (short)-1;
        private String _checkedFixedThreshold;
        private double _checkedStatisticalThreshold;
        private short _checkedBreaks = (short)-1;
        private long _checkedPeriod;

        public ThresholdPanel(String string, boolean bl2) {
            FormLayout formLayout = new FormLayout("p,3dlu,p,3dlu,p,0dlu,p,3dlu,p:g,3dlu,p,5dlu,p", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
            this._builder = new PanelBuilder(formLayout);
            this._builder.setBorder((Border)new TitledBorder(string));
            CellConstraints cellConstraints = new CellConstraints();
            this._fixedStatisticalBox = new JComboBox<String>(DialogConstants.COMBOBOX_FIXED_STATISTICAL);
            this._fixedStatisticalBox.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._fixedStatisticalBox, cellConstraints.xy(1, 1));
            this._labelSeverity = new JLabel(DialogConstants.LABEL_SEVERITY + ":");
            this._labelSeverity.setVisible(false);
            this._builder.add((Component)this._labelSeverity, cellConstraints.xy(11, 1));
            this._severityBox = new JComboBox<String>(ITrapConstants.SEVERITY_STRINGS);
            this._severityBox.setPreferredSize(DialogConstants.LONG_SIZE);
            this._severityBox.setVisible(false);
            this._builder.add((Component)this._severityBox, cellConstraints.xy(13, 1));
            this._builder.addSeparator("", cellConstraints.xyw(1, 3, 13));
            this._builder.addLabel(LABEL_FIXED + ":", cellConstraints.xy(1, 5));
            this._fixedBox = new JComboBox<String>(DialogConstants.COMBOBOX_FIXED_CONDITION);
            this._fixedBox.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._fixedBox, cellConstraints.xyw(5, 5, 3));
            this._fixedThreshold = new JTextField();
            this._fixedThreshold.setToolTipText(ConfirmDialog._bundle.getString("fixed_threshold_tooltip"));
            this._fixedThreshold.setPreferredSize(DialogConstants.SHORT_SIZE);
            this._builder.add((Component)this._fixedThreshold, cellConstraints.xy(9, 5));
            this._builder.addLabel(DefaultThresholdDialog.this._unit, cellConstraints.xy(11, 5));
            this._fixedAdvance = new JButton(DialogConstants.BUTTON_ADVANCED);
            this._fixedAdvance.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._fixedAdvance, cellConstraints.xy(13, 5));
            this._builder.addSeparator("", cellConstraints.xyw(1, 7, 13));
            this._builder.addLabel(LABEL_STATISTICAL + ":", cellConstraints.xy(1, 9));
            this._stddevStatisticalBox = new JComboBox<String>(DialogConstants.COMBOBOX_STATISTICAL_CONDITION);
            this._stddevStatisticalBox.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._stddevStatisticalBox, cellConstraints.xy(5, 9));
            this._avgStatisticalBox = new JComboBox<String>(COMBOBOX_AVG);
            this._avgStatisticalBox.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._avgStatisticalBox, cellConstraints.xy(7, 9));
            this._avgStatisticalBox.setVisible(false);
            this._statisticalThreshold = new JTextField();
            this._statisticalThreshold.setPreferredSize(DialogConstants.LONG_SIZE);
            this._statisticalThreshold.setEnabled(false);
            this._builder.add((Component)this._statisticalThreshold, cellConstraints.xyw(9, 9, 2));
            this._builder.addLabel(LABEL_TIMES, cellConstraints.xy(11, 9));
            this._statMode = new JComboBox<String>(new String[]{LABEL_DEV, LABEL_AVG});
            this._statMode.setToolTipText(ConfirmDialog._bundle.getString("tooltip_statMode"));
            this._statMode.setPreferredSize(DialogConstants.XLONG_SIZE);
            this._statMode.setEnabled(false);
            this._builder.add((Component)this._statMode, cellConstraints.xy(13, 9));
            this._labelPeriod = new JLabel(INTERVAL);
            this._labelPeriod.setVisible(false);
            this._builder.add((Component)this._labelPeriod, cellConstraints.xy(3, 11));
            this._period = new JTextField();
            this._period.setToolTipText(ConfirmDialog._bundle.getString("tooltip_statPeriod"));
            this._period.setPreferredSize(DialogConstants.SHORT_SIZE);
            this._period.setVisible(false);
            this._builder.add((Component)this._period, cellConstraints.xyw(5, 11, 3));
            this._periodBox = new JComboBox<String>(new String[]{DialogConstants.LABEL_MINUTE, DialogConstants.LABEL_HOUR, DialogConstants.LABEL_DAY});
            this._periodBox.setPreferredSize(DialogConstants.OPERATE_SIZE);
            this._periodBox.setSelectedIndex(2);
            this._periodBox.setVisible(false);
            this._builder.add((Component)this._periodBox, cellConstraints.xy(9, 11));
            this._statAdvance = new JButton(DialogConstants.BUTTON_ADVANCED);
            this._statAdvance.setPreferredSize(DialogConstants.LONG_SIZE);
            this._statAdvance.setVisible(false);
            this._builder.add((Component)this._statAdvance, cellConstraints.xy(13, 11));
            this._builder.addSeparator("", cellConstraints.xyw(1, 13, 13));
            if (bl2) {
                this._builder.addLabel(GENERATE_ALARM, cellConstraints.xy(3, 5));
                this._noThreshold = new JLabel(ConfirmDialog._bundle.getString("is_error"));
                this._builder.add((Component)this._noThreshold, cellConstraints.xyw(5, 5, 3));
                this._noThreshold.setVisible(false);
                this._builder.addLabel(GENERATE_ALARM, cellConstraints.xy(3, 9));
                this._builder.addLabel(ARM_BREAKS_1, cellConstraints.xy(1, 15));
                this._builder.addLabel(ARM_BREAKS_2 + ".", cellConstraints.xyw(5, 15, 5));
            } else {
                this._builder.addLabel(GENERATE_REARM, cellConstraints.xy(3, 5));
                this._noThreshold = new JLabel(ConfirmDialog._bundle.getString("is_ok"));
                this._builder.add((Component)this._noThreshold, cellConstraints.xyw(5, 5, 3));
                this._noThreshold.setVisible(false);
                this._builder.addLabel(GENERATE_REARM, cellConstraints.xy(3, 9));
                this._builder.addLabel(REARM_BREAKS_1, cellConstraints.xy(1, 15));
                this._builder.addLabel(REARM_BREAKS_2 + ".", cellConstraints.xyw(5, 15, 5));
            }
            this._breaks = new JTextField("1");
            this._breaks.setToolTipText(ConfirmDialog._bundle.getString("tooltip_breaks"));
            this._breaks.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._breaks, cellConstraints.xy(3, 15));
        }

        public JPanel getPanel() {
            return this._builder.getPanel();
        }
    }

    private class AdvancedAction
    implements ActionListener {
        private AdvancedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(DefaultThresholdDialog.this._thresholds[0]._fixedAdvance)) {
                DialogProvider.createMetricsTimebucketDialog(DefaultThresholdDialog.this, DialogConstants.LABEL_THRESHOLD, DefaultThresholdDialog.this._metricsTimebucketList, DefaultThresholdDialog.this._localeMetrics, DefaultThresholdDialog.this._unit, false);
                DefaultThresholdDialog.this.initRearmAdvanceButton();
            } else if (object.equals(DefaultThresholdDialog.this._thresholds[0]._statAdvance)) {
                DialogProvider.createBaselineDialog(DefaultThresholdDialog.this, (Baseline)DefaultThresholdDialog.this._metrics, DefaultThresholdDialog.this._unit);
            } else if (object.equals(DefaultThresholdDialog.this._thresholds[1]._fixedAdvance)) {
                DialogProvider.createMetricsTimebucketDialog(DefaultThresholdDialog.this, DialogConstants.LABEL_THRESHOLD, DefaultThresholdDialog.this._metricsTimebucketList, DefaultThresholdDialog.this._localeMetrics, DefaultThresholdDialog.this._unit, true);
            }
        }
    }

    private class ChangedDocument
    implements DocumentListener {
        private ChangedDocument() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setThresholdText(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setThresholdText(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setThresholdText(documentEvent);
        }

        private void setThresholdText(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            if (document.equals(DefaultThresholdDialog.this._thresholds[0]._fixedThreshold.getDocument())) {
                DefaultThresholdDialog.this._thresholds[1]._fixedThreshold.setText(DefaultThresholdDialog.this._thresholds[0]._fixedThreshold.getText());
            } else if (document.equals(DefaultThresholdDialog.this._thresholds[0]._statisticalThreshold.getDocument())) {
                DefaultThresholdDialog.this._thresholds[1]._statisticalThreshold.setText(DefaultThresholdDialog.this._thresholds[0]._statisticalThreshold.getText());
            } else if (document.equals(DefaultThresholdDialog.this._thresholds[0]._breaks.getDocument())) {
                DefaultThresholdDialog.this._thresholds[1]._breaks.setText(DefaultThresholdDialog.this._thresholds[0]._breaks.getText());
            }
        }
    }
}

