/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.performance.ExchangeServerHost;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.ComponentElement;
import com.sysuptime.mainframe.performance.RemoteProtocolDialog;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.RMIAdaptor;
import com.sysuptime.server.util.MBeanUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class ExchangeDialog
extends RemoteProtocolDialog {
    private JComboBox _instances;

    public ExchangeDialog(JDialog jDialog, String string, boolean bl2, long l2) {
        super(jDialog, string, bl2, l2);
    }

    @Override
    protected int getRemoteProtocol() {
        return ExchangeServerHost.EXCHANGE_SERVER_ID;
    }

    @Override
    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        if (string.equalsIgnoreCase("instances")) {
            String string2 = Snippet.getBundledString(string);
            JComponent jComponent = this.getParameterComponent(queryParameterElement, string2);
            this.appendInstances(defaultFormBuilder, jComponent, string2);
            return n2;
        }
        super.appendParameterCompenent(defaultFormBuilder, cellConstraints, queryParameterElement, n2);
        return n2;
    }

    private void appendInstances(DefaultFormBuilder defaultFormBuilder, JComponent jComponent, String string) {
        defaultFormBuilder.append(string);
        this._instances = (JComboBox)jComponent;
        defaultFormBuilder.append((Component)this._instances);
        this._instances.addItem("None");
        this._instances.setSelectedIndex(0);
    }

    @Override
    protected void initParameterData(QueryParameter queryParameter) {
        super.initParameterData(queryParameter);
        if (this.getServiceNameElement().getServiceFamily().equals("ExchangeService")) {
            return;
        }
        Object[] objectArray = this.getParameterValue().toArray();
        ComponentElement componentElement = (ComponentElement)objectArray[3];
        if (componentElement.getName().equals("instances")) {
            this._instances.setSelectedItem(queryParameter.get(3).toString());
        }
    }

    @Override
    protected boolean isIgnoredInitPara(ComponentElement componentElement) {
        return componentElement.getName().equals("instances");
    }

    @Override
    protected boolean checkParameter() {
        boolean bl2 = super.checkRemoteHost();
        if (!bl2) {
            this._tmpParameters.clear();
            return false;
        }
        if (this.getServiceNameElement().getServiceFamily().equals("ExchangeService")) {
            return true;
        }
        this._tmpParameters.add(this._instances.getSelectedItem().toString());
        return true;
    }

    @Override
    protected void initBeforeUserData() {
        super.initBeforeUserData();
        if (this.getServiceNameElement().getServiceFamily().equals("ExchangeService")) {
            return;
        }
        this.getComboParaComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Long l2 = ExchangeDialog.this.getRemoteHostId();
                    if (l2 == null) {
                        return;
                    }
                    String string = ExchangeDialog.this.getServiceNameElement().getServiceFamily();
                    ObjectName objectName = MBeanUtil.create("nMaster:service=Exchange");
                    RMIAdaptor rMIAdaptor = JNDIClient.getRMIAdaptor();
                    RmiResponse rmiResponse = (RmiResponse)rMIAdaptor.invoke(objectName, "getInstance", new Object[]{string, l2}, new String[]{"java.lang.String", "java.lang.Long"});
                    if (!rmiResponse.getValue().equals(Boolean.FALSE)) {
                        String string2 = (String)rmiResponse.getValue();
                        ExchangeDialog.this.setInstances(string2);
                    } else {
                        ExchangeDialog.this.setInstances("null");
                        JOptionPane.showMessageDialog(ExchangeDialog.this, "Error: Could not get instances. " + rmiResponse.getErrorMessage());
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(ExchangeDialog.this, "Exception: " + exception.getMessage());
                    ExchangeDialog.this._logger.error((Object)"", (Throwable)exception);
                }
            }
        });
    }

    private ArrayList stringToList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private void setInstances(String string) {
        this._instances.removeAllItems();
        if (string.trim().length() == 0) {
            this._instances.addItem("None");
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(ExchangeDialog.class, (String)"service_state"));
        } else if (string.trim().equalsIgnoreCase("null")) {
            this._instances.addItem("None");
        } else {
            ArrayList arrayList = this.stringToList(string);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                this._instances.addItem(arrayList.get(i2));
            }
        }
        this._instances.setSelectedIndex(0);
    }
}

