/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.openapi.performance.DefaultProtocolDialog;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.msp.Probe;
import com.sysuptime.common.performance.Baseline;
import com.sysuptime.common.performance.ConfigThresholdElement;
import com.sysuptime.common.performance.Group;
import com.sysuptime.common.performance.IProtocolHost;
import com.sysuptime.common.performance.Metrics;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorHost;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.SnapShotTypeData;
import com.sysuptime.common.trapreceiver.AlarmActions;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.schedule.RealSchedule;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ConciseMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DefaultNameRenderer;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.HostHandler;
import com.sysuptime.mainframe.performance.LengthValidator;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.MonitorGraphComponent;
import com.sysuptime.mainframe.performance.MonitorTableModel;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.PositiveLongValidator;
import com.sysuptime.mainframe.performance.ServiceElement;
import com.sysuptime.mainframe.performance.SingletonScheduleBroker;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.SnapShotTypeDialog;
import com.sysuptime.mainframe.performance.TestRunDialog;
import com.sysuptime.mainframe.performance.WithData;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.util.MonitorTypeComboBox;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MonitorDialog
extends OperationDialog {
    private static final Logger _logger = Logger.getLogger((String)MonitorDialog.class.getName());
    private static final int SCHEDULE_LENGTH = 100;
    private static final String MESSAGE_ADD_HOST_FIRST = _bundle.getString("message_addhostfirst");
    private static final String MESSAGE_SAVE_RESULT = _bundle.getString("message_saveresult");
    private static final String LABEL_SCHEDULE_NAME = _bundle.getString("label_schedulename");
    private static final String LABEL_INTERVAL = _bundle.getString("label_interval");
    private static final String LABEL_MODE = _bundle.getString("label_mode");
    private static final String LABEL_FREQUENCY = _bundle.getString("label_frequency");
    private static final String LABEL_MULTIPLE = _bundle.getString("label_multiple");
    private static final String LABEL_DEPENDENCY = _bundle.getString("label_dependency");
    private static final String LABEL_DEPENDENCY_CONDITION = _bundle.getString("label_dependencycondition");
    private static final String LABEL_NEW_GROUP = _bundle.getString("label_newgroup");
    private static final String LABEL_SNAPSHOT = _bundle.getString("label_snapshot");
    private static final String MESSAGE_PUT_SCHEDULE = _bundle.getString("message_putschedule");
    private static final String MESSAGE_MULTIPLE = _bundle.getString("message_invalidmultiple");
    private static final String MESSAGE_MODIFY_SCHEDULE = _bundle.getString("message_modifyschedule1") + "\n" + _bundle.getString("message_modifyschedule2");
    private static final String MESSAGE_RESTART_GRAPH = _bundle.getString("message_restartgraph");
    private static final String CONDITION_OK = _bundle.getString("condition_ok");
    private static final String CONDITION_ERROR = ICommonBundle.ERROR;
    private static final String CONDITION_NONE = _bundle.getString("condition_none");
    private static final String[] COMBOBOX_CONDITION = new String[]{CONDITION_OK, CONDITION_ERROR};
    private static final String LABEL_MONITOR_TYPE = _bundle.getString("label_monitor_type");
    private int _monitorType = 0;
    protected JTextField _hostField;
    protected HostHandler _hostHandler;
    protected WithData _hostData;
    protected JTextField _scheduleName;
    protected JTextField _period;
    protected SpinnerNumberModel _multipleModel;
    protected JComboBox _periodBox;
    protected JCheckBox _isSavedBox;
    protected JButton _advance;
    protected JButton _configSnapshot;
    protected JButton _configMetrics;
    protected JButton _actionsBtn;
    protected JButton _isTestRunBox;
    protected MonitorTableModel _scheduleListModel;
    protected int _nonComparedIndex;
    protected JComboBox _dependencyBox;
    protected JLabel _conditionLabel;
    protected JComboBox _dependencyConditionBox;
    protected DefaultComboBoxModel _groupModel;
    protected JComboBox _groupBox;
    private MonitorTypeComboBox _monitorTypeBox = new MonitorTypeComboBox();
    private Monitor _schedule;
    private ServiceNameElement _serviceNameElement;
    private String _firstMetricsName;
    private String _checkedScheduleName;
    private long _checkedPeriod;
    private boolean _isDisableHost;
    private boolean _isSingleHost;
    private boolean _isLocalSingleHost;
    private Map _scheduleNameToId;
    private Map _groupNameToId;
    private int _preGroup;
    private ReadCommunity _community;
    private SnapShotTypeData _snapData = new SnapShotTypeData();
    private DefaultComboBoxModel _snapshotModel;
    private List<MonitorHost> _oldHosts;
    private List _oldBaselines;
    private long _oldInterval;
    private boolean _isUserSetStartTime;
    private DefaultProtocolDialog _protocolDialog;
    private List _checkedHosts = new ArrayList();

    public MonitorDialog(JDialog jDialog, String string, boolean bl2, ServiceNameElement serviceNameElement, MonitorTableModel monitorTableModel, int n2, Monitor monitor) {
        super(jDialog, string, bl2);
        this.initMonitor(serviceNameElement, monitorTableModel, n2, monitor);
    }

    public MonitorDialog(Frame frame, String string, boolean bl2, ServiceNameElement serviceNameElement, MonitorTableModel monitorTableModel, int n2, Monitor monitor) {
        super(frame, string, bl2);
        this.initMonitor(serviceNameElement, monitorTableModel, n2, monitor);
    }

    public MonitorDialog(String string, ServiceNameElement serviceNameElement, Monitor monitor, String string2, ReadCommunity readCommunity) {
        super(Startup.getFrame(), string, true);
        this.initMonitor(serviceNameElement, null, -1, monitor);
        this.initGraphMonitor(string2, readCommunity);
    }

    private void initMonitor(ServiceNameElement serviceNameElement, MonitorTableModel monitorTableModel, int n2, Monitor monitor) {
        this.initSchedule(serviceNameElement, monitorTableModel, n2, monitor);
        this.initComponent();
        this.initUserData();
        this.addListeners();
        this.initTemplateData();
    }

    private void initGraphMonitor(String string, ReadCommunity readCommunity) {
        if (!this._isLocalSingleHost) {
            this._hostField.setText(string);
        }
        this._community = readCommunity;
    }

    private void initTemplateData() {
        if (!this.isAdded()) {
            return;
        }
        List list = MonitorHelper.getConfigs(this._serviceNameElement, this._firstMetricsName);
        if (MonitorHelper.isThresholdConfigOptional(this._serviceNameElement)) {
            Object object;
            ConfigThresholdElement configThresholdElement = (ConfigThresholdElement)list.get(0);
            int n2 = MonitorHelper.getConstantId(configThresholdElement.getName());
            try {
                object = MonitorHelper.getService(this._serviceNameElement);
                String string = ((ServiceElement)object).getAttributeValue("defaultThreshold");
                ConciseMonitorSecondDialog.setFixedThreshold(this._schedule, string, n2, (short)1, (short)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = PerformanceUIUtil.getTemplateProtocolParameter(this._serviceNameElement, this._firstMetricsName);
            this._schedule.setQueryParameters((QueryParameter)object);
        }
    }

    public ReadCommunity getCommunity() {
        return this._community;
    }

    private void initSchedule(ServiceNameElement serviceNameElement, MonitorTableModel monitorTableModel, int n2, Monitor monitor) {
        this._serviceNameElement = serviceNameElement;
        this._nonComparedIndex = n2;
        this._scheduleListModel = monitorTableModel;
        this._schedule = monitor;
        this._isDisableHost = MonitorHelper.isDisableHost(this._serviceNameElement);
        this._isSingleHost = MonitorHelper.isSingleHost(this._serviceNameElement);
        this._firstMetricsName = MonitorHelper.getFirstMetricsName(this._serviceNameElement);
        this.initScheduleNameToId();
        this.initGroupNameToId();
    }

    private boolean isAdded() {
        return this._nonComparedIndex == -1;
    }

    private long getProbeID() {
        if (this.isAdded()) {
            return ClientProxy.getInstance().getProbe().getId();
        }
        return Probe.getProbeID(this._schedule.getScheduleId());
    }

    private void initScheduleNameToId() {
        int n2;
        this._scheduleNameToId = MonitorBroker.getScheduleNameToIdFromProbe((int)this.getProbeID());
        if (this._schedule.getScheduleName() != null) {
            this._scheduleNameToId.remove(this._schedule.getScheduleName());
        }
        if ((n2 = this._schedule.getScheduleId()) > 0) {
            List list = MonitorBroker.getInverseDependencies(n2);
            int n3 = list.size();
            Iterator iterator = this._scheduleNameToId.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (!list.get(i2).equals(entry.getValue())) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void initGroupNameToId() {
        this._groupNameToId = MonitorBroker.getGroupNameToId();
    }

    private void initComponent() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    protected JPanel getBodyPanel() {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        String string;
        FormLayout formLayout = new FormLayout("p,3dlu,230px,3dlu,p,3dlu,p:g,3dlu,p", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel(DialogConstants.LABEL_HOST);
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 1));
        this._hostField = new JTextField();
        ServiceElement serviceElement = MonitorHelper.getService(this._serviceNameElement);
        String string2 = serviceElement.getDefaultHost();
        if (string2 != null) {
            this._hostField.setText(string2);
        }
        if ((string = serviceElement.getAttributeValue("hostLabel")) != null) {
            jLabel.setText(string);
        }
        this._isLocalSingleHost = MonitorHelper.isLocalSingleHost(this._serviceNameElement);
        if (this._isDisableHost || this._isLocalSingleHost) {
            jLabel.setVisible(false);
            this._hostField.setVisible(false);
        } else {
            this._hostField.setToolTipText(this._isSingleHost ? _bundle.getString("tooltip_singleHost") : _bundle.getString("tooltip_multiHosts"));
        }
        this._hostField.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._hostField, cellConstraints.xy(3, 1));
        JButton jButton = new JButton("More...");
        jButton.setVisible(false);
        panelBuilder.add((Component)jButton, cellConstraints.xy(5, 1));
        String string3 = serviceElement.getAttributeValue("hostMore");
        if (string3 != null) {
            object3 = null;
            try {
                serializable = Class.forName(string3);
                object2 = ((Class)serializable).newInstance();
                object3 = (ActionListener)object2;
                this._hostData = (WithData)object2;
                jButton.addActionListener((ActionListener)object3);
                object = (WithData)object3;
                short s2 = MonitorHelper.getProtocolType(this._serviceNameElement, this._firstMetricsName);
                object.setData(new Object[]{this, this._hostField, this._schedule, s2});
                jButton.setVisible(true);
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
            }
        }
        if ((object3 = serviceElement.getAttributeValue("hostHandler")) != null) {
            try {
                serializable = Class.forName((String)object3);
                this._hostHandler = (HostHandler)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
            }
        }
        panelBuilder.addLabel(LABEL_SCHEDULE_NAME, cellConstraints.xy(1, 3));
        this._scheduleName = new JTextField();
        this._scheduleName.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._scheduleName, cellConstraints.xy(3, 3));
        panelBuilder.addLabel(LABEL_INTERVAL, cellConstraints.xy(1, 5));
        this._period = new JTextField("5");
        this._period.setToolTipText(_bundle.getString("tooltip_period"));
        this._period.setPreferredSize(DialogConstants.SHORT_SIZE);
        panelBuilder.add((Component)this._period, cellConstraints.xy(3, 5));
        this._periodBox = new JComboBox<String>(DialogConstants.COMBOBOX_UNIT);
        this._periodBox.setSelectedIndex(1);
        this._periodBox.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        panelBuilder.add((Component)this._periodBox, cellConstraints.xy(5, 5));
        panelBuilder.addLabel(LABEL_FREQUENCY, cellConstraints.xy(1, 7));
        this._multipleModel = new SpinnerNumberModel(1, 1, 10, 1);
        serializable = new JSpinner(this._multipleModel);
        ((JSpinner.DefaultEditor)((JSpinner)serializable).getEditor()).getTextField().setEditable(false);
        panelBuilder.add((Component)serializable, cellConstraints.xy(3, 7));
        panelBuilder.addLabel(LABEL_MULTIPLE, cellConstraints.xyw(5, 7, 5));
        object2 = new MonitorAction();
        panelBuilder.addLabel(DialogConstants.LABEL_METRICS, cellConstraints.xy(1, 9));
        this._configMetrics = new JButton(DialogConstants.BUTTON_CONFIGURE);
        this._configMetrics.addActionListener((ActionListener)object2);
        panelBuilder.add((Component)this._configMetrics, cellConstraints.xy(3, 9));
        this._actionsBtn = new JButton(DialogConstants.BUTTON_CONFIGURE);
        panelBuilder.addLabel(_bundle.getString("MonitorDialog_label_actions"), cellConstraints.xy(1, 11));
        this._actionsBtn.addActionListener((ActionListener)object2);
        panelBuilder.add((Component)this._actionsBtn, cellConstraints.xy(3, 11));
        panelBuilder.addLabel(LABEL_DEPENDENCY, cellConstraints.xy(1, 13));
        object = new ArrayList();
        object.add(CONDITION_NONE);
        Set set = this._scheduleNameToId.keySet();
        ArrayList arrayList = new ArrayList(set.size());
        arrayList.addAll(set);
        CommonUtil.sortIgnoreCase(arrayList);
        object.addAll(arrayList);
        this._dependencyBox = new JComboBox<Object>(object.toArray());
        this._dependencyBox.setToolTipText(_bundle.getString("tooltip_dependency"));
        this._dependencyBox.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._dependencyBox, cellConstraints.xy(3, 13));
        this._conditionLabel = new JLabel(LABEL_DEPENDENCY_CONDITION);
        String string4 = _bundle.getString("depend_condition_tooltip");
        this._conditionLabel.setToolTipText(string4);
        panelBuilder.add((Component)this._conditionLabel, cellConstraints.xyw(5, 13, 3));
        this._dependencyConditionBox = new JComboBox<String>(COMBOBOX_CONDITION);
        this._dependencyConditionBox.setToolTipText(string4);
        this._dependencyConditionBox.setPreferredSize(DialogConstants.OPERATE_SIZE);
        panelBuilder.add((Component)this._dependencyConditionBox, cellConstraints.xy(9, 13));
        this._conditionLabel.setVisible(false);
        this._dependencyConditionBox.setVisible(false);
        panelBuilder.addLabel(DialogConstants.LABEL_GROUP, cellConstraints.xy(1, 15));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("Default");
        this._groupNameToId.remove("Default");
        arrayList2.addAll(this._groupNameToId.keySet());
        arrayList2.add(LABEL_NEW_GROUP);
        this._groupNameToId.put("Default", -1L);
        this._groupModel = new DefaultComboBoxModel<Object>(arrayList2.toArray());
        this._groupBox = new JComboBox(this._groupModel);
        this._groupBox.setToolTipText(_bundle.getString("tooltip_group"));
        this._groupBox.setRenderer(new DefaultNameRenderer("Default"));
        this._groupBox.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._groupBox, cellConstraints.xy(3, 15));
        this._isSavedBox = new JCheckBox(LABEL_MODE, true);
        this._isSavedBox.setToolTipText(_bundle.getString("tooltip_isSaved"));
        panelBuilder.add((Component)this._isSavedBox, cellConstraints.xyw(1, 21, 3));
        this._isTestRunBox = new JButton(DialogConstants.BUTTON_TEST_RUN);
        this._isTestRunBox.setToolTipText(_bundle.getString("tooltip_isTestrun"));
        this._isTestRunBox.addActionListener(actionEvent -> this.testRun());
        panelBuilder.add((Component)this._isTestRunBox, cellConstraints.xy(5, 21));
        this._advance = new JButton(DialogConstants.BUTTON_ADVANCED);
        this._advance.addActionListener((ActionListener)object2);
        panelBuilder.add((Component)this._advance, cellConstraints.xy(7, 21));
        return panelBuilder.getPanel();
    }

    private void initSnapshotModel() {
        if (MonitorHelper.isPercentage(this._serviceNameElement)) {
            this._snapData.setChartType((short)0);
            this._snapData.setTimeType((short)0);
            this._snapData.setMax(100);
        }
        String string = this._snapData.toString();
        this._snapshotModel.removeAllElements();
        this._snapshotModel.addElement(string);
        this._snapshotModel.setSelectedItem(string);
    }

    private void initUserData() {
        Object object;
        QueryParameter queryParameter = this._schedule.getQueryParameters();
        if (this._hostData != null) {
            object = this._hostData.getHost();
            if (object != null && ((String)object).length() > 0) {
                this._hostField.setText(this._hostData.getHost());
            }
        } else if (this._schedule.getScheduleHostListSize() > 0 && !this._isLocalSingleHost) {
            this.initScheduleHost();
        }
        if (!this.isAdded()) {
            Object object2;
            this._scheduleName.setText(this._schedule.getScheduleName());
            this.initPeriod();
            this._multipleModel.setValue(this._schedule.getMultiple());
            this._isSavedBox.setSelected(this._schedule.isSaved());
            object = this.getDependencyName(this._schedule.getDirectDependency());
            if (object != null) {
                this.setDependencyConditionPanel(true);
                this._dependencyBox.setSelectedItem(object);
                int n2 = this._schedule.isConditionOk() ? 0 : 1;
                this._dependencyConditionBox.setSelectedIndex(n2);
            }
            if ((object2 = this.getGroupName(this._schedule.getGroupId())) != null) {
                this._groupBox.setSelectedItem(object2);
                this._preGroup = this._groupBox.getSelectedIndex();
            }
            this._monitorTypeBox.selectMonitorType(this._schedule.getMonitorType());
            if (this._schedule.getMonitorType() == 1000000 || this._schedule.getMonitorType() == 2000000) {
                this._monitorType = this._schedule.getMonitorType();
                this._monitorTypeBox.setEnabled(false);
                this._scheduleName.setEnabled(false);
            }
            this.initUserSnapshot();
            this.initOldData();
        } else {
            this._schedule.setStartDateTime(System.currentTimeMillis());
        }
    }

    private void initOldData() {
        int n2;
        this._oldBaselines = new ArrayList(this._schedule.getMetricsListSize());
        int n3 = this._schedule.getMetricsListSize();
        for (n2 = 0; n2 < n3; ++n2) {
            Metrics metrics = this._schedule.getMetrics(n2);
            this._oldBaselines.add(metrics);
        }
        this._oldInterval = this._schedule.getPeriod();
        this._oldHosts = new ArrayList<MonitorHost>(this._schedule.getScheduleHostListSize());
        try {
            n3 = this._schedule.getScheduleHostListSize();
            for (n2 = 0; n2 < n3; ++n2) {
                this._oldHosts.add((MonitorHost)this._schedule.getScheduleHost(n2).clone());
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private Object getDependencyName(int n2) {
        for (Map.Entry entry : this._scheduleNameToId.entrySet()) {
            Map.Entry entry2 = entry;
            if (n2 != Integer.parseInt(entry2.getValue().toString())) continue;
            return entry2.getKey();
        }
        return null;
    }

    private Object getGroupName(long l2) {
        for (Map.Entry entry : this._groupNameToId.entrySet()) {
            Map.Entry entry2 = entry;
            if (l2 != Long.parseLong(entry2.getValue().toString())) continue;
            return entry2.getKey();
        }
        return null;
    }

    private void initPeriod() {
        short s2 = this._schedule.getUnit();
        this._periodBox.setSelectedIndex(s2);
        long l2 = this._schedule.getPeriod() / 1000L;
        if (s2 == 3) {
            l2 /= 86400L;
        } else if (s2 == 2) {
            l2 /= 3600L;
        } else if (s2 == 1) {
            l2 /= 60L;
        }
        this._period.setText(String.valueOf(l2));
    }

    private void initScheduleHost() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this._schedule.getScheduleHostListSize() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this._schedule.getScheduleHost(i2).getIpAddress()).append(", ");
        }
        if (n2 >= 0) {
            stringBuffer.append(this._schedule.getScheduleHost(n2).getIpAddress());
        }
        this._hostField.setText(stringBuffer.toString());
    }

    private void initUserSnapshot() {
        this._snapData.setTimeType(this._schedule.getChartTimeType());
        this._snapData.setChartType(this._schedule.getChartType());
        this._snapData.setParameters(this._schedule.getChartParameters());
    }

    private void addListeners() {
        ProtocolItem protocolItem = new ProtocolItem();
        this._dependencyBox.addItemListener(protocolItem);
        this._groupBox.addItemListener(protocolItem);
    }

    private void modifyProtocol() throws Exception {
        short s2 = MonitorHelper.getProtocolType(this._serviceNameElement, this._firstMetricsName);
        long l2 = this.getProbeID();
        this._protocolDialog = DialogProvider.createProtocolDialog(this, DialogConstants.BUTTON_MODIFY, s2, l2);
        if (this._protocolDialog.isAddHostFirst()) {
            if (this.getHosts().length == 0) {
                JOptionPane.showMessageDialog(this, MESSAGE_ADD_HOST_FIRST);
                return;
            }
            this._protocolDialog.setProbeID(l2);
        }
        this.showProtocolDialog(this._schedule, s2, this._serviceNameElement, this._firstMetricsName);
    }

    private void modifyAlarmActions() {
        AlarmActions alarmActions = null;
        try {
            alarmActions = AlarmActions.fromXML(this._schedule.getActions(), MonitorBroker.getID2TimebucketMap());
        }
        catch (Exception exception) {
            _logger.error((Object)"modify alarm actions", (Throwable)exception);
        }
        AlarmActionsDialog alarmActionsDialog = new AlarmActionsDialog(this, _bundle.getString("title_alarm_actions"), true, alarmActions, false, this.getProbeID());
        alarmActionsDialog.pack();
        alarmActionsDialog.showCenterOnOwner();
        if (alarmActionsDialog.isOK()) {
            alarmActions = alarmActionsDialog.getAlarmActions();
            this._schedule.setActions(alarmActions.toXML());
        }
    }

    private void showProtocolDialog(Monitor monitor, short s2, ServiceNameElement serviceNameElement, String string) throws Exception {
        this._protocolDialog.initProtocol(monitor, s2, serviceNameElement, string);
        SwingUtil.centerOnFrame(Startup.getFrame(), this._protocolDialog);
        this._protocolDialog.setVisible(true);
    }

    private void addGroup() {
        String string = JOptionPane.showInputDialog(this, (Object)DialogConstants.MESSAGE_ADD_GROUP);
        if (string != null && string.length() != 0) {
            if (this.isLapped(string)) {
                JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NAME_LAP);
                return;
            }
            long l2 = SingletonScheduleBroker.storeGroup(string);
            if (l2 == -1L) {
                JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NAME_LAP);
                return;
            }
            try {
                ClientProxy.getInstance().storeGroup(new Group(l2, string));
            }
            catch (Exception exception) {
                _logger.error((Object)"store group", (Throwable)exception);
            }
            int n2 = this._groupModel.getSize() - 1;
            this._groupModel.insertElementAt(string, n2);
            this._groupBox.setSelectedIndex(n2);
            this._preGroup = n2;
            this._groupNameToId.put(string, l2);
            if (this._scheduleListModel != null) {
                this._scheduleListModel.addGroupId2Name(l2, string);
            }
        } else {
            this._groupBox.setSelectedIndex(this._preGroup);
        }
    }

    private boolean isLapped(String string) {
        int n2 = this._groupModel.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase(this._groupModel.getElementAt(i2).toString())) continue;
            return true;
        }
        return false;
    }

    private void setDependencyConditionPanel(boolean bl2) {
        this._conditionLabel.setVisible(bl2);
        this._dependencyConditionBox.setVisible(bl2);
        this.setSize(this.getPreferredSize());
    }

    private void performSnapshot() {
        SnapShotTypeDialog snapShotTypeDialog = new SnapShotTypeDialog(this, this._snapData);
        SwingUtil.centerOnFrame(this, snapShotTypeDialog);
        snapShotTypeDialog.setVisible(true);
        this._snapshotModel.removeAllElements();
        this._snapshotModel.addElement(this._snapData.toString());
        this._snapshotModel.setSelectedItem(this._snapData.toString());
    }

    public String getHost() {
        if (!this._isSingleHost) {
            String[] stringArray = this.getHosts();
            return stringArray.length == 0 ? "" : stringArray[0];
        }
        return this._hostField.getText().trim();
    }

    private void testRun() {
        if (!this.checkSchedule()) {
            return;
        }
        this.setSchedule();
        this.setEnabledButtons(false);
        TestRunDialog testRunDialog = DialogProvider.createTestRunDialog();
        testRunDialog.splashProgress((JDialog)this, this._schedule);
        this.setEnabledButtons(true);
        if (testRunDialog.isError()) {
            int n2 = testRunDialog.showNewScheduleErrorDialog(this);
            if (n2 == 2 || n2 == -1) {
                this.dispose();
                return;
            }
            if (n2 == 0) {
                this._ok.setEnabled(true);
                return;
            }
        } else {
            testRunDialog.showTestRunResultDialog(this);
        }
    }

    @Override
    protected void okDialog() {
        long l2 = this.getProbeID();
        if (!ClientProxy.getInstance().isActive(l2)) {
            return;
        }
        this._ok.setEnabled(false);
        if (!this.checkSchedule()) {
            this._ok.setEnabled(true);
            return;
        }
        if (MonitorBroker.isExceedLicense(this._isDisableHost ? 1 : this.getHosts().length)) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_EXCEED);
            this._ok.setEnabled(true);
            return;
        }
        this.setSchedule();
        boolean bl2 = this.putSchedule();
        this.showGraphMessage();
        if (bl2) {
            this.dispose();
        } else {
            this._ok.setEnabled(true);
        }
    }

    private void setEnabledButtons(boolean bl2) {
        this.getOkButton().setEnabled(bl2);
        this.getCancelButton().setEnabled(bl2);
    }

    private void showGraphMessage() {
        if (!this.isAdded() && MonitorGraphComponent.opened(this._schedule.getScheduleId())) {
            JOptionPane.showMessageDialog(this, MESSAGE_RESTART_GRAPH);
        }
    }

    protected boolean putSchedule() {
        int n2 = -1;
        String string = null;
        boolean bl2 = false;
        if (!this.isAdded()) {
            if (!this._schedule.isFixed() && this._schedule.getPeriod() != this._oldInterval || !this._schedule.remainBaselines(this._oldBaselines)) {
                this.resetStartTime();
                int n3 = JOptionPane.showOptionDialog(this, MESSAGE_MODIFY_SCHEDULE, "", 0, 2, null, DialogConstants.YES_NO_OPTION, DialogConstants.YES_NO_OPTION[1]);
                if (n3 != 0) {
                    return false;
                }
                try {
                    bl2 = ClientProxy.getInstance().modifyMonitorAndRemoveResults(this._schedule);
                }
                catch (Exception exception) {
                    _logger.error((Object)"modify monitor and remove results", (Throwable)exception);
                }
            } else {
                RmiResponse rmiResponse = null;
                try {
                    rmiResponse = ClientProxy.getInstance().modifyMonitor(this._schedule);
                }
                catch (Exception exception) {
                    _logger.error((Object)"modify monitor", (Throwable)exception);
                }
                if (rmiResponse instanceof RmiResponse) {
                    RmiResponse rmiResponse2 = rmiResponse;
                    if (rmiResponse2.getErrorMessage() == null) {
                        this._schedule = (Monitor)rmiResponse2.getValue();
                        bl2 = true;
                    } else {
                        string = rmiResponse2.getErrorMessage();
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
            }
            if (bl2) {
                n2 = this._schedule.getScheduleId();
            }
        } else {
            Monitor monitor = null;
            try {
                monitor = ClientProxy.getInstance().addMonitor(this._schedule);
                bl2 = true;
            }
            catch (Exception exception) {
                _logger.error((Object)"add monitor", (Throwable)exception);
            }
            n2 = monitor.getScheduleId();
        }
        if (n2 == -1) {
            if (string == null) {
                JOptionPane.showMessageDialog(this, MESSAGE_PUT_SCHEDULE);
            } else {
                JOptionPane.showMessageDialog(this, string);
            }
            return false;
        }
        bl2 = true;
        this._schedule.setScheduleId(n2);
        this.operateSchedule();
        return bl2;
    }

    private void resetStartTime() {
        if (!this._isUserSetStartTime) {
            this._schedule.setStartDateTime(System.currentTimeMillis());
        }
    }

    private HostStatus checkSingleHost(String string) {
        if (string.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_nullhost"));
            return new HostStatus(false, null);
        }
        String string2 = StringUtil.checkIpAddress(string);
        if (string2 == null) {
            JOptionPane.showMessageDialog(this, string + ": " + DialogConstants.MESSAGE_INVALID_HOST);
            return new HostStatus(false, null);
        }
        return new HostStatus(true, string2);
    }

    private boolean checkSchedule() {
        Object object;
        this._checkedHosts.clear();
        if (!this._isDisableHost) {
            object = this.getHosts();
            if (object == null || ((String[])object).length == 0) {
                JOptionPane.showMessageDialog(this, _bundle.getString("message_nullhost"));
                return false;
            }
            if (!this._isSingleHost) {
                int n2 = ((String[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    HostStatus hostStatus = this.checkSingleHost(object[i2]);
                    if (!hostStatus._isok) {
                        return false;
                    }
                    this._checkedHosts.add(hostStatus._host);
                }
            } else {
                if (((String[])object).length > 1) {
                    JOptionPane.showMessageDialog(this, _bundle.getString("message_singlehost"));
                    return false;
                }
                HostStatus hostStatus = this.checkSingleHost(object[0]);
                if (!hostStatus._isok) {
                    return false;
                }
                this._checkedHosts.add(hostStatus._host);
            }
        }
        if ((object = (String)SingletonValidator.checkAllDialog(this, LABEL_SCHEDULE_NAME, this._scheduleName.getText(), LengthValidator.CLASS, 100)) == null) {
            return false;
        }
        Long l2 = (Long)SingletonValidator.checkAllDialog(this, LABEL_INTERVAL, this._period.getText(), PositiveLongValidator.CLASS);
        if (l2 == null) {
            return false;
        }
        if (this._schedule.getMetricsListSize() == 0) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_METRICS);
            return false;
        }
        this._checkedScheduleName = object;
        if (this.monitorExists()) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NAME_LAP);
            return false;
        }
        if (!this.checkPeriod(l2)) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_PERIOD);
            return false;
        }
        if (!this.checkMultiple()) {
            JOptionPane.showMessageDialog(this, MESSAGE_MULTIPLE);
            return false;
        }
        if (!this._isSavedBox.isSelected() && this.isExistedStatistical()) {
            JOptionPane.showMessageDialog(this, MESSAGE_SAVE_RESULT);
            return false;
        }
        return true;
    }

    private boolean isExistedStatistical() {
        int n2 = this._schedule.getMetricsListSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Metrics metrics = this._schedule.getMetrics(i2);
            if (metrics.getFixedStatisticalId() == 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkPeriod(long l2) {
        long l3 = l2 * 1000L;
        int n2 = this._periodBox.getSelectedIndex();
        if (n2 == 1) {
            l3 *= 60L;
        } else if (n2 == 2) {
            l3 *= 3600L;
        } else if (n2 == 3) {
            l3 *= 86400L;
        }
        if (!this.isMultiple(l3)) {
            return false;
        }
        this._checkedPeriod = l3;
        return true;
    }

    private boolean checkMultiple() {
        int n2 = this._multipleModel.getNumber().intValue();
        return this._checkedPeriod % (long)n2 == 0L;
    }

    private boolean isMultiple(long l2) {
        int n2 = this._schedule.getMetricsListSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            Baseline baseline;
            Metrics metrics = this._schedule.getMetrics(i2);
            if (!(metrics instanceof Baseline) || (baseline = (Baseline)metrics).getStatThresholdListSize() <= 0 || l2 <= (l3 = baseline.getPeriod()) && l3 % l2 == 0L) continue;
            return false;
        }
        return true;
    }

    private boolean monitorExists() {
        Object object;
        if (!this.isAdded()) {
            if (this._scheduleListModel == null) {
                return false;
            }
            object = this._scheduleListModel.getMonitor(this._nonComparedIndex);
            String string = ((RealSchedule)object).getScheduleName();
            if (this._checkedScheduleName.equalsIgnoreCase(string)) {
                return false;
            }
        }
        object = MonitorBroker.getScheduleNameList(this.getProbeID());
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = object.get(i2).toString();
            if (!this._checkedScheduleName.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void setSchedule() {
        short s2;
        if (this._hostHandler != null) {
            s2 = MonitorHelper.getProtocolType(this._serviceNameElement, this._firstMetricsName);
            this._hostHandler.setSchedule(this._schedule, this._hostField, s2);
        }
        this._schedule.setScheduleName(this._checkedScheduleName);
        this._schedule.setMonitorType(this._monitorTypeBox.isEnabled() ? this._monitorTypeBox.getMonitorType() : this._monitorType);
        this._schedule.setPeriod(this._checkedPeriod);
        this._schedule.setUnit((short)this._periodBox.getSelectedIndex());
        if (this.isAdded()) {
            this._schedule.setSuspended(false);
        }
        this._schedule.setMultiple((short)this._multipleModel.getNumber().intValue());
        s2 = MonitorHelper.getProtocolType(this._serviceNameElement, this._firstMetricsName);
        this.setProtocol(s2);
        this.setDefaultTimebucketList();
        this.setAllHosts(s2);
        this.setDependency();
        this.setGroup();
        this.setSnapshot();
        if (this._schedule.getEndDateTime() == 0L || this._schedule.getEndDateTime() > System.currentTimeMillis()) {
            this._schedule.setExpired(false);
        } else {
            this._schedule.setExpired(true);
        }
    }

    private void setProtocol(short s2) {
        this._schedule.setProtocolType(s2);
        this._schedule.setSaved(this._isSavedBox.isSelected());
        this._schedule.setTargetType(this._serviceNameElement);
    }

    private void setDefaultTimebucketList() {
        long l2 = this._schedule.getTimebucketId();
        if (l2 == -1L) {
            this._schedule.setTimebucketId(MonitorBroker.getWeekDayId());
        }
    }

    private void setAllHosts(short s2) {
        this._schedule.removeAllHosts();
        if (this._isDisableHost) {
            if (this._protocolDialog != null && this._protocolDialog.isPut()) {
                try {
                    IProtocolHost iProtocolHost = MonitorHelper.getDisableHostClass(s2);
                    this._schedule.addScheduleHost(iProtocolHost.getHost(this._schedule.getQueryParameters(), this.getProbeID()));
                }
                catch (Exception exception) {
                    _logger.error((Object)exception);
                    this._schedule.addScheduleHost("localhost");
                }
            } else {
                this._schedule.addScheduleHost(this._hostField.getText());
            }
        } else {
            int n2 = this._checkedHosts.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = (String)this._checkedHosts.get(i2);
                if (this._hostHandler != null) {
                    string = this._hostHandler.processHost(string);
                }
                this._schedule.addScheduleHost(string);
            }
        }
    }

    private String[] getHosts() {
        return StringUtil.split2(this._hostField.getText().trim(), " ;,");
    }

    private void setDependency() {
        Number number = (Number)this._scheduleNameToId.get(this._dependencyBox.getSelectedItem());
        if (number != null) {
            this._schedule.setDirectDependency(number.intValue());
            boolean bl2 = this._dependencyConditionBox.getSelectedIndex() == 0;
            this._schedule.setConditionOk(bl2);
        } else {
            this._schedule.setDirectDependency(-1);
        }
    }

    private void setGroup() {
        long l2 = ((Number)this._groupNameToId.get(this._groupBox.getSelectedItem())).longValue();
        this._schedule.setGroupId(l2);
    }

    private void setSnapshot() {
        this._schedule.setChartTimeType(this._snapData.getTimeType());
        this._schedule.setChartType(this._snapData.getChartType());
        this._schedule.setChartParameters(this._snapData.getParameters());
    }

    private void operateSchedule() {
        if (this._scheduleListModel != null) {
            if (!this.isAdded()) {
                this._scheduleListModel.setMonitor(this._nonComparedIndex, this._schedule);
            } else {
                this._scheduleListModel.addMonitor(this._schedule);
            }
        }
    }

    private class MonitorAction
    implements ActionListener {
        private MonitorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(MonitorDialog.this._advance)) {
                MonitorDialog.this._isUserSetStartTime = DialogProvider.createScheduleAdvanceDialog(MonitorDialog.this, DialogConstants.BUTTON_ADVANCED, MonitorDialog.this._schedule);
            } else if (object.equals(MonitorDialog.this._configMetrics)) {
                try {
                    MonitorDialog.this.modifyProtocol();
                }
                catch (Exception exception) {
                    _logger.error((Object)"Can't find protocolDialog in the protocolDialog.xml ", (Throwable)exception);
                }
            } else if (object.equals(MonitorDialog.this._configSnapshot)) {
                MonitorDialog.this.performSnapshot();
            } else if (object.equals(MonitorDialog.this._actionsBtn)) {
                MonitorDialog.this.modifyAlarmActions();
            }
        }
    }

    private class ProtocolItem
    implements ItemListener {
        private ProtocolItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1) {
                if (itemSelectable.equals(MonitorDialog.this._dependencyBox)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (MonitorDialog.this._dependencyBox.getSelectedIndex() != 0) {
                                    MonitorDialog.this.setDependencyConditionPanel(true);
                                } else {
                                    MonitorDialog.this.setDependencyConditionPanel(false);
                                }
                            }
                            catch (Exception exception) {
                                _logger.error((Object)exception);
                            }
                        }
                    });
                } else if (itemSelectable.equals(MonitorDialog.this._groupBox)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n2 = MonitorDialog.this._groupBox.getSelectedIndex();
                            if (n2 != MonitorDialog.this._groupModel.getSize() - 1) {
                                MonitorDialog.this._preGroup = n2;
                                return;
                            }
                            try {
                                MonitorDialog.this.addGroup();
                            }
                            catch (Exception exception) {
                                _logger.error((Object)exception);
                            }
                        }
                    });
                }
            }
        }
    }

    private class HostStatus {
        boolean _isok;
        String _host;

        public HostStatus(boolean bl2, String string) {
            this._isok = bl2;
            this._host = string;
        }
    }
}

