/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.SnapShotTypeData;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class SnapShotTypeDialog
extends JDialog {
    private static final String CURRENTVALUE = "current_value";
    private static final String TIMESPAN = "time_span";
    private static final String TABLECHART = "table";
    private static final String PIECHART = "pie_chart";
    private static final String METERCHART = "meter_chart";
    private static final String LINECHART = "line_chart";
    private static final ResourceBundle _bundle = NbBundle.getBundle(SnapShotTypeDialog.class);
    private final JLabel _cmaxLabel = new JLabel(_bundle.getString("snapshottypedialog_max"));
    private final JLabel _timeSpanLabel = new JLabel(_bundle.getString("snapshottypedialog_timespan"));
    private final JLabel _tagLabel = new JLabel(_bundle.getString("snapshottypedialog_ytag"));
    private final JLabel _cunitLabel = new JLabel(_bundle.getString("snapshottypedialog_unit"));
    private final JLabel _sunitLabel = new JLabel(_bundle.getString("snapshottypedialog_unit"));
    private final JLabel _titleLabel = new JLabel(_bundle.getString("snapshottype_data_title"));
    private JTextField _timeField;
    private JTextField _cmaxField;
    private JTextField _ytagField;
    private JTextField _cunitField;
    private JTextField _sunitField;
    private JTextField _titleField;
    private SnapShotTypeData _snapData;
    private ButtonGroup _topGroup;
    private ButtonGroup _subGroup1;
    private ButtonGroup _subGroup2;
    private short _timeType = (short)-1;
    private short _chartType = (short)-1;

    public SnapShotTypeDialog(JDialog jDialog, SnapShotTypeData snapShotTypeData) {
        super((Dialog)jDialog, true);
        this.setTitle(_bundle.getString("snapshottypedialog_dialog_title"));
        if (snapShotTypeData == null) {
            snapShotTypeData = new SnapShotTypeData();
        }
        this._snapData = snapShotTypeData;
        this._timeType = snapShotTypeData.getTimeType();
        this._chartType = snapShotTypeData.getChartType();
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getPanel(), "Center");
        this.pack();
    }

    private JPanel getPanel() {
        RadioButtonHandler radioButtonHandler = new RadioButtonHandler();
        FormLayout formLayout = new FormLayout("FILL:20PX:NONE,FILL:30PX:NONE,FILL:120PX:NONE,FILL:25PX:NONE,FILL:95PX:NONE,FILL:30PX:NONE,FILL:95PX:NONE,FILL:DEFAULT:NONE", "CENTER:20PX:NONE,CENTER:30PX:NONE,CENTER:15PX:NONE,CENTER:30PX:NONE,CENTER:15PX:NONE,CENTER:30PX:NONE,CENTER:30PX:NONE,CENTER:29PX:NONE,CENTER:15PX:NONE,CENTER:30PX:NONE,CENTER:15PX:NONE,CENTER:30PX:NONE,CENTER:30PX:NONE,CENTER:30PX:NONE,CENTER:30PX:NONE,CENTER:20PX:NONE,CENTER:30PX:NONE,CENTER:15PX:NONE");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._titleField = new JTextField();
        this._titleField.setDocument(SwingUtil.getTextLimit(50));
        panelBuilder.add((Component)this._titleLabel, cellConstraints.xywh(2, 2, 2, 1));
        panelBuilder.add((Component)this._titleField, cellConstraints.xywh(5, 2, 3, 1));
        JRadioButton jRadioButton = this.createRadioButton(CURRENTVALUE, radioButtonHandler);
        JRadioButton jRadioButton2 = this.createRadioButton(TIMESPAN, radioButtonHandler);
        this._topGroup = new ButtonGroup();
        this._topGroup.add(jRadioButton);
        this._topGroup.add(jRadioButton2);
        panelBuilder.add((Component)jRadioButton, cellConstraints.xywh(2, 4, 2, 1));
        panelBuilder.add((Component)jRadioButton2, cellConstraints.xywh(2, 10, 2, 1));
        JRadioButton jRadioButton3 = this.createRadioButton(TABLECHART, radioButtonHandler);
        JRadioButton jRadioButton4 = this.createRadioButton(METERCHART, radioButtonHandler);
        this._subGroup1 = new ButtonGroup();
        this._subGroup1.add(jRadioButton3);
        this._subGroup1.add(jRadioButton4);
        panelBuilder.add((Component)jRadioButton3, cellConstraints.xywh(3, 7, 1, 1));
        panelBuilder.add((Component)jRadioButton4, cellConstraints.xywh(3, 8, 1, 1));
        panelBuilder.add((Component)this._cunitLabel, cellConstraints.xywh(3, 6, 1, 1));
        this._cunitField = this.createField(10);
        panelBuilder.add((Component)this._cunitField, cellConstraints.xywh(5, 6, 3, 1));
        this._cmaxField = this.createField(32);
        panelBuilder.add((Component)this._cmaxLabel, cellConstraints.xywh(5, 8, 1, 1));
        panelBuilder.add((Component)this._cmaxField, cellConstraints.xywh(7, 8, 1, 1));
        JRadioButton jRadioButton5 = this.createRadioButton(LINECHART, radioButtonHandler);
        JRadioButton jRadioButton6 = this.createRadioButton(PIECHART, radioButtonHandler);
        this._subGroup2 = new ButtonGroup();
        this._subGroup2.add(jRadioButton5);
        this._subGroup2.add(jRadioButton6);
        this._timeField = this.createField(3);
        this._sunitField = this.createField(10);
        panelBuilder.add((Component)jRadioButton6, cellConstraints.xywh(3, 13, 1, 1));
        panelBuilder.add((Component)jRadioButton5, cellConstraints.xywh(3, 14, 1, 1));
        panelBuilder.add((Component)this._timeSpanLabel, cellConstraints.xywh(3, 12, 1, 1));
        panelBuilder.add((Component)this._timeField, cellConstraints.xywh(5, 12, 3, 1));
        this._ytagField = this.createField(10);
        panelBuilder.add((Component)this._tagLabel, cellConstraints.xywh(5, 14, 1, 1));
        panelBuilder.add((Component)this._ytagField, cellConstraints.xywh(7, 14, 1, 1));
        panelBuilder.add((Component)this._sunitLabel, cellConstraints.xywh(5, 15, 1, 1));
        panelBuilder.add((Component)this._sunitField, cellConstraints.xywh(7, 15, 1, 1));
        JButton jButton = new JButton(ICommonBundle.OK);
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SnapShotTypeDialog.this.getSnapShotData()) {
                    SnapShotTypeDialog.this.dispose();
                }
            }
        });
        panelBuilder.add((Component)jButton, cellConstraints.xywh(5, 17, 1, 1));
        JButton jButton2 = new JButton(ICommonBundle.CANCEL);
        jButton2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapShotTypeDialog.this.dispose();
            }
        });
        panelBuilder.add((Component)jButton2, cellConstraints.xywh(7, 17, 1, 1));
        this.activeTimeType();
        this.getRootPane().setDefaultButton(jButton);
        return panelBuilder.getPanel();
    }

    private JRadioButton createRadioButton(String string, RadioButtonHandler radioButtonHandler) {
        JRadioButton jRadioButton = new JRadioButton(_bundle.getString(string));
        jRadioButton.setActionCommand(string);
        if (!string.equals(CURRENTVALUE) && !string.equals(TIMESPAN)) {
            jRadioButton.setEnabled(false);
        }
        if (this._timeType == 0) {
            if (string.equals(CURRENTVALUE)) {
                jRadioButton.setSelected(true);
            }
        } else if (this._timeType == 1 && string.equals(TIMESPAN)) {
            jRadioButton.setSelected(true);
        }
        jRadioButton.addItemListener(radioButtonHandler);
        return jRadioButton;
    }

    private JTextField createField(int n2) {
        JTextField jTextField = SwingUtil.createTextLimitField(n2);
        jTextField.setEditable(false);
        return jTextField;
    }

    private boolean getSnapShotData() {
        if (this._timeType == -1 || this._chartType == -1) {
            this.showException(_bundle.getString("snapshottypedialog_no_parameter"));
            return false;
        }
        Object object = "";
        String string = this._titleField.getText();
        if (string != null && string.length() > 0) {
            object = (String)object + "title=" + string + ":";
        }
        if (this._timeType == 0) {
            String string2 = this._cunitField.getText();
            if (string2 != null) {
                object = (String)object + "unit=" + this._cunitField.getText() + ":";
            }
            if (this._chartType == 1) {
                String string3 = this._cmaxField.getText();
                if (string3 == null || !StringUtil.isDigit(string3) || this.parseInt(string3) == -1) {
                    this.showException("snapshottypedialog_maxvalue_error");
                    return false;
                }
                object = (String)object + "max=" + string3;
            }
        } else if (this._timeType == 1) {
            String string4 = this._timeField.getText();
            if (string4 == null || !StringUtil.isDigit(string4) || this.parseInt(string4) == -1) {
                this.showException("snapshottypedialog_timevalue_error");
                return false;
            }
            object = (String)object + "time=" + string4 + ":";
            if (this._chartType == 1) {
                String string5;
                String string6 = this._sunitField.getText();
                if (string6 != null) {
                    object = (String)object + "unit=" + this._sunitField.getText() + ":";
                }
                if ((string5 = this._ytagField.getText()) == null) {
                    this.showException("snapshottypedialog_ytag_error");
                    return false;
                }
                object = (String)object + "ytag=" + string5;
            }
        }
        this._snapData.setTimeType(this._timeType);
        this._snapData.setChartType(this._chartType);
        this._snapData.setParameters((String)object);
        return true;
    }

    private int parseInt(String string) {
        if (string != null) {
            string = string.trim();
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void showException(String string) {
        JOptionPane.showMessageDialog(this, _bundle.getString(string), _bundle.getString("snapshottypedialog_error_message_title"), 2);
    }

    private void active(String string) {
        this.parseChartType();
        if (this._titleField != null && this._titleField.getText().length() > 0) {
            String string2 = "title=" + this._titleField.getText() + ":";
            this._snapData.setParameters(string2);
        }
        if (string.equals(CURRENTVALUE)) {
            this.deActive(TIMESPAN);
        } else {
            this.deActive(CURRENTVALUE);
        }
        this.activeTimeType();
        this.repaint();
    }

    private void parseChartType() {
        ButtonGroup buttonGroup = null;
        buttonGroup = this._timeType == 0 ? this._subGroup1 : this._subGroup2;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setEnabled(true);
            if (!jRadioButton.isSelected()) continue;
            String string = jRadioButton.getActionCommand();
            if (string.equals(METERCHART)) {
                this._chartType = 1;
                continue;
            }
            if (string.equals(PIECHART)) {
                this._chartType = 0;
                continue;
            }
            if (string.equals(TABLECHART)) {
                this._chartType = 0;
                continue;
            }
            if (string.equals(LINECHART)) {
                this._chartType = 1;
                continue;
            }
            this._chartType = 0;
        }
    }

    private void deActive(String string) {
        Enumeration<AbstractButton> enumeration = null;
        if (string.equals(CURRENTVALUE)) {
            enumeration = this._subGroup1.getElements();
            this.disableField(this._cunitField);
            this.disableField(this._cmaxField);
        } else {
            enumeration = this._subGroup2.getElements();
            this.disableField(this._timeField);
            this.disableField(this._sunitField);
            this.disableField(this._ytagField);
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setSelected(false);
            jRadioButton.setEnabled(false);
        }
    }

    private void disableField(JTextField jTextField) {
        jTextField.setText("");
        jTextField.setEditable(false);
    }

    private void activeTimeType() {
        this._titleField.setText(this._snapData.getTitle());
        if (this._timeType == 0) {
            this._cunitField.setEditable(true);
            this._cunitField.setText(this._snapData.getUnit());
            this.activeChartButtonGroup(this._subGroup1);
        } else {
            this._timeField.setText(Integer.toString(this._snapData.getTime()));
            this._timeField.setEditable(true);
            this.activeChartButtonGroup(this._subGroup2);
        }
        this.repaint();
    }

    private void activeCurrentChartType() {
        if (this._chartType == 0) {
            this.disableField(this._cmaxField);
        } else {
            this._cmaxField.setEditable(true);
            this._cmaxField.setText(Integer.toString(this._snapData.getMax()));
        }
    }

    private void activeSpanTimeChartType() {
        if (this._chartType == 1) {
            this._sunitField.setText(this._snapData.getUnit());
            this._sunitField.setEditable(true);
            this._ytagField.setEditable(true);
            this._ytagField.setText(this._snapData.getYtag());
        } else {
            this.disableField(this._ytagField);
            this.disableField(this._sunitField);
        }
    }

    private void activeChartButtonGroup(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        String string = this.getActionCommand();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setEnabled(true);
            if (!string.equals(jRadioButton.getActionCommand())) continue;
            if (jRadioButton.isSelected()) {
                if (this._timeType == 0) {
                    this.activeCurrentChartType();
                    continue;
                }
                this.activeSpanTimeChartType();
                continue;
            }
            jRadioButton.setSelected(true);
        }
    }

    private String getActionCommand() {
        String string = "";
        string = this._timeType == 0 ? (this._chartType == 0 ? TABLECHART : METERCHART) : (this._chartType == 0 ? PIECHART : LINECHART);
        return string;
    }

    private class RadioButtonHandler
    implements ItemListener {
        private RadioButtonHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            String string = jRadioButton.getActionCommand();
            if (string.equals(SnapShotTypeDialog.CURRENTVALUE)) {
                SnapShotTypeDialog.this._timeType = 0;
                SnapShotTypeDialog.this.active(SnapShotTypeDialog.CURRENTVALUE);
            } else if (string.equals(SnapShotTypeDialog.TIMESPAN)) {
                SnapShotTypeDialog.this._timeType = 1;
                SnapShotTypeDialog.this.active(SnapShotTypeDialog.TIMESPAN);
            } else if (string.equals(SnapShotTypeDialog.METERCHART)) {
                SnapShotTypeDialog.this._chartType = 1;
                SnapShotTypeDialog.this.activeCurrentChartType();
            } else if (string.equals(SnapShotTypeDialog.PIECHART)) {
                SnapShotTypeDialog.this._chartType = 0;
                SnapShotTypeDialog.this.activeSpanTimeChartType();
            } else if (string.equals(SnapShotTypeDialog.TABLECHART)) {
                SnapShotTypeDialog.this._chartType = 0;
                SnapShotTypeDialog.this.activeCurrentChartType();
            } else if (string.equals(SnapShotTypeDialog.LINECHART)) {
                SnapShotTypeDialog.this._chartType = 1;
                SnapShotTypeDialog.this.activeSpanTimeChartType();
            }
        }
    }
}

