/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorTestRun;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class TestRunDialog {
    private static final Logger _logger = Logger.getLogger((String)TestRunDialog.class.getName());
    private JDialog _progress;
    private boolean _isError;
    private String _result;

    public void splashProgress(JDialog jDialog, int n2) {
        this.showProgressDialog(jDialog);
        try {
            List list = ClientProxy.getInstance().testMonitor(n2);
            this.closeProgressDialog();
            this.setTestRunResult(list);
        }
        catch (Exception exception) {
            _logger.error((Object)"test monitor", (Throwable)exception);
        }
    }

    public void splashProgress(JDialog jDialog, Monitor monitor) {
        this.showProgressDialog(jDialog);
        List list = MonitorBroker.getHostDebugDataList(monitor);
        this.closeProgressDialog();
        this.setTestRunResult(list);
    }

    private void showProgressDialog(JDialog jDialog) {
        this._progress = PerformanceUIUtil.getProgressDialog(jDialog, DialogConstants.TITLE_TESTRUN, false);
    }

    private void closeProgressDialog() {
        this._progress.setVisible(false);
        this._progress.dispose();
    }

    public boolean isError() {
        return this._isError;
    }

    public void showTestRunResultDialog(JDialog jDialog) {
        if (this._result.toString().trim().length() == 0) {
            JOptionPane.showMessageDialog(jDialog, DialogConstants.getBundledString("message_returnnull"), DialogConstants.TITLE_TESTRUN, 1);
        } else {
            JComponent jComponent = PerformanceUIUtil.getGraceMessagePane(this._result);
            JOptionPane jOptionPane = new JOptionPane(jComponent, 1);
            JDialog jDialog2 = jOptionPane.createDialog(jDialog, DialogConstants.TITLE_TESTRUN);
            jDialog2.setResizable(true);
            jDialog2.setVisible(true);
        }
    }

    private void setTestRunResult(List list) {
        if (list == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MonitorTestRun monitorTestRun = (MonitorTestRun)list.get(i2);
            this.appendResult(stringBuffer, monitorTestRun);
        }
        this._result = stringBuffer.toString();
    }

    public String getResult() {
        return this._result;
    }

    private void appendResult(StringBuffer stringBuffer, MonitorTestRun monitorTestRun) {
        String string = monitorTestRun.getHostName();
        stringBuffer.append("<b>").append(Snippet.getBundledString("host")).append(": ").append("</b>").append(string).append("<br><br>");
        for (Map.Entry entry : monitorTestRun.getResultMap().entrySet()) {
            Integer n2 = (Integer)entry.getKey();
            ResultValue resultValue = (ResultValue)entry.getValue();
            String string2 = MonitorHelper.getConstantLocaleName(n2);
            if (resultValue.isError()) {
                stringBuffer.append("<b>").append(Snippet.getBundledString("errormessage")).append(" ( ").append(string2).append(" ) ").append(":").append("</b>").append("<br>");
                stringBuffer.append(resultValue.getErrorUnknownMessage());
                this._isError = true;
            } else {
                stringBuffer.append("<b>").append(Snippet.getBundledString("okmessage")).append(" ").append(string2).append(" :").append("</b>").append("<br>");
                if (resultValue.isNormal()) {
                    String string3;
                    Object object = resultValue.getValue();
                    if (object instanceof Double) {
                        double d10 = (double)((int)((Double)object * 1000.0)) * 1.0 / 1000.0;
                        string3 = String.valueOf(d10);
                    } else {
                        string3 = object.toString();
                    }
                    stringBuffer.append("<table><tr><td><pre>").append(TestRunDialog.getEscapeText(string3)).append("</pre></table>");
                } else if (resultValue.isUnknown()) {
                    stringBuffer.append(resultValue.getErrorUnknownMessage());
                }
            }
            stringBuffer.append("<p>");
        }
        stringBuffer.append("<p>").append(monitorTestRun.getErrorText());
        stringBuffer.append("<br><br><hr>");
    }

    private static String getEscapeText(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public int showNewScheduleErrorDialog(JDialog jDialog) {
        StringBuffer stringBuffer = new StringBuffer(this._result);
        stringBuffer.append(DialogConstants.getBundledString("message_saveschedule"));
        return JOptionPane.showOptionDialog(jDialog, PerformanceUIUtil.getGraceMessagePane(stringBuffer.toString()), DialogConstants.TITLE_TESTRUN, 1, 2, null, DialogConstants.MODIFY_SAVE_QUIT_OPTION, DialogConstants.MODIFY_SAVE_QUIT_OPTION[2]);
    }

    public Object getExistedScheduleErrorMessage(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(this._result);
        if (bl2) {
            stringBuffer.append(DialogConstants.MESSAGE_REMOVE_SCHEDULE_DEP);
        } else {
            stringBuffer.append(DialogConstants.MESSAGE_REMOVE_SCHEDULE);
        }
        return PerformanceUIUtil.getGraceMessagePane(stringBuffer.toString());
    }
}

