/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.FormUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.mainframe.performance.MonitorCheckBox;
import com.sysuptime.mainframe.performance.MonitorCheckBoxListener;
import com.sysuptime.mainframe.performance.MonitorTextField;
import com.sysuptime.mainframe.performance.WmiDevicesMonitorPane;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

public class WmiPortMonitorPane
extends WmiDevicesMonitorPane {
    private static final String SEPARATOR_TOKEN = "|";
    private Map _index2SpeedMap;

    public WmiPortMonitorPane(String string) {
        super(string);
    }

    @Override
    protected JPanel initDevicesPane(Map map) {
        ArrayList arrayList = new ArrayList(map.keySet());
        int n2 = arrayList.size();
        Collections.sort(arrayList);
        FormLayout formLayout = this.getFormLayout(n2);
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Integer n4 = (Integer)arrayList.get(i2);
            String string = (String)map.get(n4);
            MonitorCheckBox monitorCheckBox = null;
            monitorCheckBox = new MonitorCheckBox(n4, string);
            monitorCheckBox.setToolTipText(string);
            monitorCheckBox.setSelected(true);
            MonitorTextField monitorTextField = new MonitorTextField(n4);
            long l2 = Long.parseLong(String.valueOf(this._index2SpeedMap.get(n4))) / 1000000L;
            monitorTextField.setText(String.valueOf(l2));
            FormLayout formLayout2 = new FormLayout("FILL:120PX:NONE,FILL:5PX:NONE,FILL:80PX:NONE,FILL:80PX:NONE,FILL:10PX:NONE,FILL:53PX:NONE,FILL:10PX:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
            JPanel jPanel2 = new JPanel((LayoutManager)formLayout2);
            jPanel2.add((Component)monitorCheckBox, cellConstraints.xy(1, 1));
            JLabel jLabel = new JLabel("( " + WmiPortMonitorPane.fromBundle("Label_bandwidth_speed") + ": ");
            jPanel2.add((Component)jLabel, cellConstraints.xy(3, 1));
            jPanel2.add((Component)monitorTextField, cellConstraints.xy(4, 1));
            JLabel jLabel2 = new JLabel(WmiPortMonitorPane.fromBundle("Label_bandwidth_speed_unit") + " )");
            jPanel2.add((Component)jLabel2, cellConstraints.xy(6, 1));
            FormUtil.addFillComponents(jPanel2, new int[]{1, 2, 3, 4, 5, 6, 7}, new int[]{1, 2});
            jPanel.add((Component)jPanel2, cellConstraints.xywh(1, ++n3, 2, 1));
            monitorCheckBox.addActionListener(new MonitorCheckBoxListener(monitorTextField));
        }
        this.fillComponents(jPanel, n2);
        return jPanel;
    }

    @Override
    public Map analyseResult(String string) {
        this._index2SpeedMap = new HashMap();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().length() == 0) continue;
            ++n2;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, SEPARATOR_TOKEN);
            int n3 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                switch (n3) {
                    case 0: {
                        Long l2 = Long.valueOf(string3);
                        this._index2SpeedMap.put(n2, l2);
                        break;
                    }
                    case 1: {
                        hashMap.put(n2, string3);
                    }
                }
                ++n3;
            }
        }
        return hashMap;
    }

    public Long getDefaultSpeed(Integer n2) {
        return (Long)this._index2SpeedMap.get(n2);
    }

    public Map getAllEnabledTextFieldText() {
        HashMap hashMap = new HashMap();
        this.handleAllBandwidthSpeedString(this, hashMap);
        return hashMap;
    }

    private void handleAllBandwidthSpeedString(JComponent jComponent, Map map) {
        for (int i2 = 0; i2 < jComponent.getComponentCount(); ++i2) {
            Component component = jComponent.getComponent(i2);
            if (!(component instanceof JComponent)) continue;
            if (component instanceof MonitorTextField) {
                MonitorTextField monitorTextField = (MonitorTextField)component;
                if (!monitorTextField.isEnabled()) continue;
                map.put(monitorTextField.getIfIndex(), monitorTextField.getText().trim());
                continue;
            }
            this.handleAllBandwidthSpeedString((JComponent)component, map);
        }
    }

    @Override
    protected String getTitleBorderText() {
        return WmiPortMonitorPane.fromBundle("Label_all_interfaces");
    }

    protected static String fromBundle(String string) {
        return NbBundle.getMessage(WmiPortMonitorPane.class, (String)string);
    }
}

