/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.trapreceiver;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.trapreceiver.RmiHelper;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.server.msp.Command;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DBClearDialog
extends JDialog
implements Serializable,
ActionListener,
CaretListener {
    private static final Logger _logger = Logger.getLogger((String)DBClearDialog.class.getName());
    private JButton _ok = new JButton(ICommonBundle.OK);
    private JButton _cancel = new JButton(ICommonBundle.CANCEL);
    private JTextField _snmp = new JTextField();
    private JTextField _performance = new JTextField();
    private JLabel _wrong = new JLabel();
    private boolean _error = false;

    public DBClearDialog(Frame frame, boolean bl2) {
        super(frame, bl2);
        FormLayout formLayout = new FormLayout("FILL:30PX:NONE,FILL:60PX:NONE,FILL:120PX:NONE,FILL:10PX:NONE,FILL:91PX:NONE,FILL:10PX:NONE,FILL:60PX:NONE", "CENTER:20PX:NONE,CENTER:DEFAULT:NONE,CENTER:20PX:NONE,CENTER:DEFAULT:NONE,CENTER:10PX:NONE,CENTER:20PX:NONE,CENTER:10PX:NONE,CENTER:DEFAULT:NONE,CENTER:20PX:NONE");
        this.setTitle(NbBundle.getMessage(DBClearDialog.class, (String)"label_database_data"));
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this._wrong, cellConstraints.xyw(2, 6, 6));
        this._wrong.setFont(new Font("Serif", 1, 15));
        RmiResponse rmiResponse = RmiHelper.rmiHelperForTrapReceiverConfig("getDBClearConfig", null, null);
        if (rmiResponse.getValue() != null) {
            Properties properties = (Properties)rmiResponse.getValue();
            this.a(properties);
            panelBuilder.addLabel(NbBundle.getMessage(DBClearDialog.class, (String)"label_keep_trap_data"), cellConstraints.xyw(2, 2, 2));
            panelBuilder.addLabel(NbBundle.getMessage(DBClearDialog.class, (String)"label_keep_perf_data"), cellConstraints.xyw(2, 4, 2));
            panelBuilder.add((Component)this._snmp, cellConstraints.xy(5, 2));
            panelBuilder.add((Component)this._performance, cellConstraints.xy(5, 4));
            String string = NbBundle.getMessage(DBClearDialog.class, (String)"label_keep_days");
            panelBuilder.addLabel(string, cellConstraints.xy(7, 2));
            panelBuilder.addLabel(string, cellConstraints.xy(7, 4));
            panelBuilder.add((Component)this._ok, cellConstraints.xy(3, 8));
            panelBuilder.add((Component)this._cancel, cellConstraints.xy(5, 8));
        }
        this.getContentPane().add((Component)panelBuilder.getPanel(), "Center");
        this.pack();
    }

    private void a(Properties properties) {
        this._performance.setText(properties.get("performance").toString());
        this._snmp.setText(properties.get("snmp").toString());
        this._snmp.addCaretListener(this);
        this._performance.addCaretListener(this);
        this.a(this._ok, "ok");
        this.a(this._cancel, "cancel");
    }

    private void a() {
        this.b();
        this._error = !StringUtil.isDigit(this._snmp.getText()) || !StringUtil.isDigit(this._performance.getText());
        this.a(!StringUtil.isDigit(this._snmp.getText()), NbBundle.getMessage(DBClearDialog.class, (String)"message_positve_number"));
        this.a(!StringUtil.isDigit(this._performance.getText()), NbBundle.getMessage(DBClearDialog.class, (String)"message_positve_number"));
        this._ok.setEnabled(!this._error);
    }

    private void a(boolean bl2, String string) {
        this._wrong.setIcon(this._error ? SwingUtil.getImage("error-16x16.gif") : null);
        if (bl2) {
            this._wrong.setText(string);
        }
        if (!this._error) {
            this._wrong.setText("");
        }
    }

    private void b() {
        this._wrong.setIcon(null);
        this._wrong.setText("");
        this._error = false;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.a();
    }

    private void a(AbstractButton abstractButton, String string) {
        abstractButton.setActionCommand(string);
        abstractButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            String string;
            block4: {
                string = actionEvent.getActionCommand();
                Command[] commandArray = AlarmActionsDialog.A();
                if (!string.equals("ok")) break block4;
                this.c();
                if (commandArray == null) break block5;
            }
            if (string.equals("cancel")) {
                this.dispose();
            }
        }
    }

    private void c() {
        block7: {
            RmiResponse rmiResponse = RmiResponse.FALSE;
            Command[] commandArray = AlarmActionsDialog.A();
            try {
                rmiResponse = ClientProxy.getInstance().changeDBClearConfig(this._snmp.getText().trim(), this._performance.getText().trim());
            }
            catch (Exception exception) {
                _logger.error((Object)"change db clear config", (Throwable)exception);
            }
            try {
                block6: {
                    try {
                        if (!rmiResponse.getValue().equals(Boolean.TRUE)) break block6;
                        this.dispose();
                        if (commandArray == null) break block7;
                    }
                    catch (Exception exception) {
                        throw DBClearDialog.a(exception);
                    }
                }
                _logger.error((Object)rmiResponse.getErrorMessage());
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(DBClearDialog.class, (String)"MSG_schedule_update_failed") + "\r\n" + rmiResponse.getErrorMessage(), ICommonBundle.ERROR, 0);
            }
            catch (Exception exception) {
                throw DBClearDialog.a(exception);
            }
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

