/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.trapreceiver;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.trapreceiver.DedupEventObject;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.trapreceiver.DeduplicationDialog;
import com.sysuptime.mainframe.trapreceiver.DeduplicationModel;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.server.msp.Command;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DeduplicationPanel
extends JPanel
implements Serializable,
ActionListener,
CaretListener {
    private static final Logger _logger = Logger.getLogger((String)DeduplicationPanel.class.getName());
    private JButton _add = new JButton(ICommonBundle.ADD);
    private JButton _delete = new JButton(ICommonBundle.DELETE);
    private JButton _modfiy = new JButton(ICommonBundle.MODIFY);
    private JButton _apply = new JButton(ICommonBundle.APPLY);
    private JCheckBox _enabled = new JCheckBox(NbBundle.getMessage(DeduplicationPanel.class, (String)"CHECKBOX_deduplication_panel_enable"));
    private JTextField _time = new JTextField();
    private JTable _table;
    private DeduplicationModel _model;
    private JLabel _wrong = new JLabel();

    public DeduplicationPanel() {
        FormLayout formLayout = new FormLayout("FILL:8DLU:NONE,FILL:DEFAULT:NONE,FILL:8DLU:NONE,FILL:80PX:NONE,FILL:8DLU:NONE,FILL:80PX:NONE,FILL:8DLU:NONE,FILL:80PX:NONE,FILL:8DLU:NONE,FILL:80PX:NONE,FILL:8DLU:NONE", "CENTER:10PX:NONE,CENTER:DEFAULT:NONE,CENTER:10PX:NONE,CENTER:DEFAULT:NONE,CENTER:10PX:NONE,CENTER:200PX:NONE,CENTER:10PX:NONE,CENTER:DEFAULT:NONE,CENTER:10PX:NONE,CENTER:20PX:NONE,CENTER:10PX:NONE,CENTER:DEFAULT:NONE,CENTER:10PX:NONE");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this._wrong, cellConstraints.xyw(2, 10, 6));
        SwingUtilities.invokeLater(() -> {
            try {
                Properties properties;
                RmiResponse rmiResponse = ClientProxy.getInstance().getDedupConfig();
                if (rmiResponse.getValue() != null && this.a(properties = (Properties)rmiResponse.getValue())) {
                    panelBuilder.add((Component)this._enabled, cellConstraints.xy(2, 2));
                    panelBuilder.addLabel(NbBundle.getMessage(DeduplicationPanel.class, (String)"LABEL_deduplication_panel_time"), cellConstraints.xy(2, 4));
                    panelBuilder.add((Component)this._time, cellConstraints.xy(4, 4));
                    JScrollPane jScrollPane = new JScrollPane(this._table);
                    jScrollPane.setBorder(BorderFactory.createEtchedBorder());
                    panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(2, 6, 9, 1));
                    panelBuilder.add((Component)this._add, cellConstraints.xy(4, 8));
                    panelBuilder.add((Component)this._delete, cellConstraints.xy(6, 8));
                    panelBuilder.add((Component)this._modfiy, cellConstraints.xy(8, 8));
                    panelBuilder.add((Component)this._apply, cellConstraints.xy(10, 4));
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"get dedup config", (Throwable)exception);
            }
        });
        this.add((Component)panelBuilder.getPanel(), "Center");
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this._apply.setEnabled(!this._enabled.isSelected() || this._time.getText().length() != 0);
    }

    private boolean a(Properties properties) {
        RmiResponse rmiResponse = RmiResponse.FALSE;
        try {
            rmiResponse = ClientProxy.getInstance().getDedupEvents();
        }
        catch (Exception exception) {
            _logger.error((Object)"get dedup events", (Throwable)exception);
        }
        try {
            if (rmiResponse.getValue().equals(Boolean.FALSE)) {
                _logger.error((Object)rmiResponse.getErrorMessage());
                JOptionPane.showMessageDialog(this, rmiResponse.getErrorMessage());
                return false;
            }
        }
        catch (Exception exception) {
            throw DeduplicationPanel.a(exception);
        }
        ArrayList arrayList = (ArrayList)rmiResponse.getValue();
        this._model = new DeduplicationModel(arrayList);
        this._table = SwingUtil.createJTable(this._model);
        this._table.setSelectionMode(0);
        this._time.addCaretListener(this);
        this._time.setText(properties.get("time").toString());
        this._enabled.setSelected(StringUtil.getBool(properties.get("enable").toString()));
        this._apply.setEnabled(false);
        this.a(this._enabled.isSelected());
        this.a(this._add, "add");
        this.a(this._delete, "delete");
        this.a(this._modfiy, "modify");
        this.a(this._apply, "apply");
        this.a(this._enabled, "enabled");
        return true;
    }

    private void a(AbstractButton abstractButton, String string) {
        abstractButton.setActionCommand(string);
        abstractButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            String string;
            block8: {
                Command[] commandArray;
                block7: {
                    block6: {
                        block4: {
                            string = actionEvent.getActionCommand();
                            commandArray = AlarmActionsDialog.A();
                            if (!string.equals("add")) break block4;
                            this.b();
                            if (commandArray == null) break block5;
                        }
                        if (!string.equals("delete")) break block6;
                        this.c();
                        if (commandArray == null) break block5;
                    }
                    if (!string.equals("modify")) break block7;
                    this.d();
                    if (commandArray == null) break block5;
                }
                if (!string.equals("apply")) break block8;
                this.e();
                if (commandArray == null) break block5;
            }
            if (string.equals("enabled")) {
                this.a();
            }
        }
    }

    private void a() {
        if (this._enabled.isSelected() && this._time.getText().trim().length() == 0) {
            this._time.setText("60");
        }
        this._apply.setEnabled(!this._enabled.isSelected() || this._time.getText().length() != 0);
        this.a(this._enabled.isSelected());
    }

    private void a(boolean bl2) {
        this._time.setEditable(bl2);
        this._add.setEnabled(bl2);
        this._delete.setEnabled(bl2);
        this._modfiy.setEnabled(bl2);
        this._table.setEnabled(bl2);
    }

    private void b() {
        block8: {
            Command[] commandArray = AlarmActionsDialog.A();
            DeduplicationDialog deduplicationDialog = new DeduplicationDialog(SwingUtil.getParentFrame(this), true, null, NbBundle.getMessage(DeduplicationPanel.class, (String)"TITLE_deduplication_panel_add"), this._model);
            SwingUtil.centerOnFrame(SwingUtil.getParentFrame(this), deduplicationDialog);
            deduplicationDialog.setVisible(true);
            Command[] commandArray2 = commandArray;
            if (deduplicationDialog.getFlag()) {
                DedupEventObject dedupEventObject = deduplicationDialog.getEvent();
                RmiResponse rmiResponse = RmiResponse.FALSE;
                try {
                    rmiResponse = ClientProxy.getInstance().addDedupEvent(dedupEventObject);
                }
                catch (Exception exception) {
                    _logger.error((Object)"add dedep event", (Throwable)exception);
                }
                try {
                    block7: {
                        try {
                            if (!rmiResponse.getValue().equals(Boolean.TRUE)) break block7;
                            this._model.addRow(dedupEventObject);
                            if (commandArray2 == null) break block8;
                        }
                        catch (Exception exception) {
                            throw DeduplicationPanel.a(exception);
                        }
                    }
                    _logger.error((Object)rmiResponse.getErrorMessage());
                    JOptionPane.showMessageDialog(this, rmiResponse.getErrorMessage());
                }
                catch (Exception exception) {
                    throw DeduplicationPanel.a(exception);
                }
            }
        }
    }

    private void c() {
        int n2;
        long l2 = ClientProxy.getInstance().getProbe().getId();
        try {
            if (!ClientProxy.getInstance().isActive(l2)) {
                return;
            }
        }
        catch (Exception exception) {
            throw DeduplicationPanel.a(exception);
        }
        int n3 = this._table.getSelectedRow();
        if (n3 != -1 && (n2 = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(DeduplicationPanel.class, (String)"MESSAGE_delete"), NbBundle.getMessage(DeduplicationPanel.class, (String)"TITLE_deduplication_panel_delete"), 0)) == 0) {
            DedupEventObject dedupEventObject = this._model.getEvent(n3);
            String string = dedupEventObject.getOid();
            RmiResponse rmiResponse = RmiResponse.FALSE;
            try {
                rmiResponse = ClientProxy.getInstance().deleteDedupEvent(string);
            }
            catch (Exception exception) {
                _logger.error((Object)"delete dedup event", (Throwable)exception);
            }
            try {
                if (rmiResponse.getValue().equals(Boolean.FALSE)) {
                    _logger.error((Object)rmiResponse.getErrorMessage());
                    JOptionPane.showMessageDialog(this, rmiResponse.getErrorMessage());
                    return;
                }
            }
            catch (Exception exception) {
                throw DeduplicationPanel.a(exception);
            }
            this._model.removeRow(n3);
        }
    }

    private void d() {
        int n2 = this._table.getSelectedRow();
        if (n2 != -1) {
            DedupEventObject dedupEventObject = this._model.getEvent(n2);
            DeduplicationDialog deduplicationDialog = new DeduplicationDialog(SwingUtil.getParentFrame(this), true, dedupEventObject, NbBundle.getMessage(DeduplicationPanel.class, (String)"TITLE_deduplication_panel_modify"), null);
            SwingUtil.centerOnFrame(SwingUtil.getParentFrame(this), deduplicationDialog);
            deduplicationDialog.setVisible(true);
            if (deduplicationDialog.getFlag()) {
                DedupEventObject dedupEventObject2 = deduplicationDialog.getEvent();
                RmiResponse rmiResponse = RmiResponse.FALSE;
                try {
                    rmiResponse = ClientProxy.getInstance().modifyDedupEvent(dedupEventObject2);
                }
                catch (Exception exception) {
                    _logger.error((Object)"modify dedup event", (Throwable)exception);
                }
                try {
                    if (rmiResponse.getValue().equals(Boolean.FALSE)) {
                        _logger.error((Object)rmiResponse.getErrorMessage());
                        JOptionPane.showMessageDialog(this, rmiResponse.getErrorMessage());
                        return;
                    }
                }
                catch (Exception exception) {
                    throw DeduplicationPanel.a(exception);
                }
                dedupEventObject.setConditions(dedupEventObject2.getConditions());
                dedupEventObject.setName(dedupEventObject2.getName());
                this._model.fireTableDataChanged();
            }
        }
    }

    /*
     * Loose catch block
     */
    private void e() {
        block19: {
            String string;
            String string2;
            Command[] commandArray;
            block17: {
                String string3;
                String string4;
                long l2 = ClientProxy.getInstance().getProbe().getId();
                commandArray = AlarmActionsDialog.A();
                try {
                    if (!ClientProxy.getInstance().isActive(l2)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    throw DeduplicationPanel.a(exception);
                }
                try {
                    string4 = this._enabled.isSelected() ? "Yes" : "No";
                }
                catch (Exception exception) {
                    throw DeduplicationPanel.a(exception);
                }
                string2 = string4;
                try {
                    string3 = this._enabled.isSelected() ? this._time.getText() : "60";
                }
                catch (Exception exception) {
                    throw DeduplicationPanel.a(exception);
                }
                string = string3;
                if (!this._enabled.isSelected()) break block17;
                try {
                    block20: {
                        if (StringUtil.isDigit(string)) break block17;
                        break block20;
                        catch (Exception exception) {
                            throw DeduplicationPanel.a(exception);
                        }
                    }
                    JOptionPane.showMessageDialog(this, NbBundle.getMessage(DeduplicationPanel.class, (String)"MESSAGE_deduplicationPanel_digit"), NbBundle.getMessage(DeduplicationPanel.class, (String)"TITLE_error_information"), 0);
                    return;
                }
                catch (Exception exception) {
                    throw DeduplicationPanel.a(exception);
                }
            }
            RmiResponse rmiResponse = RmiResponse.FALSE;
            try {
                rmiResponse = ClientProxy.getInstance().changeDedup(string2, string);
            }
            catch (Exception exception) {
                _logger.error((Object)"change dedup", (Throwable)exception);
            }
            try {
                block18: {
                    try {
                        if (!rmiResponse.getValue().equals(Boolean.TRUE)) break block18;
                        this._apply.setEnabled(false);
                        if (commandArray == null) break block19;
                    }
                    catch (Exception exception) {
                        throw DeduplicationPanel.a(exception);
                    }
                }
                _logger.error((Object)rmiResponse.getErrorMessage());
                JOptionPane.showMessageDialog(this, rmiResponse.getErrorMessage());
            }
            catch (Exception exception) {
                throw DeduplicationPanel.a(exception);
            }
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

