/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.trapreceiver;

import com.sysuptime.common.trapreceiver.MessageUtil;
import com.sysuptime.common.trapreceiver.TrapObject;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.trapreceiver.RmiHelper;
import com.sysuptime.mainframe.trapreceiver.TrapModel;
import com.sysuptime.mainframe.trapreceiver.TrapReceiverFrame;
import com.sysuptime.mainframe.trapreceiver.TrapTableSorter;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.server.msp.Command;
import com.ultraswing.aR;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ViewTrapsDialog
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final Logger _logger = Logger.getLogger((String)ViewTrapsDialog.class.getName());
    private JDialog _dialog;
    private JTable _table;
    private TrapReceiverFrame _trapReceiverFrame;
    private TrapModel _trapModel;
    private String[] _ipAddress;
    private aR _cSplitPane = new aR(false);
    private JEditorPane _message;
    TrapTableSorter _trapTableSorter;
    public static final int MAX_NUM_OF_ROWS = 1500;

    public ViewTrapsDialog(JDialog jDialog, String[] stringArray) {
        this._cSplitPane.setPreferredSize(new Dimension(700, 400));
        this._cSplitPane.setDividerSize(5);
        this._message = new JEditorPane();
        this._trapReceiverFrame = new TrapReceiverFrame("ViewTrapsAtDialog", this._message);
        this._table = this._trapReceiverFrame.getTrapTable();
        this._trapModel = this._trapReceiverFrame.getModel();
        this._dialog = jDialog;
        this._ipAddress = stringArray;
    }

    public JPanel initPanel() {
        JButton jButton = new JButton(ICommonBundle.CLOSE);
        jButton.setActionCommand("Close");
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        this._table = SwingUtil.createJTable(this.a(this._ipAddress));
        this._table.setModel(this._trapTableSorter);
        this._trapReceiverFrame.initTable(this._table);
        this._trapReceiverFrame.initTableColumn(this._table);
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)jScrollPane, "Center");
        this.a();
        this._cSplitPane.addFirst(jPanel2, 4.0f);
        this._cSplitPane.addLast(new JScrollPane(this._message), 6.0f);
        this._dialog.getContentPane().add((Component)jPanel, "South");
        return this._cSplitPane;
    }

    private void a() {
        this._message.setContentType("text/html");
        this._message.setPreferredSize(new Dimension(700, 200));
        this._message.setMinimumSize(new Dimension(700, 100));
    }

    void a(TrapObject trapObject) {
        this._message.setText(MessageUtil.getMessageInHtml(trapObject, Startup.isMspEdition()));
        this._message.setCaretPosition(0);
    }

    private TrapTableSorter a(String[] stringArray) {
        Date date = new Date();
        long l2 = date.getTime() - 86400000L;
        long l3 = date.getTime();
        this._trapTableSorter = new TrapTableSorter(this.a(l2, l3, stringArray, this._trapModel));
        this._trapTableSorter.setSortingStatus(4, -1);
        this._trapTableSorter.setTableHeader(this._table.getTableHeader());
        return this._trapTableSorter;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close") && this._dialog != null) {
            this._dialog.dispose();
            this._dialog = null;
        }
    }

    private TrapModel a(long l2, long l3, String[] stringArray, TrapModel trapModel) {
        Long l4 = l2;
        Long l5 = l3;
        Cursor cursor = new Cursor(0);
        this._dialog.setCursor(new Cursor(3));
        trapModel.removeAllTrapObjects();
        SwingUtilities.invokeLater(() -> {
            Command[] commandArray = AlarmActionsDialog.A();
            try {
                String string = "N";
                Object[] objectArray = new Object[]{true, stringArray, string, new Integer(0), l4, l5, new Integer(1500)};
                String[] stringArray2 = new String[]{"java.lang.Boolean", String[].class.getName(), "java.lang.String", "java.lang.Integer", "java.lang.Long", "java.lang.Long", "java.lang.Integer"};
                RmiResponse rmiResponse = RmiHelper.rmiHelperForTrapReceiverHelper("getTraps", objectArray, stringArray2);
                if (rmiResponse.getValue().equals(Boolean.FALSE)) {
                    JOptionPane.showMessageDialog(this, rmiResponse.getErrorMessage());
                    return;
                }
                ArrayList arrayList = (ArrayList)rmiResponse.getValue();
                for (Object e10 : arrayList) {
                    TrapObject trapObject = (TrapObject)e10;
                    try {
                        this._trapReceiverFrame.addTraps(trapObject, true);
                        this._trapModel.fireTableDataChanged();
                        if (commandArray != null) return;
                        if (commandArray == null) continue;
                        return;
                    }
                    catch (Exception exception) {
                        throw ViewTrapsDialog.a(exception);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
                return;
            }
            finally {
                this._dialog.setCursor(cursor);
            }
        });
        trapModel = this._trapReceiverFrame.getModel();
        return trapModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            if (this._table.getSelectedRowCount() > 1) {
                this.a((TrapObject)null);
            }
            if (this._table.getSelectedRowCount() == 1) {
                int n2 = listSelectionModel.getMinSelectionIndex();
                int n3 = this._trapTableSorter.modelIndex(n2);
                TrapObject trapObject = (TrapObject)this._trapModel.getAllTrapObjects().get(n3);
                this._trapReceiverFrame.a(trapObject, this._message);
            }
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

