/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.util.sshterm;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.discovery.DiscoveryOptionsData;
import com.sysuptime.common.discovery.SshData;
import com.sysuptime.common.discovery.SshHost;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.sshterm.SSHDialog$1;
import com.sysuptime.mainframe.util.sshterm.SSHTerm;
import com.sysuptime.server.msp.Command;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SSHDialog
extends JPanel
implements ActionListener,
KeyListener {
    private static final Logger _logger = Logger.getLogger((String)SSHDialog.class.getName());
    private static final String IP = NbBundle.getMessage(SSHDialog.class, (String)"SSHDialog_label_ip");
    private static final String USER = NbBundle.getMessage(SSHDialog.class, (String)"SSHDialog_label_username");
    private static final String PASSWORD = NbBundle.getMessage(SSHDialog.class, (String)"SSHDialog_label_password");
    private String _title;
    private JTextField _ipAddressField = new JTextField(10);
    private JTextField _portField = new JTextField("22", 10);
    private JTextField _userNameField = new JTextField(10);
    private JPasswordField _passwordField = new JPasswordField(10);
    private JButton _okButton;
    private JButton _cancelButton;
    private JDialog _dialog;

    public SSHDialog(JDialog jDialog, String string) {
        this._dialog = jDialog;
        this._title = string;
    }

    public void setHost(SshHost sshHost) {
        if (sshHost != null) {
            this._portField.setText(String.valueOf(sshHost.port));
            this._userNameField.setText(sshHost.username);
            this._passwordField.setText(sshHost.password);
        }
    }

    public void setDefaultButton(JDialog jDialog) {
        jDialog.getRootPane().setDefaultButton(this._okButton);
    }

    public JPanel initSSHPanel() {
        this._okButton = new JButton(ICommonBundle.OK);
        this._cancelButton = new JButton(ICommonBundle.CANCEL);
        Command[] commandArray = SSHTerm.b();
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,LEFT:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:160PX:NONE,FILL:12PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(IP, 4);
        jPanel.add((Component)jLabel, cellConstraints.xy(4, 3));
        jPanel.add((Component)this._ipAddressField, cellConstraints.xywh(5, 3, 4, 1));
        jPanel.add((Component)new JLabel("Port"), cellConstraints.xy(4, 5));
        jPanel.add((Component)this._portField, cellConstraints.xywh(5, 5, 4, 1));
        JLabel jLabel2 = new JLabel(USER, 2);
        jPanel.add((Component)jLabel2, cellConstraints.xy(4, 7));
        jPanel.add((Component)this._userNameField, cellConstraints.xywh(5, 7, 4, 1));
        JLabel jLabel3 = new JLabel(PASSWORD, 2);
        jPanel.add((Component)jLabel3, cellConstraints.xy(4, 9));
        jPanel.add((Component)this._passwordField, cellConstraints.xywh(5, 9, 4, 1));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this._okButton);
        jPanel2.add(this._cancelButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        Command[] commandArray2 = commandArray;
        jPanel3.add((Component)jPanel2, "South");
        this._okButton.addKeyListener(this);
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        if (Command.b() != null) {
            SSHTerm.b(new Command[1]);
        }
        return jPanel3;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            block5: {
                Command[] commandArray = SSHTerm.b();
                if (actionEvent == null) break block4;
                if (actionEvent.getSource() != this._okButton) break block5;
                this.a();
                if (commandArray == null) break block4;
            }
            if (actionEvent.getSource() == this._cancelButton) {
                this._dialog.dispose();
            }
        }
    }

    private void a() {
        try {
            this._dialog.dispose();
            String string = this._userNameField.getText();
            String string2 = this._ipAddressField.getText();
            String string3 = new String(this._passwordField.getPassword());
            int n2 = 22;
            try {
                n2 = Integer.parseInt(this._portField.getText());
                if (n2 <= 0) {
                    n2 = 22;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SSHTerm sSHTerm = new SSHTerm(string2, n2, string, string3);
            this._dialog.dispose();
            JDialog jDialog = new JDialog(Startup.getFrame(), true);
            jDialog.setTitle("SSH");
            SwingUtil.centerOnFrame(Startup.getFrame(), jDialog);
            jDialog.addWindowListener(new SSHDialog$1(this, sSHTerm, jDialog));
            JMenuBar jMenuBar = sSHTerm.getJMenuBar();
            jDialog.setJMenuBar(jMenuBar);
            jDialog.setSize((int)((double)sSHTerm.getTermWidth() * 1.05), (int)((double)sSHTerm.getTermHeight() * 1.3));
            jDialog.getContentPane().add("Center", sSHTerm);
            SwingUtil.centerOnFrame(Startup.getFrame(), jDialog);
            jDialog.setResizable(true);
            sSHTerm.setFrame(jDialog.getContentPane());
            sSHTerm.setDialog(jDialog);
            sSHTerm.setVisible(true);
            jDialog.setVisible(true);
            try {
                DiscoveryOptionsData discoveryOptionsData = ProxyMBeanInvoker.INSTANCE.getDiscoveryOptions(ClientProxy.getInstance().getProbe().getId(), Startup.getCurrentUserName());
                SshData sshData = discoveryOptionsData.getSshData();
                if (sshData == null) {
                    sshData = new SshData(null);
                }
                sshData.addHost(string2, n2, string, string3);
                discoveryOptionsData.setSshData(sshData);
                ProxyMBeanInvoker.INSTANCE.saveDiscoveryOptions(ClientProxy.getInstance().getProbe().getId(), Startup.getCurrentUserName(), discoveryOptionsData);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            _logger.error((Object)"", throwable);
            throwable.printStackTrace();
        }
    }

    public JDialog getDialog() {
        return this._dialog;
    }

    public String getTitle() {
        return this._title;
    }

    public void setAddress(String string) {
        this._ipAddressField.setText(string);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this._okButton.isFocusable() && keyEvent.getKeyCode() == 10) {
            this._okButton.doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

