/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.ireasoning.protocol.snmp.SnmpSession;
import com.ireasoning.protocol.snmp.SnmpTableModel;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.ModelUtil;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.net.NetworkUtils;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.util.JNbtstat;
import com.sysuptime.server.util.JPing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ActiveDeviceChecker
implements Serializable {
    private static final Logger _logger = Logger.getLogger((String)ActiveDeviceChecker.class.getName());
    public static final String WINDOW_ARP_A = "arp -a";
    public static final String LINUX_ARP_N = "arp -n";
    public static final String OSX_ARP_N_A = "arp -n -a";
    private Hashtable<String, String> _cachedIP2Macs = new Hashtable();

    public ActiveDeviceChecker() {
        this.resetArpCache();
    }

    public void resetArpCache() {
        this._cachedIP2Macs.clear();
        try {
            this.a();
            _logger.info((Object)("cached ips: " + this._cachedIP2Macs));
        }
        catch (IOException iOException) {
            _logger.error((Object)"", (Throwable)iOException);
        }
    }

    private void a() throws IOException {
        String string = this.b();
        if (string != null) {
            Process process = Runtime.getRuntime().exec(string);
            this.a(process);
        }
    }

    private String b() {
        if (AppUtil.isWindows()) {
            return WINDOW_ARP_A;
        }
        if (AppUtil.isLinux()) {
            return LINUX_ARP_N;
        }
        if (AppUtil.isOsX()) {
            return OSX_ARP_N_A;
        }
        return null;
    }

    private void a(Process process) throws IOException {
        BufferedReader bufferedReader;
        block20: {
            String string;
            block17: {
                bufferedReader = null;
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                string = null;
                boolean bl2 = AppUtil.isLinux();
                try {
                    if (!AppUtil.isWindows() && !bl2) break block17;
                }
                catch (IOException iOException) {
                    throw ActiveDeviceChecker.a(iOException);
                }
                while ((string = bufferedReader.readLine()) != null) {
                    int n2;
                    String string2;
                    int n3;
                    String[] stringArray;
                    block19: {
                        block18: {
                            StringTokenizer stringTokenizer = new StringTokenizer(string);
                            stringArray = new String[stringTokenizer.countTokens()];
                            int n4 = 0;
                            try {
                                while (stringTokenizer.hasMoreTokens()) {
                                    stringArray[n4++] = stringTokenizer.nextToken();
                                }
                            }
                            catch (IOException iOException) {
                                throw ActiveDeviceChecker.a(iOException);
                            }
                            try {
                                try {
                                    if (stringArray.length <= 2) continue;
                                    if (!bl2) break block18;
                                }
                                catch (IOException iOException) {
                                    throw ActiveDeviceChecker.a(iOException);
                                }
                                n3 = 2;
                                break block19;
                            }
                            catch (IOException iOException) {
                                throw ActiveDeviceChecker.a(iOException);
                            }
                        }
                        n3 = 1;
                    }
                    if (!NetworkUtils.isValidMac(string2 = stringArray[n2 = n3])) continue;
                    String string3 = stringArray[0];
                    this._cachedIP2Macs.put(string3, string2);
                }
                break block20;
            }
            if (AppUtil.isOsX()) {
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    int n5 = 0;
                    try {
                        while (stringTokenizer.hasMoreTokens()) {
                            stringArray[n5++] = stringTokenizer.nextToken();
                        }
                    }
                    catch (IOException iOException) {
                        throw ActiveDeviceChecker.a(iOException);
                    }
                    if (stringArray.length <= 3) continue;
                    String string4 = stringArray[1];
                    string4 = string4.substring(string4.indexOf(40) + 1, string4.indexOf(41));
                    String string5 = this.a(stringArray[3]);
                    try {
                        if (string5 == null) continue;
                        this._cachedIP2Macs.put(string4, string5);
                    }
                    catch (IOException iOException) {
                        throw ActiveDeviceChecker.a(iOException);
                    }
                }
            }
        }
        bufferedReader.close();
    }

    private String a(String string) {
        String[] stringArray = (string = string.replaceAll(":", "-")).split("-");
        if (stringArray.length != 6) {
            return null;
        }
        return this.b(string);
    }

    private String b(String string) {
        Object object = "";
        String[] stringArray = string.split("-");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (string2.length() == 1) {
                stringArray[i2] = "0" + stringArray[i2];
            }
            object = i2 < n2 - 1 ? (String)object + stringArray[i2] + "-" : (String)object + stringArray[i2];
        }
        return ((String)object).toUpperCase();
    }

    public boolean isActive(String string, int n2) {
        if (JPing.getRtt(string, n2) != -1) {
            return true;
        }
        if (JNbtstat.getNbInfo(string) != null) {
            _logger.info((Object)(JNbtstat.getNbInfo(string) + ". Nbtstat ok: " + string));
            return true;
        }
        return this.c(string);
    }

    private boolean c(String string) {
        return this._cachedIP2Macs.contains(string);
    }

    public void addCacheItem(String string, String string2) {
        this._cachedIP2Macs.put(string, string2);
    }

    public void addArpCache(SnmpSession snmpSession) {
        block7: {
            String string = ".1.3.6.1.2.1.4.22";
            boolean bl2 = DiscoveryOptions.c();
            try {
                SnmpTableModel snmpTableModel = snmpSession.snmpGetTable(string);
                try {
                    _logger.info((Object)("ipNet2MediaTable of " + snmpSession.getTarget().getHost()));
                    if (snmpTableModel == null || snmpTableModel.getRowCount() <= 0) break block7;
                }
                catch (IOException iOException) {
                    throw ActiveDeviceChecker.a(iOException);
                }
                SnmpVarBind[] snmpVarBindArray = snmpTableModel.getColumn(1);
                SnmpVarBind[] snmpVarBindArray2 = snmpTableModel.getColumn(2);
                int n2 = snmpVarBindArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2 = ModelUtil.varBind2String(snmpVarBindArray[i2]);
                    try {
                        _logger.info((Object)("mac = " + string2));
                        if (!bl2) break;
                        if (!NetworkUtils.isValidMac(string2)) continue;
                    }
                    catch (IOException iOException) {
                        throw ActiveDeviceChecker.a(iOException);
                    }
                    String string3 = ModelUtil.varBind2String(snmpVarBindArray2[i2]);
                    _logger.info((Object)string3);
                    this.addCacheItem(string3, string2);
                    if (bl2) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                _logger.debug((Object)("cannot access " + snmpSession.getTarget()));
            }
        }
    }

    public String getMac(String string) {
        return this._cachedIP2Macs.get(string);
    }

    public void completeMac(NetworkNodeBean networkNodeBean) {
        NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
        boolean bl2 = DiscoveryOptions.d();
        if (networkInterfaceArray != null) {
            for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
                String string;
                EthernetInterface ethernetInterface;
                if (!(networkInterfaceArray[i2] instanceof EthernetInterface) || (ethernetInterface = (EthernetInterface)networkInterfaceArray[i2]).getMacAddress().length() != 0 || (string = this.getMac(ethernetInterface.getIpAddress())) == null) continue;
                ethernetInterface.setMacAddress(string);
                if (!bl2) continue;
            }
        }
    }

    private static IOException a(IOException iOException) {
        return iOException;
    }
}

