/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Group;
import com.sysuptime.server.performance.GroupReader;
import com.sysuptime.server.performance.GroupWriter;
import com.sysuptime.server.util.DefaultConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class GroupProcessor {
    private GroupProcessor() {
    }

    public static List getGroupMonitorList() throws SQLException {
        List list;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = GroupReader.getGroupMonitorList(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static Map getGroupNameToId() throws SQLException {
        Map map = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            map = GroupReader.getGroupNameToId(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return map;
    }

    public static List getGroupList() throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = GroupReader.getGroupList(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static Map getGroupIdToName() throws SQLException {
        Map map = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            map = GroupReader.getGroupIdToName(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return map;
    }

    public static void storeGroup(Group group) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            GroupWriter.storeGroupData(connection, group);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static void updateGroupName(Group group) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            GroupWriter.updateGroupName(connection, group);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static void removeGroup(long l2) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            GroupWriter.deleteGroup(connection, l2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group getGroupById(long l2) throws SQLException {
        Connection connection = null;
        Group group = null;
        try {
            connection = DefaultConnection.getConnection();
            group = GroupReader.getGroupById(connection, l2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return group;
    }
}

