/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.openapi.performance.IQueryExecutor;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.PerformanceGraph;
import com.sysuptime.common.performance.ProcessResult;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.GroupProcessor;
import com.sysuptime.server.performance.GroupReader;
import com.sysuptime.server.performance.MetricsReader;
import com.sysuptime.server.performance.MonitorCache;
import com.sysuptime.server.performance.MonitorHostProcessor;
import com.sysuptime.server.performance.MonitorImportHelper;
import com.sysuptime.server.performance.MonitorProcessor;
import com.sysuptime.server.performance.NoUseStateTimebucketCache;
import com.sysuptime.server.performance.PMDBMonitorProviderMBean;
import com.sysuptime.server.performance.PerformanceConfigProcessor;
import com.sysuptime.server.performance.ProtocolQueryResultProcessor;
import com.sysuptime.server.performance.RemoteHostProcessor;
import com.sysuptime.server.performance.TestRunExecutorProxy;
import com.sysuptime.server.performance.TimebucketProcessor;
import com.sysuptime.server.performance.XmlPath;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.LicenseServerProxy;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PMDBMonitorProvider
implements PMDBMonitorProviderMBean {
    private static final Logger log = Logger.getLogger((String)PMDBMonitorProvider.class.getName());

    @Override
    public Monitor getScheduleData(int n2) {
        Monitor monitor = null;
        try {
            monitor = MonitorCache.getMonitor(n2);
        }
        catch (Exception exception) {
            log.error((Object)("Get monitor " + exception.toString()));
        }
        return monitor;
    }

    @Override
    public int getScheduleId(String string) {
        int n2 = -1;
        try {
            n2 = MonitorProcessor.getScheduleId(string);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get schedule id " + exception.toString()));
        }
        return n2;
    }

    @Override
    public Map getScheduleNameToId() {
        Map map = null;
        try {
            map = MonitorProcessor.getScheduleNameToId();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)"Get schedule (name, id) ", (Throwable)exception);
        }
        return map;
    }

    @Override
    public Map getScheduleNameToIdFromProbe(int n2) {
        Map map = null;
        try {
            map = MonitorProcessor.getScheduleNameToIdFromProbe(n2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)"Get schedule (name, id) ", (Throwable)exception);
        }
        return map;
    }

    @Override
    public Map getTimebucketNameToId() {
        return NoUseStateTimebucketCache.getNameToId();
    }

    @Override
    public List getScheduleNameList() {
        List list = null;
        try {
            list = MonitorProcessor.getScheduleNameList();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get schedule data list " + exception.toString()));
        }
        return list;
    }

    @Override
    public List getScheduleNameList(long l2) {
        List list = null;
        try {
            list = MonitorProcessor.getScheduleNameList(l2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get schedule data list " + exception.toString()));
        }
        return list;
    }

    @Override
    public List getGroupScheduleDataList() {
        List list = null;
        try {
            list = GroupProcessor.getGroupMonitorList();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get schedule data list " + exception.toString()));
        }
        return list;
    }

    @Override
    public List<Monitor> getScheduleDataList() {
        return this.getScheduleDataList(-1L, -1);
    }

    @Override
    public List getScheduleDataList(long l2, int n2) {
        List<Monitor> list = null;
        try {
            list = MonitorProcessor.getScheduleDataList(l2, n2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get schedule data list " + exception.toString()));
        }
        return list;
    }

    @Override
    public List getNoUseStateTimebuckets() {
        return NoUseStateTimebucketCache.getTimebuckets();
    }

    @Override
    public long getWeekDayTimebucketId() {
        long l2 = -1L;
        try {
            l2 = TimebucketProcessor.getWeekDayTimebucketId();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("WeekDay timebucket id is : " + exception));
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map[] getGroupFilterInfo() {
        Map[] mapArray = new Map[2];
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            mapArray[0] = GroupReader.getGroupIdToName(connection);
            mapArray[1] = MetricsReader.getDistinctMetrics(connection);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return mapArray;
    }

    @Override
    public Map getGroupNameToId() {
        Map map = null;
        try {
            map = GroupProcessor.getGroupNameToId();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get group name to id " + exception.toString()));
        }
        return map;
    }

    @Override
    public List getGroupList() {
        List list = null;
        try {
            list = GroupProcessor.getGroupList();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get group data" + exception.toString()));
        }
        return list;
    }

    @Override
    public Map getGroupIdToName() {
        Map map = null;
        try {
            map = GroupProcessor.getGroupIdToName();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)("Get group id to name" + exception.toString()));
        }
        return map;
    }

    @Override
    public List getMonitorIds(long l2) {
        List list = null;
        try {
            list = MonitorProcessor.getMonitorIds(l2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public List getAllRemoteHostNames() {
        List list = null;
        try {
            list = RemoteHostProcessor.getRemoteHostNameList();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public List getAllFlagedRemoteHosts() {
        List list = null;
        try {
            list = RemoteHostProcessor.getFlagedRemoteHostList();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public List getRemoteHosts(int n2) {
        List list = null;
        try {
            list = RemoteHostProcessor.getRemoteHosts(n2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public List getRemoteHosts() {
        List list = null;
        try {
            list = RemoteHostProcessor.getRemoteHosts();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public List getTestRunResults(Monitor monitor) {
        List list = null;
        try {
            MonitorCache.putMonitor(monitor);
            list = TestRunExecutorProxy.getTestRunResults(monitor);
            IQueryExecutor iQueryExecutor = ExecutorHelper.getExecutor(monitor.getProtocolType());
            iQueryExecutor.removeTemp(-1);
            MonitorCache.removeMonitorFromCache(monitor.getScheduleId());
        }
        catch (Exception exception) {
            log.error((Object)"Get test run result ", (Throwable)exception);
        }
        return list;
    }

    @Override
    public List getTestRunResults(int n2) {
        List list = null;
        try {
            Monitor monitor = MonitorCache.getMonitor(n2);
            list = TestRunExecutorProxy.getTestRunResults(monitor);
        }
        catch (Exception exception) {
            log.error((Object)"Get test run result ", (Throwable)exception);
        }
        return list;
    }

    @Override
    public List getQueryResult(int n2, long l2, int n3, long l3, long l4, int n4) {
        List list = null;
        try {
            list = ProtocolQueryResultProcessor.getQueryResult(n2, l2, n3, l3, l4, n4);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public List getRecentQueryResults(int[] nArray, int n2, int n3, String string, int n4, boolean bl2) {
        List list = null;
        try {
            list = ProtocolQueryResultProcessor.getRecentQueryResults(nArray, n2, n3, string, n4, bl2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public boolean isExceedLicense(int n2) {
        boolean bl2;
        int n3 = -1;
        try {
            n3 = MonitorHostProcessor.getScheduleHostIdCount() + n2;
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        try {
            bl2 = !LicenseServerProxy.isValid("monitors", n3);
        }
        catch (SQLException sQLException) {
            throw PMDBMonitorProvider.a(sQLException);
        }
        return bl2;
    }

    @Override
    public List getInverseDependencies(int n2) {
        List list = null;
        try {
            list = MonitorProcessor.getInverseDependencies(n2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)"getDepency", (Throwable)exception);
        }
        return list;
    }

    @Override
    public List getDisableDependencies(int n2) {
        List list = null;
        try {
            list = MonitorProcessor.getDisableDependencies(n2);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public List getAllDependencies() {
        List list = null;
        try {
            list = MonitorProcessor.getAllDependencies();
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException);
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
        return list;
    }

    @Override
    public PerformanceGraph getPerformanceGraph(int n2) {
        return MonitorProcessor.getGraphData(n2);
    }

    @Override
    public void updateConfigProperties(Map map) {
        PerformanceConfigProcessor.updateConfigProperties(map);
    }

    @Override
    public Map getConfigProperties() {
        return PerformanceConfigProcessor.getConfigProperties();
    }

    @Override
    public byte[] getMonitorXML(String string) {
        return XmlPath.getConfXmlByte(string);
    }

    @Override
    public Map getConstantNameToId() {
        return ExecutorHelper.getConstantsNameToId();
    }

    @Override
    public Map getConstantIdToName() {
        return ExecutorHelper.getConstantsIdToName();
    }

    @Override
    public Map getID2TimebucketMap() {
        return NoUseStateTimebucketCache.getCacheMap();
    }

    @Override
    public ProcessResult getWmiCommandExecResult(String string, Long l2, Integer n2, String string2) {
        ProcessResult processResult = null;
        try {
            processResult = ExecutorHelper.getConciseWmiCommandExecResult(string, l2, n2, string2);
        }
        catch (Exception exception) {
            log.error((Object)"", (Throwable)exception);
        }
        return processResult;
    }

    @Override
    public ResultValue getSshCommandExecResult(String string, Long l2, Integer n2) {
        ResultValue resultValue = null;
        try {
            resultValue = ExecutorHelper.getConciseSshCommandExecResult(string, l2, n2);
        }
        catch (Exception exception) {
            log.error((Object)"", (Throwable)exception);
        }
        return resultValue;
    }

    @Override
    public String getServerConfigPath() {
        return AppUtil.getAppServerHomeDirectory() + File.separator + "conf" + File.separator;
    }

    @Override
    public ProcessResult getProperties(String string, Long l2, Integer n2, String string2) {
        ProcessResult processResult = null;
        try {
            processResult = ExecutorHelper.getProperties(string, l2, n2, string2);
        }
        catch (Exception exception) {
            log.error((Object)"", (Throwable)exception);
        }
        return processResult;
    }

    @Override
    public boolean importMonitors(String string, long l2) {
        try {
            return MonitorImportHelper.INSTACE.importMonitors(string, l2);
        }
        catch (Exception exception) {
            log.error((Object)"", (Throwable)exception);
            return false;
        }
    }

    @Override
    public List<Monitor> getAddMonitors() {
        return MonitorImportHelper.INSTACE.getAddMonitorList();
    }

    @Override
    public String getImportErrorMessage() {
        return MonitorImportHelper.INSTACE.getErrorMessage();
    }

    @Override
    public String getImportWarnMessage() {
        return MonitorImportHelper.INSTACE.getWarningMessage();
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

