/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.util.ServerConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PerformanceConfigProcessor {
    private PerformanceConfigProcessor() {
    }

    public static int getMaxRecords() {
        return (int)PerformanceServerUtil.getParsedLongValue(10L, "performance.maxRecords");
    }

    public static int getMinRecords() {
        return (int)PerformanceServerUtil.getParsedLongValue(5L, "performance.minRecords");
    }

    public static String getUserAgent() {
        return ServerConfig.getProperty("performance.userAgent");
    }

    public static Map getConfigProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("performance.keepConnectionOpen", ServerConfig.getProperty("performance.keepConnectionOpen", "F"));
        hashMap.put("performance.userAgent", ServerConfig.getProperty("performance.userAgent"));
        hashMap.put("performance.proxyHost", ServerConfig.getProperty("performance.proxyHost"));
        hashMap.put("performance.proxyPort", ServerConfig.getProperty("performance.proxyPort"));
        hashMap.put("performance.minRecords", ServerConfig.getProperty("performance.minRecords"));
        hashMap.put("performance.maxRecords", ServerConfig.getProperty("performance.maxRecords"));
        return hashMap;
    }

    public static void updateConfigProperties(Map map) {
        Iterator iterator = map.entrySet().iterator();
        int n2 = ExecutorHelper.b();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ServerConfig.updateProperty(entry.getKey().toString(), entry.getValue().toString());
            if (n2 != 0) continue;
        }
    }
}

