/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.ProtocolQuery;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.trapreceiver.AlarmActions;
import com.sysuptime.common.trapreceiver.RemoteAction;
import com.sysuptime.common.util.TextProcessor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.NoUseStateTimebucketCache;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class ProtocolQueryReader {
    private static final Logger _logger = Logger.getLogger((String)ProtocolQueryReader.class.getName());
    private static Hashtable _typeCache = new Hashtable();

    private ProtocolQueryReader() {
    }

    public static void setProtocolQuery(Connection connection, ProtocolQuery protocolQuery, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "SELECT target_type_c, parameters_c, protocol_type_c, is_saved_c, actions_c FROM PM_PROTOCOL_QUERY WHERE SCHEDULE_ID_C =?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n2);
            protocolQuery.setScheduleId(n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                protocolQuery.setTargetType(string2);
                short s2 = resultSet.getShort(3);
                protocolQuery.setProtocolType(s2);
                QueryParameter queryParameter = ExecutorHelper.getParameter(s2);
                queryParameter.fromText(TextProcessor.decodeFromBase64Format(resultSet.getString(2), "aBCde1235EaaaaNbbbbb"));
                protocolQuery.setQueryParameters(queryParameter);
                boolean bl2 = SqlUtil.getBoolean(resultSet, 4);
                protocolQuery.setSaved(bl2);
                String string3 = resultSet.getString(5);
                if (string3 != null) {
                    string3 = TextProcessor.decodeFromBase64Format(string3, "aBCde1235EaaaaNbbbbb");
                }
                protocolQuery.setActions(string3);
                ProtocolQueryReader.updateCache(n2, s2);
            }
        }
        catch (Exception exception) {
            try {
                throw new SQLException("Read pm_protocol_query data: " + exception.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void updateCache(int n2, int n3) {
        _typeCache.put(n2, n3);
    }

    public static int getProtocolType(int n2) throws SQLException {
        Integer n3 = n2;
        Integer n4 = (Integer)_typeCache.get(n3);
        try {
            if (n4 != null) {
                return n4;
            }
        }
        catch (SQLException sQLException) {
            throw ProtocolQueryReader.a(sQLException);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        int n5 = -1;
        try {
            connection = DefaultConnection.getConnection();
            String string = "SELECT PROTOCOL_TYPE_C FROM PM_PROTOCOL_QUERY WHERE SCHEDULE_ID_C =?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n5 = resultSet.getShort(1);
                _typeCache.put(n3, n5);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_protocol_query to get protocol type: " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeConnection(connection, preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeConnection(connection, preparedStatement);
        return n5;
    }

    public static List getUsedHostId(Connection connection) throws SQLException {
        ArrayList<Long> arrayList;
        block14: {
            arrayList = new ArrayList<Long>();
            PreparedStatement preparedStatement = null;
            List list = ExecutorHelper.getRemoteHostProtocol();
            int n2 = list.size();
            int n3 = ExecutorHelper.b();
            if (n2 > 0) {
                try {
                    int n4;
                    StringBuffer stringBuffer = new StringBuffer("SELECT protocol_type_c, parameters_c FROM PM_PROTOCOL_QUERY WHERE protocol_type_c =?");
                    for (n4 = 1; n4 < n2; ++n4) {
                        stringBuffer.append(" or protocol_type_c =?");
                        if (n3 != 0) continue;
                    }
                    preparedStatement = connection.prepareStatement(stringBuffer.toString());
                    preparedStatement.setObject(1, list.get(0));
                    for (n4 = 1; n4 < n2; ++n4) {
                        try {
                            preparedStatement.setObject(n4 + 1, list.get(n4));
                            if (n3 != 0) {
                                if (n3 != 0) continue;
                                break;
                            }
                            break block14;
                        }
                        catch (Exception exception) {
                            throw ProtocolQueryReader.a(exception);
                        }
                    }
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        QueryParameter queryParameter = ExecutorHelper.getParameter(resultSet.getInt(1));
                        try {
                            queryParameter.fromText(TextProcessor.decodeFromBase64Format(resultSet.getString(2), "aBCde1235EaaaaNbbbbb"));
                            arrayList.add(Long.valueOf(queryParameter.get(0).toString()));
                            if (n3 != 0) {
                                if (n3 != 0) continue;
                                break;
                            }
                            break block14;
                        }
                        catch (Exception exception) {
                            throw ProtocolQueryReader.a(exception);
                        }
                    }
                    arrayList.addAll(ProtocolQueryReader.a(connection));
                }
                catch (Exception exception) {
                    try {
                        _logger.error((Object)"", (Throwable)exception);
                        throw new SQLException("Read pm_protocol_query data: " + exception.toString());
                    }
                    catch (Throwable throwable) {
                        DefaultConnection.closeStatement(preparedStatement);
                        throw throwable;
                    }
                }
                DefaultConnection.closeStatement(preparedStatement);
            }
        }
        return arrayList;
    }

    private static List a(Connection connection) {
        ArrayList arrayList;
        block5: {
            arrayList = new ArrayList();
            int n2 = ExecutorHelper.c();
            PreparedStatement preparedStatement = null;
            HashSet hashSet = new HashSet();
            try {
                String string = "SELECT actions_c FROM pm_protocol_query UNION ALL SELECT actions_c FROM fm_event";
                preparedStatement = connection.prepareStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2;
                    block6: {
                        string2 = resultSet.getString(1);
                        try {
                            if (n2 != 0) break block5;
                            if (string2 == null) break block6;
                        }
                        catch (Exception exception) {
                            throw ProtocolQueryReader.a(exception);
                        }
                        string2 = TextProcessor.decodeFromBase64Format(string2, "aBCde1235EaaaaNbbbbb");
                    }
                    AlarmActions alarmActions = AlarmActions.fromXML(string2, NoUseStateTimebucketCache.getCacheMap());
                    RemoteAction remoteAction = alarmActions.getRemoteCommandAction(true);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    remoteAction = alarmActions.getRemoteCommandAction(false);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    remoteAction = alarmActions.getComputerAction(true);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    remoteAction = alarmActions.getComputerAction(false);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    remoteAction = alarmActions.getServiceAction(true);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    remoteAction = alarmActions.getServiceAction(false);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    remoteAction = alarmActions.getKillAction(true);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    remoteAction = alarmActions.getKillAction(false);
                    ProtocolQueryReader.a(remoteAction, hashSet);
                    if (n2 == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
            }
            arrayList.addAll(hashSet);
        }
        return arrayList;
    }

    private static void a(RemoteAction remoteAction, Collection collection) {
        String string;
        if (remoteAction != null && (string = remoteAction.getRemoteHostID()) != null) {
            collection.add(Long.valueOf(string));
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

