/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.trapreceiver;

import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.util.bl;
import com.ireasoning.util.n;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.common.trapreceiver.MessageUtil;
import com.sysuptime.common.trapreceiver.ProcessEmailTemplate;
import com.sysuptime.common.trapreceiver.TrapEventObject;
import com.sysuptime.common.trapreceiver.TrapObject;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.NameValuePair;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.trapreceiver.GeneralTimeEmailDao;
import com.sysuptime.server.trapreceiver.PooledPerformer;
import com.sysuptime.server.util.ServerConfig;
import com.sysuptime.server.util.ServerPropertiesFile;
import com.sysuptime.server.util.mail.SendMail;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class TrapMailSender {
    private static final Logger _logger = Logger.getLogger((String)TrapMailSender.class.getName());

    public static void loadMibs() {
        String[] stringArray = PooledPerformer.b();
        String string = AppUtil.getAppHomeDirectory() + "/mibs";
        _logger.info((Object)("To load all files under:" + string));
        String[] stringArray2 = stringArray;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                if (fileArray[i2].isDirectory() && stringArray2 != null) continue;
            }
            catch (Exception exception) {
                throw TrapMailSender.a(exception);
            }
            try {
                _logger.info((Object)("To load MIB: " + fileArray[i2].getAbsolutePath()));
                MibUtil.loadMib(fileArray[i2].getAbsolutePath());
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)("Can't load MIB:" + fileArray[i2].getAbsolutePath()));
            }
            if (stringArray2 != null) continue;
        }
    }

    private static boolean a(int n2) {
        return n2 >= Integer.parseInt(ServerConfig.getProperty("trapReceiver.severityOfMail", "0"));
    }

    public static void sendTrap2GeneralMail(TrapObject trapObject) {
        if (!ServerConfig.getProperty("trapReceiver.mailEnabled", "No").equals("No") && TrapMailSender.a(trapObject.getSeverity())) {
            List list = GeneralTimeEmailDao.getMailTimePairList();
            TrapMailSender.emailAction(list, trapObject);
        }
    }

    public static void emailAction(List list, TrapObject trapObject) {
        StringBuffer stringBuffer;
        String string;
        boolean bl2;
        block5: {
            String string2;
            block4: {
                bl2 = false;
                boolean bl3 = false;
                String string3 = ServerConfig.getProperty("trapReceiver.templateEnabled", "No");
                String string4 = ServerConfig.getProperty("trapReceiver.subjectTemplateEnabled", "No");
                bl2 = StringUtil.getBool(string3);
                bl3 = StringUtil.getBool(string4);
                n n2 = new n(false);
                String[] stringArray = PooledPerformer.b();
                TrapMailSender.setPerformanceText(trapObject, n2);
                string = TrapMailSender.a(trapObject, bl2, n2.getValue());
                string2 = "";
                TrapEventObject trapEventObject = trapObject.getEvent();
                if (trapEventObject != null) {
                    string2 = trapEventObject.getMessage(trapObject);
                }
                stringBuffer = new StringBuffer("");
                if (!bl3 || !bl2) break block4;
                stringBuffer.append(TrapMailSender.a(trapObject, n2.getValue()));
                if (stringArray != null) break block5;
            }
            stringBuffer.append(ICommonBundle.SEVERITY_COLON).append(" ").append(ITrapConstants.SEVERITY_STRINGS[trapObject.getSeverity()]).append(". ").append(string2);
        }
        TrapMailSender.sendEmail(list, stringBuffer.toString(), string, bl2);
    }

    public static void sendEmail(List list, String string, String string2) {
        TrapMailSender.sendEmail(list, string, string2, false);
    }

    public static void sendEmail(List list, String string, String string2, boolean bl2) {
        long l2 = System.currentTimeMillis();
        int n2 = list.size();
        String[] stringArray = PooledPerformer.b();
        for (int i2 = 0; i2 < n2; ++i2) {
            RmiResponse rmiResponse;
            NameValuePair nameValuePair = (NameValuePair)list.get(i2);
            String string3 = nameValuePair.getName().toString();
            Timebucket timebucket = (Timebucket)nameValuePair.getValue();
            if (!timebucket.isExecutedTime(l2)) continue;
            if (bl2) {
                rmiResponse = SendMail.sendMail(string, string2, string3, null, "text/plain");
                if (stringArray != null) continue;
            }
            rmiResponse = SendMail.sendMail(string, string2, string3, null, "text/html");
            if (stringArray != null) continue;
        }
    }

    private static String a(TrapObject trapObject, boolean bl2) {
        String string = ServerConfig.getProperty("trapReceiver.subjectTemplate");
        if (string == null) {
            return "";
        }
        return new ProcessEmailTemplate(string, bl2).toString(trapObject);
    }

    private static String a(TrapObject trapObject, boolean bl2, boolean bl3) {
        if (bl2) {
            String string = ServerConfig.getProperty("trapReceiver.template");
            if (string == null) {
                return "";
            }
            return new ProcessEmailTemplate(string, bl3).toString(trapObject);
        }
        return MessageUtil.getMessageInHtml(trapObject, ServerPropertiesFile.isMspEdition());
    }

    public static void setPerformanceText(TrapObject trapObject, n n2) {
        long l2 = trapObject.getSpecific();
        if (l2 != 1000L && l2 != 1002L && l2 != 1001L) {
            if (n2 != null) {
                n2.setValue(false);
            }
            return;
        }
        if (n2 != null) {
            n2.setValue(true);
        }
        List<bl> list = trapObject.getVarbinds();
        bl bl2 = null;
        bl2 = list.get(3);
        int n3 = -1;
        String string = null;
        String string2 = bl2.getVarbindValue();
        if (StringUtil.isDigit(string2)) {
            n3 = Integer.parseInt(string2);
            string = ExecutorHelper.getName(n3);
            if (string != null) {
                bl2.setVarbindValue(Snippet.getBundledString(string.trim()));
            }
        } else {
            string = string2;
        }
        MessageUtil.setPerformanceText(trapObject, true, string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

