/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.util;

import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.FileUtil;
import com.sysuptime.server.util.MBeanUtil;
import com.sysuptime.server.util.ServerConfig;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public final class DefaultConnection {
    private static final Logger _logger = Logger.getLogger((String)DefaultConnection.class.getName());
    public static final String DEFAULT_DATA_SOURCE = "java:/DefaultDS";
    static final Hashtable _debugTable = new Hashtable();
    static int _totalConnCount = 0;
    private static boolean _databaseInitialized = false;
    private static boolean _forNamed = false;

    public static Connection getConnection() {
        return DefaultConnection.getConnection(null);
    }

    public static Connection getConnection(String string) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:postgresql://127.0.0.1:9543/postgres", "postgres", "postgres");
        }
        catch (Exception exception) {
            _logger.error((Object)"Can't get a db connection.");
        }
        return connection;
    }

    public static void closeConnection(Connection connection) {
        DefaultConnection.closeConnection(connection, null, null, null);
    }

    public static void closeStatement(Statement statement) {
        DefaultConnection.closeConnection(null, statement, null, null);
    }

    public static void closeConnection(Connection connection, Statement statement) {
        DefaultConnection.closeConnection(connection, statement, null, null);
    }

    public static void closeConnection(Connection connection, Statement statement, ResultSet resultSet) {
        DefaultConnection.closeConnection(connection, statement, resultSet, null);
    }

    /*
     * Loose catch block
     */
    public static void closeConnection(Connection connection, Statement statement, ResultSet resultSet, String string) {
        block12: {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection == null) break block12;
                try {
                    block13: {
                        if (connection.isClosed()) break block12;
                        break block13;
                        catch (Exception exception) {
                            throw DefaultConnection.a(exception);
                        }
                    }
                    connection.close();
                }
                catch (Exception exception) {
                    throw DefaultConnection.a(exception);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean initializeDatabase(Connection connection) {
        String string = MBeanUtil.b();
        try {
            if ("true".equals(ServerConfig.getProperty("database.initialized"))) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            throw DefaultConnection.a(sQLException);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            _logger.info((Object)"Enter db initialization");
            statement = connection.createStatement();
            connection.setAutoCommit(false);
            String string2 = AppUtil.getAppServerHomeDirectory();
            String string3 = string2 + "/conf/dbinit.txt";
            BufferedReader bufferedReader = FileUtil.getReader(string3);
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                String string4 = bufferedReader.readLine();
                try {
                    if (string4 == null) {
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    throw DefaultConnection.a(sQLException);
                }
                if ((string4 = string4.trim()).length() < 1 || string4.startsWith("#")) continue;
                try {
                    if (string4.startsWith("--")) {
                        continue;
                    }
                }
                catch (SQLException sQLException) {
                    throw DefaultConnection.a(sQLException);
                }
                boolean bl2 = false;
                if (string4.endsWith(";")) {
                    bl2 = true;
                }
                stringBuffer.append(" ").append(string4);
                if (!bl2) continue;
                string4 = stringBuffer.toString();
                stringBuffer.delete(0, stringBuffer.length());
                try {
                    statement.executeUpdate(string4);
                }
                catch (SQLException sQLException) {
                    _logger.error((Object)("dbinit. Couldn't update: " + string4 + "\nError:" + sQLException));
                }
                if (string == null) break;
            }
            connection.commit();
            connection.setAutoCommit(true);
            bufferedReader.close();
            ServerConfig.setupProp();
            ServerConfig.updateProperty("database.initialized", "true");
            boolean bl3 = true;
            return bl3;
        }
        catch (Exception exception) {
            _logger.error((Object)"Database query failed", (Throwable)exception);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

