/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public final class TopShadowOverlayPainter
implements SubstanceOverlayPainter {
    private static Map<Integer, TopShadowOverlayPainter> MAP = new HashMap<Integer, TopShadowOverlayPainter>();
    private static final int DEFAULT_SHADOW_START_ALPHA = 160;
    private static final int MIN_SHADOW_START_ALPHA = 32;
    private int startAlpha = 160;

    public static synchronized TopShadowOverlayPainter getInstance(int strength) {
        if (strength < 0 || strength > 100) {
            throw new IllegalArgumentException("Strength must be in [0..100] range");
        }
        if (!MAP.containsKey(strength)) {
            TopShadowOverlayPainter painter = new TopShadowOverlayPainter();
            painter.startAlpha = 32 + 128 * strength / 100;
            MAP.put(strength, painter);
        }
        return MAP.get(strength);
    }

    private TopShadowOverlayPainter() {
    }

    @Override
    public void paintOverlay(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        Color shadowColor = SubstanceColorUtilities.deriveByBrightness(SubstanceColorUtilities.getBackgroundFillColor(comp), -0.4f);
        Component topMostWithSameDecorationAreaType = SubstanceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(0, -dy);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(shadowColor, this.startAlpha), 0.0f, 4.0f, SubstanceColorUtilities.getAlphaColor(shadowColor, 16)));
        g2d.fillRect(0, 0, comp.getWidth(), 4);
        g2d.dispose();
    }

    @Override
    public String getDisplayName() {
        return "Top Shadow";
    }
}

