/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorWheel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.HSBColorSliderModel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.SubstanceColorChooserPanel;

public class ColorWheelChooser
extends SubstanceColorChooserPanel
implements UIResource {
    private ColorWheel colorWheel;
    private HSBColorSliderModel ccModel = new HSBColorSliderModel();
    private JSlider brightnessSlider;

    public ColorWheelChooser() {
        this.initComponents();
        int textSliderGap = UIManager.getInt("ColorChooser.textSliderGap");
        if (textSliderGap != 0) {
            BorderLayout layout = (BorderLayout)this.getLayout();
            layout.setHgap(textSliderGap);
        }
        this.colorWheel = new ColorWheel();
        this.add(this.colorWheel);
        this.ccModel.configureColorSlider(2, this.brightnessSlider);
        this.colorWheel.setModel(this.ccModel);
        this.ccModel.addChangeListener(e -> this.setColorToModel(this.ccModel.getColor()));
    }

    private void initComponents() {
        this.brightnessSlider = new JSlider();
        this.setLayout(new BorderLayout());
        this.brightnessSlider.setMajorTickSpacing(50);
        this.brightnessSlider.setOrientation(1);
        this.brightnessSlider.setPaintTicks(true);
        this.add((Component)this.brightnessSlider, "East");
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.colorWheel");
    }

    @Override
    public ResizableIcon getHiDpiAwareIcon(int size, SubstanceColorScheme colorScheme) {
        return SubstanceCortex.GlobalScope.getIconPack().getColorChooserColorWheelIcon(size, colorScheme);
    }

    @Override
    public void updateChooser() {
        this.ccModel.setColor(this.getColorFromModel());
    }

    public void setColorToModel(Color color) {
        this.getColorSelectionModel().setSelectedColor(color);
    }
}

