/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.scroll;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconPack;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class AutoScrollActivator {
    private JScrollPane scrollPane;
    private AutoScrollProperties autoScrollProperties;
    private static final int SCROLL_ICON_SIZE = 28;

    public AutoScrollActivator(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.configureScrollPane();
    }

    private void deactivateAutoScroll() {
        if (this.autoScrollProperties == null) {
            return;
        }
        this.autoScrollProperties.timer.stop();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoScrollProperties.toolkitListener);
        this.autoScrollProperties.iconPopupMenu.setVisible(false);
        this.autoScrollProperties = null;
    }

    private void activateAutoScroll(MouseEvent e) {
        this.autoScrollProperties = new AutoScrollProperties();
        this.autoScrollProperties.isDragMode = false;
        JViewport viewport = this.scrollPane.getViewport();
        this.autoScrollProperties.currentLocation = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(this.autoScrollProperties.currentLocation, viewport);
        this.autoScrollProperties.startLocation = this.autoScrollProperties.currentLocation;
        final JPopupMenu iconPopupMenu = new JPopupMenu(){

            @Override
            public void setBorder(Border border) {
            }
        };
        iconPopupMenu.setFocusable(false);
        iconPopupMenu.setOpaque(false);
        JLabel iconLabel = new JLabel(this.getAutoScrollIcon());
        iconLabel.addMouseWheelListener(e1 -> this.deactivateAutoScroll());
        iconPopupMenu.add(iconLabel);
        iconPopupMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                iconPopupMenu.setVisible(false);
            }
        });
        this.autoScrollProperties.iconPopupMenu = iconPopupMenu;
        Dimension iconPopupMenuSize = iconPopupMenu.getPreferredSize();
        iconPopupMenu.show(viewport, this.autoScrollProperties.startLocation.x - iconPopupMenuSize.width / 2, this.autoScrollProperties.startLocation.y - iconPopupMenuSize.height / 2);
        Container parent = iconPopupMenu.getParent();
        if (parent instanceof JComponent) {
            ((JComponent)parent).setBorder(null);
        }
        ActionListener actionListener = actionEvent -> {
            JViewport scrollPaneViewport = this.scrollPane.getViewport();
            Component view = scrollPaneViewport.getView();
            if (view == null) {
                return;
            }
            Point viewPosition = scrollPaneViewport.getViewPosition();
            int offsetX = this.autoScrollProperties.currentLocation.x - this.autoScrollProperties.startLocation.x;
            int offsetY = this.autoScrollProperties.currentLocation.y - this.autoScrollProperties.startLocation.y;
            offsetX = offsetX > 0 ? Math.max(0, offsetX - 4) : Math.min(0, offsetX + 4);
            offsetY = offsetY > 0 ? Math.max(0, offsetY - 4) : Math.min(0, offsetY + 4);
            viewPosition = new Point(viewPosition.x + offsetX, viewPosition.y + offsetY);
            Dimension extentSize = scrollPaneViewport.getExtentSize();
            Dimension viewSize = view.getSize();
            if (viewSize.width - viewPosition.x < extentSize.width) {
                viewPosition.x = viewSize.width - extentSize.width;
            }
            if (viewSize.height - viewPosition.y < extentSize.height) {
                viewPosition.y = viewSize.height - extentSize.height;
            }
            if (viewPosition.x < 0) {
                viewPosition.x = 0;
            }
            if (viewPosition.y < 0) {
                viewPosition.y = 0;
            }
            scrollPaneViewport.setViewPosition(viewPosition);
        };
        this.autoScrollProperties.timer = new Timer(50, actionListener);
        this.autoScrollProperties.timer.start();
        this.autoScrollProperties.toolkitListener = awtEvent -> {
            int eventID = awtEvent.getID();
            switch (eventID) {
                case 503: 
                case 506: {
                    JViewport scrollPaneViewport = this.scrollPane.getViewport();
                    this.autoScrollProperties.currentLocation = MouseInfo.getPointerInfo().getLocation();
                    SwingUtilities.convertPointFromScreen(this.autoScrollProperties.currentLocation, scrollPaneViewport);
                    if (this.autoScrollProperties.isDragMode || eventID != 506) break;
                    Dimension size = new Dimension(Math.abs(this.autoScrollProperties.currentLocation.x - this.autoScrollProperties.startLocation.x), Math.abs(this.autoScrollProperties.currentLocation.y - this.autoScrollProperties.startLocation.y));
                    this.autoScrollProperties.isDragMode = size.width > 14 || size.height > 14;
                    break;
                }
                case 501: 
                case 507: {
                    this.deactivateAutoScroll();
                    break;
                }
                case 502: {
                    if (!this.autoScrollProperties.isDragMode || ((MouseEvent)awtEvent).getButton() != 2) break;
                    this.deactivateAutoScroll();
                    break;
                }
                case 208: {
                    this.deactivateAutoScroll();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.autoScrollProperties.toolkitListener, 655408L);
    }

    private void configureScrollPane() {
        for (MouseListener mouseListener : this.scrollPane.getMouseListeners()) {
            if (!(mouseListener instanceof AutoScrollMouseListener)) continue;
            return;
        }
        this.scrollPane.addMouseListener(new AutoScrollMouseListener(this));
    }

    private Icon getAutoScrollIcon() {
        SubstanceIconPack iconPack = SubstanceCortex.GlobalScope.getIconPack();
        SubstanceColorScheme colorScheme = SubstanceCoreUtilities.getSkin(this.scrollPane).getEnabledColorScheme(SubstanceSlices.DecorationAreaType.NONE);
        if (this.scrollPane.getHorizontalScrollBar().isVisible()) {
            if (this.scrollPane.getVerticalScrollBar().isVisible()) {
                return iconPack.getScrollAllIcon(28, colorScheme);
            }
            return iconPack.getScrollHorizontalIcon(28, colorScheme);
        }
        return iconPack.getScrollVerticalIcon(28, colorScheme);
    }

    static void setAutoScrollEnabled(JScrollPane scrollPane, boolean isEnabled) {
        if (isEnabled) {
            new AutoScrollActivator(scrollPane);
        } else {
            for (MouseListener mouseListener : scrollPane.getMouseListeners()) {
                if (!(mouseListener instanceof AutoScrollMouseListener)) continue;
                scrollPane.removeMouseListener(mouseListener);
                return;
            }
        }
    }

    private static class AutoScrollMouseListener
    extends MouseAdapter {
        private AutoScrollActivator autoScrollActivator;

        public AutoScrollMouseListener(AutoScrollActivator autoScrollActivator) {
            this.autoScrollActivator = autoScrollActivator;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.autoScrollActivator.activateAutoScroll(e);
            }
        }
    }

    private static class AutoScrollProperties {
        public Point startLocation;
        public Point currentLocation;
        public Timer timer;
        public AWTEventListener toolkitListener;
        public boolean isDragMode;
        public JPopupMenu iconPopupMenu;

        private AutoScrollProperties() {
        }
    }
}

