/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMQualifiedElement;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.CloneUtil;

public class CIMProperty
extends CIMQualifiedElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private String originClass = "";
    private String overridingProperty;
    private boolean key;
    private boolean propagated = true;
    private CIMDataType type;
    private CIMValue value;

    public CIMProperty() {
        this("");
    }

    public CIMProperty(String name) {
        super(name);
    }

    public CIMProperty(String name, CIMValue value) {
        super(name);
        this.value = value;
        this.setPropagated(false);
    }

    public String getOriginClass() {
        return this.originClass;
    }

    public void setOriginClass(String originClass) {
        this.originClass = originClass == null ? "" : originClass;
    }

    public void setValue(CIMValue value) {
        if (value != null && this.isKey() && value.getType().isArrayType()) {
            throw new IllegalArgumentException("Key properties can't have array values: " + value.toString());
        }
        this.value = value;
        this.setPropagated(false);
    }

    public CIMValue getValue() {
        return this.value;
    }

    public void setType(CIMDataType type) {
        this.type = type;
    }

    public CIMDataType getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.value != null) {
            return this.value.getType();
        }
        return null;
    }

    public void setOverridingProperty(String name) {
        this.overridingProperty = name;
    }

    public String getOverridingProperty() {
        return this.overridingProperty;
    }

    public boolean isReference() {
        CIMDataType type = this.getType();
        if (type == null) {
            return false;
        }
        return type.getType() == 28;
    }

    public void addQualifier(CIMQualifier cq) throws CIMException {
        if (this.getQualifier(cq.getName()) != null) {
            throw new CIMException("CIM_ERR_ALREADY_EXISTS", cq);
        }
        if (cq.getName().equalsIgnoreCase("key") && cq.hasValue() && cq.getValue().getType().isArrayType()) {
            throw new IllegalArgumentException("Array properties can't be keys: " + cq.toString());
        }
        if (cq.getName().equalsIgnoreCase("key") && (!cq.hasValue() || cq.getValue().equals(CIMValue.TRUE))) {
            this.setKey(true);
        }
        super.addQualifier(cq);
    }

    public void setQualifiers(Vector qualifiers) {
        super.setQualifiers(qualifiers);
        Enumeration quals = qualifiers.elements();
        while (quals.hasMoreElements()) {
            CIMQualifier qualifier = (CIMQualifier)quals.nextElement();
            if (!qualifier.getName().equalsIgnoreCase("key")) continue;
            if (!qualifier.hasValue() || qualifier.getValue().equals(CIMValue.TRUE)) {
                this.setKey(true);
                break;
            }
            this.setKey(false);
            break;
        }
    }

    public synchronized Object clone() {
        return this.clone(true, true);
    }

    public synchronized Object clone(boolean includeQualifier, boolean includeClassOrigin) {
        return this.clone(includeQualifier, includeClassOrigin, false);
    }

    protected synchronized Object clone(boolean includeQualifier, boolean includeClassOrigin, boolean reset) {
        CIMProperty pe = new CIMProperty();
        pe.name = this.name;
        pe.type = this.type;
        pe.value = this.value;
        pe.overridingProperty = this.overridingProperty;
        pe.setKey(this.key);
        if (reset) {
            pe.setPropagated(true);
        } else {
            pe.setPropagated(this.propagated);
        }
        if (includeClassOrigin) {
            pe.originClass = this.originClass;
        }
        if (this.qualifiers != null && includeQualifier) {
            pe.qualifiers = CloneUtil.cloneQualifiers(this.qualifiers);
        }
        return pe;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public boolean isPropagated() {
        return this.propagated;
    }

    public void setPropagated(boolean propagated) {
        this.propagated = propagated;
    }
}

